/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.tile;

import java.util.List;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.ModSounds;
import net.blay09.mods.cookingforblockheads.api.SourceItem;
import net.blay09.mods.cookingforblockheads.api.capability.CapabilityKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IngredientPredicate;
import net.blay09.mods.cookingforblockheads.api.capability.KitchenItemProvider;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.network.VanillaPacketHandler;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.tile.DoorAnimator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import vazkii.quark.api.IDropoffManager;

@Optional.Interface(modid="quark", iface="vazkii.quark.api.IDropoffManager", striprefs=true)
public class TileFridge
extends TileEntity
implements ITickable,
IDropoffManager {
    private final ItemStackHandler itemHandler = new ItemStackHandler(27){

        protected void onContentsChanged(int slot) {
            TileFridge.this.isDirty = true;
            TileFridge.this.func_70296_d();
        }
    };
    private final KitchenItemProvider itemProvider = new KitchenItemProvider((IItemHandler)this.itemHandler){
        private final ItemStack snowStack;
        private final ItemStack iceStack;
        {
            this.snowStack = new ItemStack(Items.field_151126_ay);
            this.iceStack = new ItemStack(Blocks.field_150432_aD);
        }

        @Override
        @Nullable
        public SourceItem findSourceAndMarkAsUsed(IngredientPredicate predicate, int maxAmount, List<IKitchenItemProvider> inventories, boolean requireBucket, boolean simulate) {
            if (TileFridge.this.getBaseFridge().hasIceUpgrade && predicate.test(this.snowStack, 64)) {
                return new SourceItem(this, -1, ItemHandlerHelper.copyStackWithSize((ItemStack)this.snowStack, (int)maxAmount));
            }
            if (TileFridge.this.getBaseFridge().hasIceUpgrade && predicate.test(this.iceStack, 64)) {
                return new SourceItem(this, -1, ItemHandlerHelper.copyStackWithSize((ItemStack)this.iceStack, (int)maxAmount));
            }
            IngredientPredicate modifiedPredicate = predicate;
            if (TileFridge.this.getBaseFridge().hasPreservationUpgrade) {
                modifiedPredicate = (it, count) -> (count > 1 || !it.func_77973_b().getContainerItem(it).func_190926_b() || CookingRegistry.isToolItem(it)) && predicate.test(it, count);
            }
            return super.findSourceAndMarkAsUsed(modifiedPredicate, maxAmount, inventories, requireBucket, simulate);
        }
    };
    private final DoorAnimator doorAnimator = new DoorAnimator(this, 1, 2);
    private EnumDyeColor fridgeColor = EnumDyeColor.WHITE;
    private boolean isDirty;
    public boolean hasIceUpgrade;
    public boolean hasPreservationUpgrade;

    public TileFridge() {
        this.doorAnimator.setOpenRadius(2.0f);
        this.doorAnimator.setSoundEventOpen(ModSounds.fridgeOpen);
        this.doorAnimator.setSoundEventClose(ModSounds.fridgeClose);
    }

    public boolean hasIceUpgrade() {
        return this.hasIceUpgrade;
    }

    public void setHasIceUpgrade(boolean hasIceUpgrade) {
        this.hasIceUpgrade = hasIceUpgrade;
        this.markDirtyAndUpdate();
    }

    public boolean hasPreservationUpgrade() {
        return this.hasPreservationUpgrade;
    }

    public void setHasPreservationUpgrade(boolean hasPreservationUpgrade) {
        this.hasPreservationUpgrade = hasPreservationUpgrade;
        this.markDirtyAndUpdate();
    }

    public void setFridgeColor(EnumDyeColor fridgeColor) {
        this.fridgeColor = fridgeColor;
        this.markDirtyAndUpdate();
    }

    public void func_73660_a() {
        this.doorAnimator.update();
        if (this.isDirty) {
            VanillaPacketHandler.sendTileEntityUpdate(this);
            this.isDirty = false;
        }
    }

    public boolean func_145842_c(int id, int type) {
        return this.doorAnimator.receiveClientEvent(id, type) || super.func_145842_c(id, type);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.itemHandler.deserializeNBT(tagCompound.func_74775_l("ItemHandler"));
        this.fridgeColor = EnumDyeColor.func_176766_a((int)tagCompound.func_74771_c("FridgeColor"));
        this.hasIceUpgrade = tagCompound.func_74767_n("HasIceUpgrade");
        this.hasPreservationUpgrade = tagCompound.func_74767_n("HasPreservationUpgrade");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74782_a("ItemHandler", (NBTBase)this.itemHandler.serializeNBT());
        tagCompound.func_74774_a("FridgeColor", (byte)this.fridgeColor.func_176767_b());
        tagCompound.func_74757_a("HasIceUpgrade", this.hasIceUpgrade);
        tagCompound.func_74757_a("HasPreservationUpgrade", this.hasPreservationUpgrade);
        return tagCompound;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
        this.doorAnimator.setForcedOpen(pkt.func_148857_g().func_74767_n("IsForcedOpen"));
        this.doorAnimator.setNumPlayersUsing(pkt.func_148857_g().func_74771_c("NumPlayersUsing"));
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_189515_b(tagCompound);
        tagCompound.func_74757_a("IsForcedOpen", this.doorAnimator.isForcedOpen());
        tagCompound.func_74774_a("NumPlayersUsing", (byte)this.doorAnimator.getNumPlayersUsing());
        return tagCompound;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    @Nullable
    public TileFridge findNeighbourFridge() {
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()).func_177230_c() == ModBlocks.fridge) {
            return (TileFridge)this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a());
        }
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c() == ModBlocks.fridge) {
            return (TileFridge)this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
        }
        return null;
    }

    public TileFridge getBaseFridge() {
        TileFridge baseFridge;
        if (!this.func_145830_o()) {
            return this;
        }
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c() == ModBlocks.fridge && (baseFridge = (TileFridge)this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b())) != null) {
            return baseFridge;
        }
        return this;
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityKitchenItemProvider.CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.getCombinedItemHandler();
        }
        if (capability == CapabilityKitchenItemProvider.CAPABILITY) {
            return (T)this.itemProvider;
        }
        return (T)super.getCapability(capability, facing);
    }

    public EnumDyeColor getFridgeColor() {
        return this.fridgeColor;
    }

    public DoorAnimator getDoorAnimator() {
        return this.doorAnimator;
    }

    public IItemHandler getCombinedItemHandler() {
        TileFridge baseFridge = this.getBaseFridge();
        TileFridge neighbourFridge = baseFridge == this ? this.findNeighbourFridge() : this;
        if (neighbourFridge != null) {
            return new CombinedInvWrapper(new IItemHandlerModifiable[]{neighbourFridge.itemHandler, baseFridge.itemHandler});
        }
        return this.itemHandler;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public boolean acceptsDropoff(EntityPlayer entityPlayer) {
        return true;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 2), (double)(this.field_174879_c.func_177952_p() + 1));
    }

    public void markDirtyAndUpdate() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.markAndNotifyBlock(this.field_174879_c, this.field_145850_b.func_175726_f(this.field_174879_c), state, state, 3);
        this.func_70296_d();
    }
}

