/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.vanity.feature;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.arl.network.NetworkHandler;
import vazkii.aurelienribon.tweenengine.Tween;
import vazkii.quark.base.client.ContributorRewardHandler;
import vazkii.quark.base.client.ModKeybinds;
import vazkii.quark.base.client.gui.GuiButtonTranslucent;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.network.message.MessageRequestEmote;
import vazkii.quark.vanity.client.emotes.CustomEmoteIconResourcePack;
import vazkii.quark.vanity.client.emotes.EmoteBase;
import vazkii.quark.vanity.client.emotes.EmoteDescriptor;
import vazkii.quark.vanity.client.emotes.EmoteHandler;
import vazkii.quark.vanity.client.emotes.ModelAccessor;
import vazkii.quark.vanity.client.gui.GuiButtonEmote;

public class EmoteSystem
extends Feature {
    private static final String[] EMOTE_NAMES = new String[]{"no", "yes", "wave", "salute", "cheer", "clap", "think", "point", "shrug", "headbang", "weep", "facepalm"};
    private static final Set<String> PATREON_EMOTES = ImmutableSet.of((Object)"dance", (Object)"tpose", (Object)"dab", (Object)"jet", (Object)"exorcist", (Object)"zombie", (Object[])new String[0]);
    private static List<String> EMOTE_NAME_LIST = new ArrayList<String>(Arrays.asList(EMOTE_NAMES));
    private static final int EMOTE_BUTTON_START = 1800;
    static boolean emotesVisible = false;
    public static boolean customEmoteDebug;
    public static boolean emoteCommands;
    public static File emotesDir;
    @SideOnly(value=Side.CLIENT)
    public static CustomEmoteIconResourcePack resourcePack;
    private String[] enabledEmotes;
    private String[] customEmotes;
    private boolean enableKeybinds;

    @Override
    public void setupConfig() {
        this.enableKeybinds = this.loadPropBool("Enable Keybinds", "Should keybinds for emotes be generated? (They're all unbound by default)", true);
        this.enabledEmotes = this.loadPropStringList("Enabled Emotes", "The enabled default emotes. Remove from this list to disable them. You can also re-order them, if you feel like it.", EMOTE_NAMES);
        this.customEmotes = this.loadPropStringList("Custom Emotes", "The list of Custom Emotes to be loaded.\nWatch the tutorial on Custom Emotes to learn how to make your own: https://youtu.be/ourHUkan6aQ", new String[0]);
        customEmoteDebug = this.loadPropBool("Custom Emote Dev Mode", "Enable this to make custom emotes read the file every time they're triggered so you can edit on the fly.\nDO NOT ship enabled this in a modpack, please.", false);
        emoteCommands = this.loadPropBool("Custom Emote Functions", "Allow custom emotes to run function files when a user prompts them.\nTo attach a function file to any given emote, simply place a .mcfunction file with the same name as your .emote file (sans extension) in /quark_emotes.\nCommand output from emote functions is enabled only if both \"Custom Emote Dev Mode\" and the \"commandBlockOutput\" gamerule are enabled. ", false);
        emotesDir = new File(ModuleLoader.configFile.getParent(), "quark_emotes");
        if (!emotesDir.exists()) {
            emotesDir.mkdir();
        }
    }

    public static void addResourcePack(List<IResourcePack> packs) {
        resourcePack = new CustomEmoteIconResourcePack();
        packs.add((IResourcePack)resourcePack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInitClient(FMLPreInitializationEvent event) {
        Tween.registerAccessor(ModelBiped.class, new ModelAccessor());
        for (String string : this.enabledEmotes) {
            if (!EMOTE_NAME_LIST.contains(string)) continue;
            EmoteHandler.addEmote(string);
        }
        for (String s : PATREON_EMOTES) {
            EmoteHandler.addEmote(s);
        }
        for (String string : this.customEmotes) {
            EmoteHandler.addCustomEmote(string);
        }
        if (this.enableKeybinds) {
            ModKeybinds.initEmoteKeybinds();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void initGui(GuiScreenEvent.InitGuiEvent.Post event) {
        GuiScreen gui = event.getGui();
        if (gui instanceof GuiChat) {
            List list = event.getButtonList();
            list.add(new GuiButtonTranslucent(1800, gui.field_146294_l - 76, gui.field_146295_m - 40, 75, 20, I18n.func_135052_a((String)"quark.gui.emotes", (Object[])new Object[0])));
            int i = 0;
            int size = EmoteHandler.emoteMap.size() - 1;
            for (String key : EmoteHandler.emoteMap.keySet()) {
                EmoteDescriptor desc = EmoteHandler.emoteMap.get(key);
                int tier = desc.getTier();
                if (tier > ContributorRewardHandler.localPatronTier) continue;
                int x = gui.field_146294_l - (i % 3 + 1) * 25 - 1;
                int y = gui.field_146295_m - 65 - 25 * (size / 3 - i / 3);
                GuiButtonEmote button = new GuiButtonEmote(1800 + i + 1, x, y, desc);
                button.field_146125_m = emotesVisible;
                button.field_146124_l = emotesVisible;
                list.add(button);
                ++i;
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void performAction(GuiScreenEvent.ActionPerformedEvent.Pre event) {
        GuiButton button = event.getButton();
        if (button.field_146127_k == 1800) {
            event.getGui();
            List list = event.getButtonList();
            for (GuiButton b : list) {
                if (!(b instanceof GuiButtonEmote)) continue;
                b.field_146125_m = !b.field_146125_m;
                b.field_146124_l = !b.field_146124_l;
            }
            emotesVisible = !emotesVisible;
        } else if (button instanceof GuiButtonEmote) {
            String name = ((GuiButtonEmote)button).desc.getRegistryName();
            NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageRequestEmote(name));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71415_G && this.enableKeybinds) {
            for (KeyBinding key : ModKeybinds.emoteKeys.keySet()) {
                if (!key.func_151470_d()) continue;
                String emote = ModKeybinds.emoteKeys.get(key);
                NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageRequestEmote(emote));
                return;
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void drawHUD(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            Minecraft mc = Minecraft.func_71410_x();
            ScaledResolution res = event.getResolution();
            EmoteBase emote = EmoteHandler.getPlayerEmote((EntityPlayer)mc.field_71439_g);
            if (emote != null && emote.timeDone < emote.totalTime) {
                ResourceLocation resource = emote.desc.texture;
                int x = res.func_78326_a() / 2 - 16;
                int y = res.func_78328_b() / 2 - 60;
                float transparency = 1.0f;
                float tween = 5.0f;
                if (emote.timeDone < tween) {
                    transparency = emote.timeDone / tween;
                } else if (emote.timeDone > emote.totalTime - tween) {
                    transparency = (emote.totalTime - emote.timeDone) / tween;
                }
                GlStateManager.func_179094_E();
                GlStateManager.func_179140_f();
                GlStateManager.func_179147_l();
                GlStateManager.func_179118_c();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)transparency);
                mc.func_110434_K().func_110577_a(resource);
                GuiScreen.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)32, (int)32, (float)32.0f, (float)32.0f);
                GlStateManager.func_179147_l();
                String name = I18n.func_135052_a((String)emote.desc.getUnlocalizedName(), (Object[])new Object[0]);
                mc.field_71466_p.func_175063_a(name, (float)(res.func_78326_a() / 2 - mc.field_71466_p.func_78256_a(name) / 2), (float)(y + 34), 0xFFFFFF + ((int)(transparency * 255.0f) << 24));
                GlStateManager.func_179121_F();
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderTick(TickEvent.RenderTickEvent event) {
        EmoteHandler.onRenderTick(Minecraft.func_71410_x(), event.phase == TickEvent.Phase.START);
    }

    @Override
    public boolean hasSubscriptions() {
        return this.isClient();
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }
}

