/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.oddities.client.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBook;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import vazkii.quark.oddities.tile.TileMatrixEnchanter;

public class RenderTileMatrixEnchanter
extends TileEntitySpecialRenderer<TileMatrixEnchanter> {
    private static final ResourceLocation TEXTURE_BOOK = new ResourceLocation("textures/entity/enchanting_table_book.png");
    private final ModelBook modelBook = new ModelBook();

    public void render(TileMatrixEnchanter te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        float time = (float)te.tickCount + partialTicks;
        float f1 = te.bookRotation - te.bookRotationPrev;
        while ((double)f1 >= Math.PI) {
            f1 = (float)((double)f1 - Math.PI * 2);
        }
        while ((double)f1 < -Math.PI) {
            f1 = (float)((double)f1 + Math.PI * 2);
        }
        float rot = te.bookRotationPrev + f1 * partialTicks;
        float bookOpen = te.bookSpreadPrev + (te.bookSpread - te.bookSpreadPrev) * partialTicks;
        this.renderBook(te, time, rot, partialTicks);
        ItemStack item = te.func_70301_a(0);
        if (!item.func_190926_b()) {
            this.renderItem(item, time, bookOpen, rot);
        }
        GlStateManager.func_179121_F();
    }

    private void renderItem(ItemStack item, float time, float bookOpen, float rot) {
        GlStateManager.func_179094_E();
        RenderHelper.func_74519_b();
        GlStateManager.func_179109_b((float)0.5f, (float)0.8f, (float)0.5f);
        GlStateManager.func_179152_a((float)0.6f, (float)0.6f, (float)0.6f);
        rot *= -57.295776f;
        rot += 90.0f;
        GlStateManager.func_179114_b((float)(rot *= bookOpen), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)0.0, (double)(bookOpen * 1.4f), (double)Math.sin((double)bookOpen * Math.PI));
        GlStateManager.func_179114_b((float)(-90.0f * (bookOpen - 1.0f)), (float)1.0f, (float)0.0f, (float)0.0f);
        float trans = (float)Math.sin((double)time * 0.06) * bookOpen * 0.2f;
        GlStateManager.func_179109_b((float)0.0f, (float)trans, (float)0.0f);
        RenderItem render = Minecraft.func_71410_x().func_175599_af();
        render.func_181564_a(item, ItemCameraTransforms.TransformType.FIXED);
        RenderHelper.func_74518_a();
        GlStateManager.func_179121_F();
    }

    private void renderBook(TileMatrixEnchanter te, float time, float bookRot, float partialTicks) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.5f, (float)(0.85f + MathHelper.func_76126_a((float)(time * 0.1f)) * 0.01f), (float)0.5f);
        GlStateManager.func_179114_b((float)(-bookRot * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)80.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.func_147499_a(TEXTURE_BOOK);
        float f3 = te.pageFlipPrev + (te.pageFlip - te.pageFlipPrev) * partialTicks + 0.25f;
        float f4 = te.pageFlipPrev + (te.pageFlip - te.pageFlipPrev) * partialTicks + 0.75f;
        f3 = (f3 - (float)MathHelper.func_76140_b((double)f3)) * 1.6f - 0.3f;
        f4 = (f4 - (float)MathHelper.func_76140_b((double)f4)) * 1.6f - 0.3f;
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f4 < 0.0f) {
            f4 = 0.0f;
        }
        if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        if (f4 > 1.0f) {
            f4 = 1.0f;
        }
        float f5 = te.bookSpreadPrev + (te.bookSpread - te.bookSpreadPrev) * partialTicks;
        GlStateManager.func_179089_o();
        this.modelBook.func_78088_a((Entity)null, time, f3, f4, f5, 0.0f, 0.0625f);
        GlStateManager.func_179121_F();
    }
}

