/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.oddities.block;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.BlockWall;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import vazkii.arl.block.BlockMetaVariants;
import vazkii.arl.block.BlockModContainer;
import vazkii.quark.base.block.BlockQuarkWall;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.oddities.tile.TilePipe;

public class BlockPipe
extends BlockModContainer
implements IQuarkBlock {
    private static final AxisAlignedBB CENTER_AABB = new AxisAlignedBB(0.3125, 0.3125, 0.3125, 0.6875, 0.6875, 0.6875);
    private static final AxisAlignedBB DOWN_AABB = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.6875, 0.6875);
    private static final AxisAlignedBB UP_AABB = new AxisAlignedBB(0.3125, 0.3125, 0.3125, 0.6875, 1.0, 0.6875);
    private static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.3125, 0.3125, 0.0, 0.6875, 0.6875, 0.6875);
    private static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.3125, 0.3125, 0.3125, 0.6875, 0.6875, 1.0);
    private static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, 0.3125, 0.3125, 0.6875, 0.6875, 0.6875);
    private static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.3125, 0.3125, 0.3125, 1.0, 0.6875, 0.6875);
    public static final PropertyEnum<ConnectionType> DOWN = PropertyEnum.func_177709_a((String)"down", ConnectionType.class);
    public static final PropertyEnum<ConnectionType> UP = PropertyEnum.func_177709_a((String)"up", ConnectionType.class);
    public static final PropertyEnum<ConnectionType> NORTH = PropertyEnum.func_177709_a((String)"north", ConnectionType.class);
    public static final PropertyEnum<ConnectionType> SOUTH = PropertyEnum.func_177709_a((String)"south", ConnectionType.class);
    public static final PropertyEnum<ConnectionType> WEST = PropertyEnum.func_177709_a((String)"west", ConnectionType.class);
    public static final PropertyEnum<ConnectionType> EAST = PropertyEnum.func_177709_a((String)"east", ConnectionType.class);
    public static final PropertyBool ENABLED = PropertyBool.func_177716_a((String)"enabled");
    private static final PropertyEnum<ConnectionType>[] CONNECTIONS = new PropertyEnum[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};
    private static final AxisAlignedBB[] SIDE_BOXES = new AxisAlignedBB[]{DOWN_AABB, UP_AABB, NORTH_AABB, SOUTH_AABB, WEST_AABB, EAST_AABB};

    public BlockPipe() {
        super("pipe", Material.field_151592_s, new String[0]);
        this.func_149711_c(3.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149647_a(CreativeTabs.field_78028_d);
        this.setHarvestLevel("pickaxe", 1);
        this.func_180632_j(this.func_176223_P().func_177226_a(DOWN, (Comparable)((Object)ConnectionType.NONE)).func_177226_a(UP, (Comparable)((Object)ConnectionType.NONE)).func_177226_a(NORTH, (Comparable)((Object)ConnectionType.NONE)).func_177226_a(SOUTH, (Comparable)((Object)ConnectionType.NONE)).func_177226_a(WEST, (Comparable)((Object)ConnectionType.NONE)).func_177226_a(EAST, (Comparable)((Object)ConnectionType.NONE)).func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(true)));
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        boolean flag;
        boolean bl = flag = !worldIn.func_175640_z(pos);
        if (flag != (Boolean)state.func_177229_b((IProperty)ENABLED)) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(flag)), 6);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        double minX = BlockPipe.CENTER_AABB.field_72340_a;
        double minY = BlockPipe.CENTER_AABB.field_72338_b;
        double minZ = BlockPipe.CENTER_AABB.field_72339_c;
        double maxX = BlockPipe.CENTER_AABB.field_72336_d;
        double maxY = BlockPipe.CENTER_AABB.field_72337_e;
        double maxZ = BlockPipe.CENTER_AABB.field_72334_f;
        if (this.hasAnyConnection(state = this.func_176221_a(state, source, pos), EnumFacing.DOWN)) {
            minY = 0.0;
        }
        if (this.hasAnyConnection(state, EnumFacing.UP)) {
            maxY = 1.0;
        }
        if (this.hasAnyConnection(state, EnumFacing.NORTH)) {
            minZ = 0.0;
        }
        if (this.hasAnyConnection(state, EnumFacing.SOUTH)) {
            maxZ = 1.0;
        }
        if (this.hasAnyConnection(state, EnumFacing.WEST)) {
            minX = 0.0;
        }
        if (this.hasAnyConnection(state, EnumFacing.EAST)) {
            maxX = 1.0;
        }
        AxisAlignedBB aabb = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
        return aabb;
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return this.func_185496_a(state, (IBlockAccess)worldIn, pos).func_186670_a(pos);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean isActualState) {
        if (!isActualState) {
            state = this.func_176221_a(state, (IBlockAccess)worldIn, pos);
        }
        BlockPipe.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CENTER_AABB);
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (!this.hasAnyConnection(state, side)) continue;
            BlockPipe.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SIDE_BOXES[side.ordinal()]);
        }
    }

    private boolean hasAnyConnection(IBlockState state, EnumFacing side) {
        PropertyEnum<ConnectionType> prop = CONNECTIONS[side.ordinal()];
        return ((ConnectionType)((Object)state.func_177229_b(prop))).isSolid;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public IProperty[] getIgnoredProperties() {
        return new IProperty[]{ENABLED};
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{UP, DOWN, NORTH, SOUTH, WEST, EAST, ENABLED});
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)ENABLED) != false ? 0 : 1;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf((meta & 1) != 1));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IBlockState actualState = state;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            PropertyEnum<ConnectionType> prop = CONNECTIONS[facing.ordinal()];
            ConnectionType type = this.getConnectionTo(worldIn, pos, facing);
            actualState = actualState.func_177226_a(prop, (Comparable)((Object)type));
        }
        return actualState;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TilePipe) {
            return ((TilePipe)tile).getComparatorOutput();
        }
        return 0;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TilePipe) {
            ((TilePipe)tileentity).dropAllItems();
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TilePipe();
    }

    private ConnectionType getConnectionTo(IBlockAccess world, BlockPos pos, EnumFacing face) {
        TileEntity tile = world.func_175625_s(pos = pos.func_177972_a(face));
        if (tile != null) {
            if (tile instanceof TilePipe) {
                return ConnectionType.PIPE;
            }
            if (tile instanceof IInventory || tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face.func_176734_d()) && tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face.func_176734_d()) != null) {
                return ConnectionType.TERMINAL;
            }
        }
        IBlockState stateAt = world.func_180495_p(pos);
        Block blockAt = stateAt.func_177230_c();
        if (face.func_176740_k() == EnumFacing.Axis.Y && (blockAt instanceof BlockWall || blockAt instanceof BlockQuarkWall) || (blockAt instanceof BlockPistonBase || blockAt instanceof BlockPistonExtension) && stateAt.func_177229_b((IProperty)BlockDirectional.field_176387_N) == face.func_176734_d()) {
            return ConnectionType.PROP;
        }
        return ConnectionType.NONE;
    }

    public static enum ConnectionType implements BlockMetaVariants.EnumBase
    {
        NONE(false, false),
        PIPE(true, true),
        TERMINAL(true, true),
        PROP(true, false);

        public final boolean isSolid;
        public final boolean allowsItems;

        private ConnectionType(boolean isSolid, boolean allowsItems) {
            this.isSolid = isSolid;
            this.allowsItems = allowsItems;
        }
    }
}

