/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.misc.feature;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiBeacon;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionHelper;
import net.minecraft.potion.PotionType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vazkii.arl.util.ProxyRegistry;
import vazkii.quark.base.handler.BeaconReplacementHandler;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.potion.PotionMod;
import vazkii.quark.misc.feature.BlackAsh;
import vazkii.quark.world.feature.Biotite;
import vazkii.quark.world.feature.UndergroundBiomes;

public class ExtraPotions
extends Feature {
    public static Potion dangerSight;
    private boolean started = false;
    boolean enableHaste;
    boolean enableResistance;
    boolean enableDangerSight;
    boolean forceQuartzForResistance;
    boolean forceClownfishForDangerSight;
    String[] replacements;

    @Override
    public void setupConfig() {
        this.enableHaste = this.loadPropBool("Enable Haste Potion", "", true);
        this.enableResistance = this.loadPropBool("Enable Resistance Potion", "", true);
        this.enableDangerSight = this.loadPropBool("Enable Danger Sight Potion", "", true);
        this.forceQuartzForResistance = this.loadPropBool("Force Quartz for Resistance", "Always use Quartz instead of Biotite, even if Biotite is available.", false);
        this.forceClownfishForDangerSight = this.loadPropBool("Force Clownfish for Danger Sight", "Always use Clownfish instead of Glowshroom, even if Glowshroom is available.", this.forceClownfishForDangerSight);
        String comment = "A list of potentially context sensitive replacements to apply to the beacon effect list.\nThis system allows the potion effects in a beacon to change based on if there's specific blocks on top of the pyramid at the same layer as the beacon.\nLines are processed in the order you add them.\nEach line is a comma separated list in the following format:\nblock,meta,layer,index,potion\n\nEach value is as follows:\nblock: A block ID of a block to check against when applying this replacement. You can leave this empty if you always want to apply the replacement\nmeta: The metadata of the block to check against, or -1 if any metadata will work. You must include this even if block is empty\nlayer: The layer of the beacon that contains the effect you want to replace (range: 0-3)\nindex: The effect in that layer you want to replace (range: 0-1, just 0 if it's layers 2 or 3)\npotion: The ID for the potion to replace. Note: modded potions won't dispay the icons properly\n\nExamples:\nminecraft:sea_lantern,-1,0,1,minecraft:water_breathing -> Replace Haste with Water Breathing if there's a Sea Lantern next to the beacon\n,-1,1,0,minecraft:levitation -> Always replace Resistance with Levitation";
        this.replacements = this.loadPropStringList("Beacon Replacements", comment, new String[0]);
        if (this.started) {
            BeaconReplacementHandler.parse(this.replacements);
        }
        this.started = true;
    }

    @Override
    public void postPreInit(FMLPreInitializationEvent event) {
        if (this.enableHaste) {
            this.addStandardBlend(MobEffects.field_76422_e, Items.field_179563_cD, MobEffects.field_76419_f);
        }
        if (this.enableResistance) {
            this.addStandardBlend(MobEffects.field_76429_m, Biotite.biotite == null || this.forceQuartzForResistance ? Items.field_151128_bU : Biotite.biotite);
        }
        if (this.enableDangerSight) {
            dangerSight = new PotionMod("danger_sight", false, 575715, 1).func_188413_j();
            this.addStandardBlend(dangerSight, UndergroundBiomes.glowshroom == null || this.forceClownfishForDangerSight ? new ItemStack(Items.field_151115_aP, 1, 2) : UndergroundBiomes.glowshroom, null, 3600, 9600, 0);
        }
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        BeaconReplacementHandler.parse(this.replacements);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void clientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (this.enableDangerSight && event.phase == TickEvent.Phase.START && mc.field_71439_g != null && mc.field_71439_g.func_70660_b(dangerSight) != null && !mc.func_147113_T()) {
            int range = 12;
            WorldClient world = mc.field_71441_e;
            Iterable positions = BlockPos.func_177980_a((BlockPos)mc.field_71439_g.func_180425_c().func_177982_a(-range, -range, -range), (BlockPos)mc.field_71439_g.func_180425_c().func_177982_a(range, range, range));
            for (BlockPos pos : positions) {
                if (!((double)world.field_73012_v.nextFloat() < 0.1) || !this.canMobsSpawnInPos((World)world, pos)) continue;
                float x = (float)pos.func_177958_n() + 0.3f + world.field_73012_v.nextFloat() * 0.4f;
                float y = pos.func_177956_o();
                float z = (float)pos.func_177952_p() + 0.3f + world.field_73012_v.nextFloat() * 0.4f;
                world.func_175688_a(EnumParticleTypes.SPELL_MOB, (double)x, (double)y, (double)z, (double)world.field_73012_v.nextFloat() < 0.9 ? 0.0 : 1.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onGuiOpen(GuiOpenEvent event) {
        if (event.getGui() instanceof GuiBeacon) {
            Minecraft mc = Minecraft.func_71410_x();
            TileEntity lookTe = mc.field_71441_e.func_175625_s(mc.field_71476_x.func_178782_a());
            if (lookTe instanceof TileEntityBeacon) {
                BeaconReplacementHandler.update((TileEntityBeacon)lookTe);
            }
        }
    }

    private boolean canMobsSpawnInPos(World world, BlockPos pos) {
        if (world.isSideSolid(pos.func_177977_b(), EnumFacing.UP) && !world.func_175677_d(pos, false) && !world.func_175677_d(pos.func_177984_a(), false) && !world.func_180495_p(pos).func_185904_a().func_76224_d()) {
            IBlockState state = world.func_180495_p(pos);
            if (ModuleLoader.isFeatureEnabled(BlackAsh.class) && state.func_177230_c() == BlackAsh.black_ash || world.func_180495_p(pos.func_177979_c(2)).func_177230_c() == BlackAsh.black_ash) {
                return false;
            }
            int lightLevel = world.func_175642_b(EnumSkyBlock.BLOCK, pos);
            return lightLevel < 8 && (world.func_175623_d(pos) || state.func_185890_d((IBlockAccess)world, pos) == null);
        }
        return false;
    }

    private void addStandardBlend(Potion type, Object reagent) {
        this.addStandardBlend(type, reagent, null);
    }

    private void addStandardBlend(Potion type, Object reagent, Potion negation) {
        this.addStandardBlend(type, reagent, negation, 3600, 9600, 1800);
    }

    private void addStandardBlend(Potion type, Object reagent, Potion negation, int normalTime, int longTime, int strongTime) {
        PotionType strongType;
        String baseName = type.getRegistryName().func_110623_a();
        boolean hasStrong = strongTime > 0;
        PotionType normalType = this.addPotion(new PotionEffect(type, normalTime), baseName, baseName);
        PotionType longType = this.addPotion(new PotionEffect(type, longTime), baseName, "long_" + baseName);
        PotionType potionType = strongType = !hasStrong ? null : this.addPotion(new PotionEffect(type, strongTime, 1), baseName, "strong_" + baseName);
        if (reagent instanceof Item) {
            reagent = Ingredient.func_193367_a((Item)((Item)reagent));
        } else if (reagent instanceof Block) {
            reagent = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ProxyRegistry.newStack((Block)((Block)reagent))});
        } else if (reagent instanceof ItemStack) {
            reagent = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{(ItemStack)reagent});
        } else if (reagent instanceof String) {
            reagent = new OreIngredient((String)reagent);
        }
        if (!(reagent instanceof Ingredient)) {
            throw new IllegalArgumentException("Reagent can't be " + reagent.getClass());
        }
        PotionHelper.func_193356_a((PotionType)PotionTypes.field_185233_e, (Ingredient)((Ingredient)reagent), (PotionType)normalType);
        PotionHelper.func_193356_a((PotionType)PotionTypes.field_185230_b, (Ingredient)((Ingredient)reagent), (PotionType)PotionTypes.field_185231_c);
        if (hasStrong) {
            PotionHelper.func_193357_a((PotionType)normalType, (Item)Items.field_151114_aO, (PotionType)strongType);
        }
        PotionHelper.func_193357_a((PotionType)normalType, (Item)Items.field_151137_ax, (PotionType)longType);
        if (negation != null) {
            String negationBaseName = negation.getRegistryName().func_110623_a();
            PotionType normalNegationType = this.addPotion(new PotionEffect(negation, normalTime), negationBaseName, negationBaseName);
            PotionType longNegationType = this.addPotion(new PotionEffect(negation, longTime), negationBaseName, "long_" + negationBaseName);
            PotionType strongNegationType = !hasStrong ? null : this.addPotion(new PotionEffect(negation, strongTime, 1), negationBaseName, "strong_" + negationBaseName);
            PotionHelper.func_193357_a((PotionType)normalType, (Item)Items.field_151071_bq, (PotionType)normalNegationType);
            if (hasStrong) {
                PotionHelper.func_193357_a((PotionType)strongType, (Item)Items.field_151071_bq, strongNegationType);
            }
            PotionHelper.func_193357_a((PotionType)longType, (Item)Items.field_151071_bq, (PotionType)longNegationType);
        }
    }

    private PotionType addPotion(PotionEffect eff, String baseName, String name) {
        PotionType type = (PotionType)new PotionType(baseName, new PotionEffect[]{eff}).setRegistryName(new ResourceLocation("quark", name));
        ProxyRegistry.register((IForgeRegistryEntry)type);
        return type;
    }

    @Override
    public boolean hasSubscriptions() {
        return this.isClient();
    }
}

