/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.experimental.lighting;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import vazkii.quark.base.lib.LibObfuscation;
import vazkii.quark.experimental.features.ColoredLights;
import vazkii.quark.experimental.lighting.ColoredLightSystem;

public class BlockTinter {
    private static DynamicTexture lightmapTex;

    public static void tintBlockFlat(IBlockAccess world, IBlockState state, BlockPos pos, BufferBuilder buffer, BakedQuad quad, int lightColor) {
        if ((lightColor & 0xF0) == 0) {
            return;
        }
        float[] colors = ColoredLightSystem.getLightColor(world, pos.func_177972_a(quad.func_178210_d()));
        if (ColoredLights.cullToLightmap) {
            colors = BlockTinter.cullColorsToLightmap(colors, lightColor);
        }
        if (colors.length > 0) {
            int i;
            float[] quadTint = BlockTinter.tintQuad(quad, state, world, pos, buffer);
            if (quadTint != null) {
                for (i = 0; i < 3; ++i) {
                    int n = i;
                    colors[n] = colors[n] * quadTint[i];
                }
            }
            for (i = 1; i < 5; ++i) {
                buffer.func_178978_a(colors[0], colors[1], colors[2], i);
            }
        }
    }

    private static float[] tintQuad(BakedQuad bakedquad, IBlockState stateIn, IBlockAccess blockAccessIn, BlockPos posIn, BufferBuilder buffer) {
        if (bakedquad.func_178212_b()) {
            int k = Minecraft.func_71410_x().func_184125_al().func_186724_a(stateIn, blockAccessIn, posIn, bakedquad.func_178211_c());
            if (EntityRenderer.field_78517_a) {
                k = TextureUtil.func_177054_c((int)k);
            }
            float f = (float)(k >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(k >> 8 & 0xFF) / 255.0f;
            float f2 = (float)(k & 0xFF) / 255.0f;
            if (bakedquad.shouldApplyDiffuseLighting()) {
                float diffuse = LightUtil.diffuseLight((EnumFacing)bakedquad.func_178210_d());
                f *= diffuse;
                f1 *= diffuse;
                f2 *= diffuse;
            }
            return new float[]{f, f1, f2};
        }
        if (bakedquad.shouldApplyDiffuseLighting()) {
            float diffuse = LightUtil.diffuseLight((EnumFacing)bakedquad.func_178210_d());
            return new float[]{diffuse, diffuse, diffuse};
        }
        return null;
    }

    private static float[] cullColorsToLightmap(float[] colors, int lightmapPos) {
        if (colors.length < 3) {
            return colors;
        }
        int sunlight = (lightmapPos & 0xF00000) >> 20;
        int index = sunlight * 16;
        int[] lightmap = BlockTinter.getLightmapColors();
        int lightmapColor = lightmap[index];
        float r = (float)(lightmapColor >> 16 & 0xFF) / 255.0f;
        float g = (float)(lightmapColor >> 8 & 0xFF) / 255.0f;
        float b = (float)(lightmapColor >> 0 & 0xFF) / 255.0f;
        return new float[]{Math.max(r, colors[0]), Math.max(g, colors[1]), Math.max(b, colors[2])};
    }

    private static int[] getLightmapColors() {
        if (lightmapTex == null) {
            lightmapTex = (DynamicTexture)ReflectionHelper.getPrivateValue(EntityRenderer.class, (Object)Minecraft.func_71410_x().field_71460_t, (String[])LibObfuscation.LIGHTMAP_TEXTURE);
        }
        return lightmapTex.func_110565_c();
    }
}

