/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.decoration.feature;

import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.arl.recipe.RecipeHandler;
import vazkii.arl.util.ProxyRegistry;
import vazkii.quark.base.lib.LibMisc;
import vazkii.quark.base.module.Feature;
import vazkii.quark.decoration.block.BlockCandle;
import vazkii.quark.decoration.item.ItemTallow;

public class TallowAndCandles
extends Feature {
    public static Item tallow;
    public static Block candle;
    public static boolean candlesFall;
    public static float enchantPower;
    boolean enableTallow;
    int minDrop;
    int maxDrop;
    int candlesCrafted;
    int tallowBurnTime;

    @Override
    public void setupConfig() {
        candlesFall = this.loadPropBool("Candles Fall", "Set to false to disable candles falling like sand.", true);
        this.enableTallow = this.loadPropBool("Enable Tallow", "Turn this off if you don't want Tallow. This won't disable the candles, but will disable their recipes.", true);
        this.minDrop = this.loadPropInt("Min Tallow Dropped", "", 1);
        this.maxDrop = this.loadPropInt("Max Tallow Dropped", "", 3);
        this.candlesCrafted = this.loadPropInt("Candles Crafted", "", 2);
        this.tallowBurnTime = this.loadPropInt("Tallow Burn Time", "", 200);
        enchantPower = (float)this.loadPropDouble("Enchantment Power", "How much power candles provide to enchanting tables. 1 = 1 bookshelf", 0.5);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        candle = new BlockCandle();
        if (this.enableTallow) {
            tallow = new ItemTallow();
            RecipeHandler.addOreDictRecipe((ItemStack)ProxyRegistry.newStack((Block)candle, (int)this.candlesCrafted), (Object[])new Object[]{"S", "T", "T", Character.valueOf('S'), "string", Character.valueOf('T'), "tallow"});
        }
        ItemStack baseCandle = ProxyRegistry.newStack((Block)candle);
        for (int i = 0; i < 16; ++i) {
            String dye = LibMisc.OREDICT_DYES.get(15 - i);
            RecipeHandler.addShapelessOreDictRecipe((ItemStack)ProxyRegistry.newStack((Block)candle, (int)1, (int)i), (Object[])new Object[]{baseCandle, dye});
            RecipeHandler.addShapelessOreDictRecipe((ItemStack)ProxyRegistry.newStack((Block)candle, (int)8, (int)i), (Object[])new Object[]{baseCandle, baseCandle, baseCandle, baseCandle, baseCandle, baseCandle, baseCandle, baseCandle, dye});
        }
        TallowAndCandles.addOreDict("tallow", tallow);
        TallowAndCandles.addOreDict("blockCandle", ProxyRegistry.newStack((Block)candle, (int)1, (int)Short.MAX_VALUE));
    }

    @SubscribeEvent
    public void onDrops(LivingDropsEvent event) {
        int drops;
        EntityLivingBase e = event.getEntityLiving();
        if (this.enableTallow && e instanceof EntityPig && this.maxDrop > 0 && (drops = this.minDrop + e.field_70170_p.field_73012_v.nextInt(this.maxDrop - this.minDrop + 1)) > 0) {
            event.getDrops().add(new EntityItem(e.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v, new ItemStack(tallow, drops)));
        }
    }

    @SubscribeEvent
    public void onFurnaceTimeCheck(FurnaceFuelBurnTimeEvent event) {
        if (event.getItemStack().func_77973_b() == tallow && this.tallowBurnTime > 0) {
            event.setBurnTime(this.tallowBurnTime);
        }
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}

