/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.world.schematic;

import com.github.lunatrius.schematica.api.ISchematic;
import com.github.lunatrius.schematica.nbt.NBTHelper;
import com.github.lunatrius.schematica.reference.Reference;
import com.github.lunatrius.schematica.world.schematic.SchematicFormat;
import com.github.lunatrius.schematica.world.schematic.SchematicUtil;
import com.github.lunatrius.schematica.world.storage.Schematic;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.gen.structure.template.Template;

public class SchematicStructure
extends SchematicFormat {
    @Override
    public ISchematic readFromNBT(NBTTagCompound tagCompound) {
        ItemStack icon = SchematicUtil.getIconFromNBT(tagCompound);
        Template template = new Template();
        template.func_186256_b(tagCompound);
        Schematic schematic = new Schematic(icon, template.field_186272_c.func_177958_n(), template.field_186272_c.func_177956_o(), template.field_186272_c.func_177952_p(), template.func_186261_b());
        for (Template.BlockInfo block : template.field_186270_a) {
            schematic.setBlockState(block.field_186242_a, block.field_186243_b);
            if (block.field_186244_c == null) continue;
            try {
                block.field_186244_c.func_74768_a("x", block.field_186242_a.func_177958_n());
                block.field_186244_c.func_74768_a("y", block.field_186242_a.func_177956_o());
                block.field_186244_c.func_74768_a("z", block.field_186242_a.func_177952_p());
                TileEntity tileEntity = NBTHelper.readTileEntityFromCompound(block.field_186244_c);
                if (tileEntity == null) continue;
                schematic.setTileEntity(block.field_186242_a, tileEntity);
            }
            catch (Exception e) {
                Reference.logger.error("TileEntity failed to load properly!", (Throwable)e);
            }
        }
        return schematic;
    }

    @Override
    public boolean writeToNBT(NBTTagCompound tagCompound, ISchematic schematic) {
        Template template = new Template();
        template.field_186272_c = new BlockPos(schematic.getWidth(), schematic.getHeight(), schematic.getLength());
        template.func_186252_a(schematic.getAuthor());
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)BlockPos.field_177992_a, (BlockPos)template.field_186272_c.func_177982_a(-1, -1, -1))) {
            NBTTagCompound compound;
            TileEntity tileEntity = schematic.getTileEntity(pos);
            if (tileEntity != null) {
                compound = NBTHelper.writeTileEntityToCompound(tileEntity);
                compound.func_82580_o("x");
                compound.func_82580_o("y");
                compound.func_82580_o("z");
            } else {
                compound = null;
            }
            template.field_186270_a.add(new Template.BlockInfo(pos, schematic.getBlockState(pos), compound));
        }
        for (Entity entity : schematic.getEntities()) {
            try {
                Vec3d vec3d = new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                entity.func_70039_c(nbttagcompound);
                BlockPos blockpos = new BlockPos(vec3d);
                template.field_186271_b.add(new Template.EntityInfo(vec3d, blockpos, nbttagcompound));
            }
            catch (Throwable t) {
                Reference.logger.error("Entity {} failed to save, skipping!", (Object)entity, (Object)t);
            }
        }
        template.func_189552_a(tagCompound);
        return true;
    }

    @Override
    public String getName() {
        return "schematica.format.structure";
    }

    @Override
    public String getExtension() {
        return ".nbt";
    }
}

