/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.handler;

import com.github.lunatrius.schematica.Schematica;
import com.github.lunatrius.schematica.reference.Reference;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigurationHandler {
    public static final ConfigurationHandler INSTANCE = new ConfigurationHandler();
    public static final String VERSION = "1";
    public static Configuration configuration;
    public static final boolean DUMP_BLOCK_LIST_DEFAULT = false;
    public static final boolean SHOW_DEBUG_INFO_DEFAULT = true;
    public static final boolean ENABLE_ALPHA_DEFAULT = false;
    public static final double ALPHA_DEFAULT = 1.0;
    public static final boolean HIGHLIGHT_DEFAULT = true;
    public static final boolean HIGHLIGHT_AIR_DEFAULT = true;
    public static final double BLOCK_DELTA_DEFAULT = 0.005;
    public static final int RENDER_DISTANCE_DEFAULT = 8;
    public static final int PLACE_DELAY_DEFAULT = 1;
    public static final int TIMEOUT_DEFAULT = 10;
    public static final int PLACE_DISTANCE_DEFAULT = 5;
    public static final boolean PLACE_INSTANTLY_DEFAULT = false;
    public static final boolean DESTROY_BLOCKS_DEFAULT = false;
    public static final boolean DESTROY_INSTANTLY_DEFAULT = false;
    public static final boolean PLACE_ADJACENT_DEFAULT = true;
    public static final boolean[] SWAP_SLOTS_DEFAULT;
    public static final String SCHEMATIC_DIRECTORY_STR = "./schematics";
    public static final File SCHEMATIC_DIRECTORY_DEFAULT;
    public static final String[] EXTRA_AIR_BLOCKS_DEFAULT;
    public static final String SORT_TYPE_DEFAULT = "";
    public static final boolean PRINTER_ENABLED_DEFAULT = true;
    public static final boolean SAVE_ENABLED_DEFAULT = true;
    public static final boolean LOAD_ENABLED_DEFAULT = true;
    public static final int PLAYER_QUOTA_KILOBYTES_DEFAULT = 8192;
    public static boolean dumpBlockList;
    public static boolean showDebugInfo;
    public static boolean enableAlpha;
    public static float alpha;
    public static boolean highlight;
    public static boolean highlightAir;
    public static double blockDelta;
    public static int renderDistance;
    public static int placeDelay;
    public static int timeout;
    public static int placeDistance;
    public static boolean placeInstantly;
    public static boolean destroyBlocks;
    public static boolean destroyInstantly;
    public static boolean placeAdjacent;
    public static boolean[] swapSlots;
    public static final Queue<Integer> swapSlotsQueue;
    public static File schematicDirectory;
    public static String[] extraAirBlocks;
    public static String sortType;
    public static boolean printerEnabled;
    public static boolean saveEnabled;
    public static boolean loadEnabled;
    public static int playerQuotaKilobytes;
    public static Property propDumpBlockList;
    public static Property propShowDebugInfo;
    public static Property propEnableAlpha;
    public static Property propAlpha;
    public static Property propHighlight;
    public static Property propHighlightAir;
    public static Property propBlockDelta;
    public static Property propRenderDistance;
    public static Property propPlaceDelay;
    public static Property propTimeout;
    public static Property propPlaceDistance;
    public static Property propPlaceInstantly;
    public static Property propDestroyBlocks;
    public static Property propDestroyInstantly;
    public static Property propPlaceAdjacent;
    public static Property[] propSwapSlots;
    public static Property propSchematicDirectory;
    public static Property propExtraAirBlocks;
    public static Property propSortType;
    public static Property propPrinterEnabled;
    public static Property propSaveEnabled;
    public static Property propLoadEnabled;
    public static Property propPlayerQuotaKilobytes;
    private static final Set<Block> extraAirBlockList;

    public static void init(File configFile) {
        if (configuration == null) {
            configuration = new Configuration(configFile, VERSION);
            ConfigurationHandler.loadConfiguration();
        }
    }

    public static void loadConfiguration() {
        ConfigurationHandler.loadConfigurationDebug();
        ConfigurationHandler.loadConfigurationRender();
        ConfigurationHandler.loadConfigurationPrinter();
        ConfigurationHandler.loadConfigurationSwapSlots();
        ConfigurationHandler.loadConfigurationGeneral();
        ConfigurationHandler.loadConfigurationServer();
        Schematica.proxy.createFolders();
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    private static void loadConfigurationDebug() {
        propDumpBlockList = configuration.get("debug", "dumpBlockList", false, "Dump all block states on startup.");
        propDumpBlockList.setLanguageKey("schematica.config.dumpBlockList");
        propDumpBlockList.requiresMcRestart();
        dumpBlockList = propDumpBlockList.getBoolean(false);
        propShowDebugInfo = configuration.get("debug", "showDebugInfo", true, "Display extra information on the debug screen (F3).");
        propShowDebugInfo.setLanguageKey("schematica.config.showDebugInfo");
        showDebugInfo = propShowDebugInfo.getBoolean(true);
    }

    private static void loadConfigurationRender() {
        propEnableAlpha = configuration.get("render", "alphaEnabled", false, "Enable transparent textures.");
        propEnableAlpha.setLanguageKey("schematica.config.alphaEnabled");
        enableAlpha = propEnableAlpha.getBoolean(false);
        propAlpha = configuration.get("render", "alpha", 1.0, "Alpha value used when rendering the schematic (1.0 = opaque, 0.5 = half transparent, 0.0 = transparent).", 0.0, 1.0);
        propAlpha.setLanguageKey("schematica.config.alpha");
        alpha = (float)propAlpha.getDouble(1.0);
        propHighlight = configuration.get("render", "highlight", true, "Highlight invalid placed blocks and to be placed blocks.");
        propHighlight.setLanguageKey("schematica.config.highlight");
        highlight = propHighlight.getBoolean(true);
        propHighlightAir = configuration.get("render", "highlightAir", true, "Highlight blocks that should be air.");
        propHighlightAir.setLanguageKey("schematica.config.highlightAir");
        highlightAir = propHighlightAir.getBoolean(true);
        propBlockDelta = configuration.get("render", "blockDelta", 0.005, "Delta value used for highlighting (if you experience z-fighting increase this).", 0.0, 0.2);
        propBlockDelta.setLanguageKey("schematica.config.blockDelta");
        blockDelta = propBlockDelta.getDouble(0.005);
        propRenderDistance = configuration.get("render", "renderDistance", 8, "Schematic render distance.", 2, 16);
        propRenderDistance.setLanguageKey("schematica.config.renderDistance");
        renderDistance = propRenderDistance.getInt(8);
    }

    private static void loadConfigurationPrinter() {
        propPlaceDelay = configuration.get("printer", "placeDelay", 1, "Delay between placement attempts (in ticks).", 0, 20);
        propPlaceDelay.setLanguageKey("schematica.config.placeDelay");
        placeDelay = propPlaceDelay.getInt(1);
        propTimeout = configuration.get("printer", "timeout", 10, "Timeout before re-trying failed blocks.", 0, 100);
        propTimeout.setLanguageKey("schematica.config.timeout");
        timeout = propTimeout.getInt(10);
        propPlaceDistance = configuration.get("printer", "placeDistance", 5, "Maximum placement distance.", 1, 5);
        propPlaceDistance.setLanguageKey("schematica.config.placeDistance");
        placeDistance = propPlaceDistance.getInt(5);
        propPlaceInstantly = configuration.get("printer", "placeInstantly", false, "Place all blocks that can be placed in one tick.");
        propPlaceInstantly.setLanguageKey("schematica.config.placeInstantly");
        placeInstantly = propPlaceInstantly.getBoolean(false);
        propDestroyBlocks = configuration.get("printer", "destroyBlocks", false, "The printer will destroy blocks (creative mode only).");
        propDestroyBlocks.setLanguageKey("schematica.config.destroyBlocks");
        destroyBlocks = propDestroyBlocks.getBoolean(false);
        propDestroyInstantly = configuration.get("printer", "destroyInstantly", false, "Destroy all blocks that can be destroyed in one tick.");
        propDestroyInstantly.setLanguageKey("schematica.config.destroyInstantly");
        destroyInstantly = propDestroyInstantly.getBoolean(false);
        propPlaceAdjacent = configuration.get("printer", "placeAdjacent", true, "Place blocks only if there is an adjacent block next to them.");
        propPlaceAdjacent.setLanguageKey("schematica.config.placeAdjacent");
        placeAdjacent = propPlaceAdjacent.getBoolean(true);
    }

    private static void loadConfigurationSwapSlots() {
        swapSlotsQueue.clear();
        for (int i = 0; i < SWAP_SLOTS_DEFAULT.length; ++i) {
            ConfigurationHandler.propSwapSlots[i] = configuration.get("printer.swapslots", "swapSlot" + i, SWAP_SLOTS_DEFAULT[i], "Allow the printer to use this hotbar slot.");
            propSwapSlots[i].setLanguageKey("schematica.config.swapSlot" + i);
            ConfigurationHandler.swapSlots[i] = propSwapSlots[i].getBoolean(SWAP_SLOTS_DEFAULT[i]);
            if (!swapSlots[i]) continue;
            swapSlotsQueue.offer(i);
        }
    }

    private static void loadConfigurationGeneral() {
        propSchematicDirectory = configuration.get("general", "schematicDirectory", SCHEMATIC_DIRECTORY_STR, "Schematic directory.");
        propSchematicDirectory.setLanguageKey("schematica.config.schematicDirectory");
        schematicDirectory = ConfigurationHandler.getSchematicDirectoryFile(propSchematicDirectory.getString());
        propExtraAirBlocks = configuration.get("general", "extraAirBlocks", EXTRA_AIR_BLOCKS_DEFAULT, "Extra blocks to consider as air for the schematic renderer.");
        propExtraAirBlocks.setLanguageKey("schematica.config.extraAirBlocks");
        extraAirBlocks = propExtraAirBlocks.getStringList();
        propSortType = configuration.get("general", "sortType", SORT_TYPE_DEFAULT, "Default sort type for the material list.");
        propSortType.setShowInGui(false);
        sortType = propSortType.getString();
        ConfigurationHandler.normalizeSchematicPath();
        ConfigurationHandler.populateExtraAirBlocks();
    }

    private static File getSchematicDirectoryFile(String path) {
        if (path.startsWith(".")) {
            return Schematica.proxy.getDirectory(path);
        }
        return new File(path);
    }

    private static void normalizeSchematicPath() {
        try {
            schematicDirectory = schematicDirectory.getCanonicalFile();
            String schematicPath = schematicDirectory.getAbsolutePath();
            String dataPath = Schematica.proxy.getDataDirectory().getAbsolutePath();
            String newSchematicPath = ConfigurationHandler.mergePaths(schematicPath, dataPath);
            propSchematicDirectory.set(newSchematicPath);
            Reference.logger.debug("Schematic path: {}", (Object)schematicPath);
            Reference.logger.debug("Data path: {}", (Object)dataPath);
            Reference.logger.debug("New schematic path: {}", (Object)newSchematicPath);
        }
        catch (IOException e) {
            Reference.logger.warn("Could not canonize path!", (Throwable)e);
        }
    }

    private static String mergePaths(String schematicPath, String dataPath) {
        String newPath = schematicPath.startsWith(dataPath) ? "." + schematicPath.substring(dataPath.length()) : schematicPath;
        return newPath.replace("\\", "/");
    }

    private static void populateExtraAirBlocks() {
        extraAirBlockList.clear();
        for (String name : extraAirBlocks) {
            Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(name));
            if (block == Blocks.field_150350_a) continue;
            extraAirBlockList.add(block);
        }
    }

    private static void loadConfigurationServer() {
        propPrinterEnabled = configuration.get("server", "printerEnabled", true, "Allow players to use the printer.");
        propPrinterEnabled.setLanguageKey("schematica.config.printerEnabled");
        printerEnabled = propPrinterEnabled.getBoolean(true);
        propSaveEnabled = configuration.get("server", "saveEnabled", true, "Allow players to save schematics.");
        propSaveEnabled.setLanguageKey("schematica.config.saveEnabled");
        saveEnabled = propSaveEnabled.getBoolean(true);
        propLoadEnabled = configuration.get("server", "loadEnabled", true, "Allow players to load schematics.");
        propLoadEnabled.setLanguageKey("schematica.config.loadEnabled");
        loadEnabled = propLoadEnabled.getBoolean(true);
        propPlayerQuotaKilobytes = configuration.get("server", "playerQuotaKilobytes", 8192, "Amount of storage provided per-player for schematics on the server.");
        propPlayerQuotaKilobytes.setLanguageKey("schematica.config.playerQuotaKilobytes");
        playerQuotaKilobytes = propPlayerQuotaKilobytes.getInt(8192);
    }

    private ConfigurationHandler() {
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("schematica")) {
            ConfigurationHandler.loadConfiguration();
        }
    }

    public static boolean isExtraAirBlock(Block block) {
        return extraAirBlockList.contains(block);
    }

    static {
        SWAP_SLOTS_DEFAULT = new boolean[]{false, false, false, false, false, true, true, true, true};
        SCHEMATIC_DIRECTORY_DEFAULT = new File(Schematica.proxy.getDataDirectory(), SCHEMATIC_DIRECTORY_STR);
        EXTRA_AIR_BLOCKS_DEFAULT = new String[0];
        dumpBlockList = false;
        showDebugInfo = true;
        enableAlpha = false;
        alpha = 1.0f;
        highlight = true;
        highlightAir = true;
        blockDelta = 0.005;
        renderDistance = 8;
        placeDelay = 1;
        timeout = 10;
        placeDistance = 5;
        placeInstantly = false;
        destroyBlocks = false;
        destroyInstantly = false;
        placeAdjacent = true;
        swapSlots = Arrays.copyOf(SWAP_SLOTS_DEFAULT, SWAP_SLOTS_DEFAULT.length);
        swapSlotsQueue = new ArrayDeque<Integer>();
        schematicDirectory = SCHEMATIC_DIRECTORY_DEFAULT;
        extraAirBlocks = Arrays.copyOf(EXTRA_AIR_BLOCKS_DEFAULT, EXTRA_AIR_BLOCKS_DEFAULT.length);
        sortType = SORT_TYPE_DEFAULT;
        printerEnabled = true;
        saveEnabled = true;
        loadEnabled = true;
        playerQuotaKilobytes = 8192;
        propDumpBlockList = null;
        propShowDebugInfo = null;
        propEnableAlpha = null;
        propAlpha = null;
        propHighlight = null;
        propHighlightAir = null;
        propBlockDelta = null;
        propRenderDistance = null;
        propPlaceDelay = null;
        propTimeout = null;
        propPlaceDistance = null;
        propPlaceInstantly = null;
        propDestroyBlocks = null;
        propDestroyInstantly = null;
        propPlaceAdjacent = null;
        propSwapSlots = new Property[SWAP_SLOTS_DEFAULT.length];
        propSchematicDirectory = null;
        propExtraAirBlocks = null;
        propSortType = null;
        propPrinterEnabled = null;
        propSaveEnabled = null;
        propLoadEnabled = null;
        propPlayerQuotaKilobytes = null;
        extraAirBlockList = new HashSet<Block>();
    }
}

