/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.client.util;

import com.github.lunatrius.core.util.math.BlockPosHelper;
import com.github.lunatrius.core.util.math.MBlockPos;
import com.github.lunatrius.schematica.api.ISchematic;
import com.github.lunatrius.schematica.block.state.BlockStateHelper;
import com.github.lunatrius.schematica.client.world.SchematicWorld;
import com.github.lunatrius.schematica.reference.Reference;
import com.github.lunatrius.schematica.world.storage.Schematic;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLever;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class FlipHelper {
    public static final FlipHelper INSTANCE = new FlipHelper();

    public boolean flip(SchematicWorld world, EnumFacing axis, boolean forced) {
        if (world == null) {
            return false;
        }
        try {
            ISchematic schematic = world.getSchematic();
            Schematic schematicFlipped = this.flip(schematic, axis, forced);
            world.setSchematic(schematicFlipped);
            for (TileEntity tileEntity : world.getTileEntities()) {
                world.initializeTileEntity(tileEntity);
            }
            return true;
        }
        catch (FlipException fe) {
            Reference.logger.error(fe.getMessage());
        }
        catch (Exception e) {
            Reference.logger.fatal("Something went wrong!", (Throwable)e);
        }
        return false;
    }

    public Schematic flip(ISchematic schematic, EnumFacing axis, boolean forced) throws FlipException {
        Vec3i dimensionsFlipped = new Vec3i(schematic.getWidth(), schematic.getHeight(), schematic.getLength());
        Schematic schematicFlipped = new Schematic(schematic.getIcon(), dimensionsFlipped.func_177958_n(), dimensionsFlipped.func_177956_o(), dimensionsFlipped.func_177952_p(), schematic.getAuthor());
        MBlockPos tmp = new MBlockPos();
        for (MBlockPos pos : BlockPosHelper.getAllInBox((int)0, (int)0, (int)0, (int)(schematic.getWidth() - 1), (int)(schematic.getHeight() - 1), (int)(schematic.getLength() - 1))) {
            IBlockState blockState = schematic.getBlockState((BlockPos)pos);
            IBlockState blockStateFlipped = this.flipBlock(blockState, axis, forced);
            schematicFlipped.setBlockState(this.flipPos((BlockPos)pos, axis, dimensionsFlipped, tmp), blockStateFlipped);
        }
        List<TileEntity> tileEntities = schematic.getTileEntities();
        for (TileEntity tileEntity : tileEntities) {
            BlockPos pos = tileEntity.func_174877_v();
            tileEntity.func_174878_a(new BlockPos((Vec3i)this.flipPos(pos, axis, dimensionsFlipped, tmp)));
            schematicFlipped.setTileEntity(tileEntity.func_174877_v(), tileEntity);
        }
        return schematicFlipped;
    }

    private BlockPos flipPos(BlockPos pos, EnumFacing axis, Vec3i dimensions, MBlockPos flipped) throws FlipException {
        switch (axis) {
            case DOWN: 
            case UP: {
                return flipped.set(pos.func_177958_n(), dimensions.func_177956_o() - 1 - pos.func_177956_o(), pos.func_177952_p());
            }
            case NORTH: 
            case SOUTH: {
                return flipped.set(pos.func_177958_n(), pos.func_177956_o(), dimensions.func_177952_p() - 1 - pos.func_177952_p());
            }
            case WEST: 
            case EAST: {
                return flipped.set(dimensions.func_177958_n() - 1 - pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
        throw new FlipException("'%s' is not a valid axis!", axis.func_176610_l());
    }

    private IBlockState flipBlock(IBlockState blockState, EnumFacing axis, boolean forced) throws FlipException {
        IProperty propertyFacing = BlockStateHelper.getProperty(blockState, "facing");
        if (propertyFacing instanceof PropertyDirection) {
            Comparable value = blockState.func_177229_b(propertyFacing);
            if (value instanceof EnumFacing) {
                EnumFacing facing = FlipHelper.getFlippedFacing(axis, (EnumFacing)value);
                if (propertyFacing.func_177700_c().contains(facing)) {
                    return blockState.func_177226_a(propertyFacing, (Comparable)facing);
                }
            }
        } else if (propertyFacing instanceof PropertyEnum) {
            if (BlockLever.EnumOrientation.class.isAssignableFrom(propertyFacing.func_177699_b())) {
                BlockLever.EnumOrientation orientation = (BlockLever.EnumOrientation)blockState.func_177229_b(propertyFacing);
                BlockLever.EnumOrientation orientationRotated = FlipHelper.getFlippedLeverFacing(axis, orientation);
                if (propertyFacing.func_177700_c().contains(orientationRotated)) {
                    return blockState.func_177226_a(propertyFacing, (Comparable)orientationRotated);
                }
            }
        } else if (propertyFacing != null) {
            Reference.logger.error("'{}': found 'facing' property with unknown type {}", Block.field_149771_c.func_177774_c((Object)blockState.func_177230_c()), (Object)propertyFacing.getClass().getSimpleName());
        }
        if (!forced && propertyFacing != null) {
            throw new FlipException("'%s' cannot be flipped across '%s'", Block.field_149771_c.func_177774_c((Object)blockState.func_177230_c()), axis);
        }
        return blockState;
    }

    private static EnumFacing getFlippedFacing(EnumFacing axis, EnumFacing side) {
        if (axis.func_176740_k() == side.func_176740_k()) {
            return side.func_176734_d();
        }
        return side;
    }

    private static BlockLever.EnumOrientation getFlippedLeverFacing(EnumFacing source, BlockLever.EnumOrientation side) {
        if (source.func_176740_k() != side.func_176852_c().func_176740_k()) {
            return side;
        }
        EnumFacing facing = side == BlockLever.EnumOrientation.UP_Z || side == BlockLever.EnumOrientation.DOWN_Z ? EnumFacing.NORTH : (side == BlockLever.EnumOrientation.UP_X || side == BlockLever.EnumOrientation.DOWN_X ? EnumFacing.WEST : side.func_176852_c());
        EnumFacing facingFlipped = FlipHelper.getFlippedFacing(source, side.func_176852_c());
        return BlockLever.EnumOrientation.func_176856_a((EnumFacing)facingFlipped, (EnumFacing)facing);
    }

    public static class FlipException
    extends Exception {
        public FlipException(String message, Object ... args) {
            super(String.format(message, args));
        }
    }
}

