/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.render.model.baked;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.client.model.pipeline.VertexTransformer;
import net.minecraftforge.common.model.TRSRTransformation;

public class BakedModelTRSR
implements IBakedModel {
    protected final IBakedModel original;
    public TRSRTransformation transformation;
    private final TRSROverride override;
    private final int faceOffset;

    public BakedModelTRSR(IBakedModel original, float x, float y, float z, float scale) {
        this(original, x, y, z, 0.0f, 0.0f, 0.0f, scale, scale, scale);
    }

    public BakedModelTRSR(IBakedModel original, float x, float y, float z, float rotX, float rotY, float rotZ, float scale) {
        this(original, x, y, z, rotX, rotY, rotZ, scale, scale, scale);
    }

    public BakedModelTRSR(IBakedModel original, float x, float y, float z, float rotX, float rotY, float rotZ, float scaleX, float scaleY, float scaleZ) {
        this(original, new TRSRTransformation(new Vector3f(x, y, z), null, new Vector3f(scaleX, scaleY, scaleZ), TRSRTransformation.quatFromXYZ((float)rotX, (float)rotY, (float)rotZ)));
    }

    public BakedModelTRSR(IBakedModel original, TRSRTransformation transform) {
        this.original = original;
        this.transformation = TRSRTransformation.blockCenterToCorner((TRSRTransformation)transform);
        this.override = new TRSROverride(this);
        this.faceOffset = 0;
    }

    public BakedModelTRSR(IBakedModel original, EnumFacing facing) {
        this.original = original;
        this.override = new TRSROverride(this);
        this.faceOffset = 4 + EnumFacing.NORTH.func_176736_b() - facing.func_176736_b();
        double r = Math.PI * (double)(360 - facing.func_176734_d().func_176736_b() * 90) / 180.0;
        TRSRTransformation t = new TRSRTransformation(null, null, null, TRSRTransformation.quatFromXYZ((float)0.0f, (float)((float)r), (float)0.0f));
        this.transformation = TRSRTransformation.blockCenterToCorner((TRSRTransformation)t);
    }

    @Nonnull
    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (!this.original.func_188618_c()) {
            try {
                if (side != null && side.func_176736_b() > -1) {
                    side = EnumFacing.func_176731_b((int)((side.func_176736_b() + this.faceOffset) % 4));
                }
                for (BakedQuad quad : this.original.func_188616_a(state, side, rand)) {
                    Transformer transformer = new Transformer(this.transformation, quad.getFormat());
                    quad.pipe((IVertexConsumer)transformer);
                    quads.add((BakedQuad)transformer.build());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return quads;
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return this.original.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.original.func_188618_c();
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.original.func_177554_e();
    }

    @Nonnull
    public ItemCameraTransforms func_177552_f() {
        return this.original.func_177552_f();
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return this.override;
    }

    private static class Transformer
    extends VertexTransformer {
        protected Matrix4f transformation;
        protected Matrix3f normalTransformation;

        public Transformer(TRSRTransformation transformation, VertexFormat format) {
            super((IVertexConsumer)new UnpackedBakedQuad.Builder(format));
            this.transformation = transformation.getMatrix();
            this.normalTransformation = new Matrix3f();
            this.transformation.getRotationScale(this.normalTransformation);
            this.normalTransformation.invert();
            this.normalTransformation.transpose();
        }

        public void put(int element, float ... data) {
            VertexFormatElement.EnumUsage usage = this.parent.getVertexFormat().func_177348_c(element).func_177375_c();
            if (usage == VertexFormatElement.EnumUsage.POSITION && data.length >= 3) {
                Vector4f vec = new Vector4f(data[0], data[1], data[2], 1.0f);
                this.transformation.transform((Tuple4f)vec);
                data = new float[4];
                vec.get(data);
            } else if (usage == VertexFormatElement.EnumUsage.NORMAL && data.length >= 3) {
                Vector3f vec = new Vector3f(data);
                this.normalTransformation.transform((Tuple3f)vec);
                vec.normalize();
                data = new float[4];
                vec.get(data);
            }
            super.put(element, data);
        }

        public UnpackedBakedQuad build() {
            return ((UnpackedBakedQuad.Builder)this.parent).build();
        }
    }

    private static class TRSROverride
    extends ItemOverrideList {
        private final BakedModelTRSR model;

        public TRSROverride(BakedModelTRSR model) {
            super((List)ImmutableList.of());
            this.model = model;
        }

        @Nonnull
        public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            IBakedModel baked = this.model.original.func_188617_f().handleItemState(originalModel, stack, world, entity);
            return new BakedModelTRSR(baked, this.model.transformation);
        }
    }
}

