/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.grid.handler;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTaskError;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.grid.handler.IItemGridHandler;
import com.raoulvdberge.refinedstorage.api.network.item.INetworkItem;
import com.raoulvdberge.refinedstorage.api.network.item.NetworkItemAction;
import com.raoulvdberge.refinedstorage.api.network.security.Permission;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.preview.CraftingPreviewElementError;
import com.raoulvdberge.refinedstorage.network.MessageGridCraftingPreviewResponse;
import com.raoulvdberge.refinedstorage.network.MessageGridCraftingStartResponse;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.Collections;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemGridHandler
implements IItemGridHandler {
    private INetwork network;

    public ItemGridHandler(INetwork network) {
        this.network = network;
    }

    @Override
    public void onExtract(EntityPlayerMP player, int hash, int flags) {
        ItemStack item = this.network.getItemStorageCache().getList().get(hash);
        if (item == null || !this.network.getSecurityManager().hasPermission(Permission.EXTRACT, (EntityPlayer)player)) {
            return;
        }
        int itemSize = item.func_190916_E();
        int maxItemSize = item.func_77973_b().getItemStackLimit(item.func_77946_l());
        boolean single = (flags & 2) == 2;
        ItemStack held = player.field_71071_by.func_70445_o();
        if (single ? !held.func_190926_b() && (!API.instance().getComparer().isEqualNoQuantity(item, held) || held.func_190916_E() + 1 > held.func_77976_d()) : !player.field_71071_by.func_70445_o().func_190926_b()) {
            return;
        }
        int size = 64;
        if ((flags & 1) == 1 && itemSize > 1) {
            size = itemSize / 2;
            if (size > maxItemSize / 2 && maxItemSize != 1) {
                size = maxItemSize / 2;
            }
        } else if (single) {
            size = 1;
        } else if ((flags & 4) == 4) {
            // empty if block
        }
        size = Math.min(size, maxItemSize);
        this.network.getItemStorageTracker().changed((EntityPlayer)player, item.func_77946_l());
        ItemStack took = this.network.extractItem(item, size, Action.SIMULATE);
        if (took != null) {
            if ((flags & 4) == 4) {
                IItemHandler playerInventory = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
                if (ItemHandlerHelper.insertItem((IItemHandler)playerInventory, (ItemStack)took, (boolean)true).func_190926_b() && (took = this.network.extractItem(item, size, Action.PERFORM)) != null) {
                    ItemHandlerHelper.insertItem((IItemHandler)playerInventory, (ItemStack)took, (boolean)false);
                }
            } else {
                took = this.network.extractItem(item, size, Action.PERFORM);
                if (took != null) {
                    if (single && !held.func_190926_b()) {
                        held.func_190917_f(1);
                    } else {
                        player.field_71071_by.func_70437_b(took);
                    }
                    player.func_71113_k();
                }
            }
            INetworkItem networkItem = this.network.getNetworkItemHandler().getItem((EntityPlayer)player);
            if (networkItem != null) {
                networkItem.onAction(NetworkItemAction.ITEM_EXTRACTED);
            }
        }
    }

    @Override
    public ItemStack onInsert(EntityPlayerMP player, ItemStack stack) {
        if (!this.network.getSecurityManager().hasPermission(Permission.INSERT, (EntityPlayer)player)) {
            return stack;
        }
        this.network.getItemStorageTracker().changed((EntityPlayer)player, stack.func_77946_l());
        ItemStack remainder = this.network.insertItem(stack, stack.func_190916_E(), Action.PERFORM);
        INetworkItem networkItem = this.network.getNetworkItemHandler().getItem((EntityPlayer)player);
        if (networkItem != null) {
            networkItem.onAction(NetworkItemAction.ITEM_INSERTED);
        }
        return remainder;
    }

    @Override
    public void onInsertHeldItem(EntityPlayerMP player, boolean single) {
        if (player.field_71071_by.func_70445_o().func_190926_b() || !this.network.getSecurityManager().hasPermission(Permission.INSERT, (EntityPlayer)player)) {
            return;
        }
        ItemStack stack = player.field_71071_by.func_70445_o();
        int size = single ? 1 : stack.func_190916_E();
        this.network.getItemStorageTracker().changed((EntityPlayer)player, stack.func_77946_l());
        if (single) {
            if (this.network.insertItem(stack, size, Action.SIMULATE) == null) {
                this.network.insertItem(stack, size, Action.PERFORM);
                stack.func_190918_g(size);
                if (stack.func_190916_E() == 0) {
                    player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                }
            }
        } else {
            player.field_71071_by.func_70437_b(StackUtils.nullToEmpty(this.network.insertItem(stack, size, Action.PERFORM)));
        }
        player.func_71113_k();
        INetworkItem networkItem = this.network.getNetworkItemHandler().getItem((EntityPlayer)player);
        if (networkItem != null) {
            networkItem.onAction(NetworkItemAction.ITEM_INSERTED);
        }
    }

    @Override
    public ItemStack onShiftClick(EntityPlayerMP player, ItemStack stack) {
        return StackUtils.nullToEmpty(this.onInsert(player, stack));
    }

    @Override
    public void onCraftingPreviewRequested(EntityPlayerMP player, int hash, int quantity, boolean noPreview) {
        if (!this.network.getSecurityManager().hasPermission(Permission.AUTOCRAFTING, (EntityPlayer)player)) {
            return;
        }
        IStackList<ItemStack> cache = API.instance().createItemStackList();
        for (ICraftingPattern pattern : this.network.getCraftingManager().getPatterns()) {
            for (ItemStack output : pattern.getOutputs()) {
                cache.add(output);
            }
        }
        ItemStack stack = cache.get(hash);
        if (stack != null) {
            Thread calculationThread = new Thread(() -> {
                ICraftingTask task = this.network.getCraftingManager().create(stack, quantity);
                if (task == null) {
                    return;
                }
                ICraftingTaskError error = task.calculate();
                if (error != null) {
                    RS.INSTANCE.network.sendTo((IMessage)new MessageGridCraftingPreviewResponse(Collections.singletonList(new CraftingPreviewElementError(error.getType(), error.getRecursedPattern() == null ? ItemStack.field_190927_a : error.getRecursedPattern().getStack())), hash, quantity, false), player);
                } else if (noPreview && !task.hasMissing()) {
                    this.network.getCraftingManager().add(task);
                    RS.INSTANCE.network.sendTo((IMessage)new MessageGridCraftingStartResponse(), player);
                } else {
                    RS.INSTANCE.network.sendTo((IMessage)new MessageGridCraftingPreviewResponse(task.getPreviewStacks(), hash, quantity, false), player);
                }
            }, "RS crafting preview calculation");
            calculationThread.start();
        }
    }

    @Override
    public void onCraftingRequested(EntityPlayerMP player, int hash, int quantity) {
        if (quantity <= 0 || !this.network.getSecurityManager().hasPermission(Permission.AUTOCRAFTING, (EntityPlayer)player)) {
            return;
        }
        ItemStack stack = null;
        for (ICraftingPattern pattern : this.network.getCraftingManager().getPatterns()) {
            for (ItemStack output : pattern.getOutputs()) {
                if (API.instance().getItemStackHashCode(output) != hash) continue;
                stack = output;
                break;
            }
            if (stack == null) continue;
            break;
        }
        if (stack != null) {
            ICraftingTask task = this.network.getCraftingManager().create(stack, quantity);
            if (task == null) {
                return;
            }
            ICraftingTaskError error = task.calculate();
            if (error == null && !task.hasMissing()) {
                this.network.getCraftingManager().add(task);
            }
        }
    }

    @Override
    public void onCraftingCancelRequested(EntityPlayerMP player, @Nullable UUID id) {
        if (!this.network.getSecurityManager().hasPermission(Permission.AUTOCRAFTING, (EntityPlayer)player)) {
            return;
        }
        this.network.getCraftingManager().cancel(id);
        INetworkItem networkItem = this.network.getNetworkItemHandler().getItem((EntityPlayer)player);
        if (networkItem != null) {
            networkItem.onAction(id == null ? NetworkItemAction.CRAFTING_TASK_ALL_CANCELLED : NetworkItemAction.CRAFTING_TASK_CANCELLED);
        }
    }
}

