/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.util;

import net.minecraft.util.EnumFacing;

public enum RelativeSide {
    BACK,
    LEFT,
    RIGHT,
    TOP,
    BOTTOM,
    FRONT;

    private static final RelativeSide[] values;

    public static RelativeSide fromFacing(EnumFacing baseFacing, EnumFacing facing) {
        EnumFacing rot;
        if (baseFacing == facing) {
            return FRONT;
        }
        if (baseFacing.func_176734_d() == facing) {
            return BACK;
        }
        if (baseFacing.func_176740_k() == EnumFacing.Axis.Y) {
            rot = baseFacing.func_176732_a(EnumFacing.Axis.X);
            if (rot == facing) {
                return BOTTOM;
            }
            if (rot == facing.func_176734_d()) {
                return TOP;
            }
        } else {
            if (facing == EnumFacing.UP) {
                return TOP;
            }
            if (facing == EnumFacing.DOWN) {
                return BOTTOM;
            }
        }
        if (baseFacing.func_176740_k() == EnumFacing.Axis.Y) {
            rot = baseFacing.func_176732_a(EnumFacing.Axis.Z);
            if (rot == facing) {
                return baseFacing.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE ? RIGHT : LEFT;
            }
            if (rot == facing.func_176734_d()) {
                return baseFacing.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE ? LEFT : RIGHT;
            }
        } else {
            if (baseFacing.func_176746_e() == facing) {
                return LEFT;
            }
            if (baseFacing.func_176735_f() == facing) {
                return RIGHT;
            }
        }
        return FRONT;
    }

    public static RelativeSide fromIndex(int i) {
        return values[Math.abs(i % values.length)];
    }

    public EnumFacing toFacing(EnumFacing baseFacing) {
        switch (this) {
            case FRONT: {
                return baseFacing;
            }
            case BACK: {
                return baseFacing.func_176734_d();
            }
            case LEFT: {
                if (baseFacing.func_176740_k() == EnumFacing.Axis.Y) {
                    return baseFacing.func_176732_a(EnumFacing.Axis.Z);
                }
                return baseFacing.func_176746_e();
            }
            case RIGHT: {
                if (baseFacing.func_176740_k() == EnumFacing.Axis.Y) {
                    return baseFacing.func_176732_a(EnumFacing.Axis.Z).func_176734_d();
                }
                return baseFacing.func_176735_f();
            }
            case TOP: {
                if (baseFacing.func_176740_k() == EnumFacing.Axis.Y) {
                    return baseFacing.func_176732_a(EnumFacing.Axis.X);
                }
                return EnumFacing.UP;
            }
            case BOTTOM: {
                if (baseFacing.func_176740_k() == EnumFacing.Axis.Y) {
                    return baseFacing.func_176732_a(EnumFacing.Axis.X).func_176734_d();
                }
                return EnumFacing.DOWN;
            }
        }
        return null;
    }

    public RelativeSide getOpposite() {
        switch (this) {
            case BACK: {
                return FRONT;
            }
            case FRONT: {
                return BACK;
            }
            case LEFT: {
                return RIGHT;
            }
            case RIGHT: {
                return LEFT;
            }
            case TOP: {
                return BOTTOM;
            }
            case BOTTOM: {
                return TOP;
            }
        }
        return this;
    }

    public RelativeSide rotateY() {
        switch (this) {
            case BACK: {
                return RIGHT;
            }
            case RIGHT: {
                return FRONT;
            }
            case FRONT: {
                return LEFT;
            }
            case LEFT: {
                return BACK;
            }
        }
        return this;
    }

    public RelativeSide rotateX() {
        switch (this) {
            case TOP: {
                return LEFT;
            }
            case BOTTOM: {
                return RIGHT;
            }
            case RIGHT: {
                return BOTTOM;
            }
            case LEFT: {
                return TOP;
            }
        }
        return this;
    }

    public RelativeSide rotateZ() {
        switch (this) {
            case TOP: {
                return BACK;
            }
            case BOTTOM: {
                return FRONT;
            }
            case BACK: {
                return TOP;
            }
            case FRONT: {
                return BOTTOM;
            }
        }
        return this;
    }

    static {
        values = RelativeSide.values();
    }
}

