/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.tile;

import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.api.Capabilities;
import net.blay09.mods.refinedrelocation.api.INameTaggable;
import net.blay09.mods.refinedrelocation.api.filter.IRootFilter;
import net.blay09.mods.refinedrelocation.api.grid.ISortingInventory;
import net.blay09.mods.refinedrelocation.tile.TileMod;
import net.blay09.mods.refinedrelocation.util.DoorAnimator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileSortingChest
extends TileMod
implements ITickable {
    private final ItemStackHandler itemHandler = new ItemStackHandler(27){

        protected void onContentsChanged(int slot) {
            TileSortingChest.this.func_70296_d();
            TileSortingChest.this.sortingInventory.onSlotChanged(slot);
        }
    };
    private final DoorAnimator doorAnimator = new DoorAnimator(this, 0, 1);
    private final ISortingInventory sortingInventory = Capabilities.getDefaultInstance(Capabilities.SORTING_INVENTORY);
    private final IRootFilter rootFilter = Capabilities.getDefaultInstance(Capabilities.ROOT_FILTER);
    private final INameTaggable nameTaggable = Capabilities.getDefaultInstance(Capabilities.NAME_TAGGABLE);

    public TileSortingChest() {
        this.doorAnimator.setSoundEventOpen(SoundEvents.field_187657_V);
        this.doorAnimator.setSoundEventClose(SoundEvents.field_187651_T);
    }

    public void onLoad() {
        super.onLoad();
        this.sortingInventory.onLoad(this);
    }

    public void func_73660_a() {
        this.sortingInventory.onUpdate(this);
        this.doorAnimator.update();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.sortingInventory.onInvalidate(this);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.sortingInventory.onInvalidate(this);
    }

    public DoorAnimator getDoorAnimator() {
        return this.doorAnimator;
    }

    public static void fixRootFilterTag(NBTTagCompound compound) {
        if (compound.func_150299_b("RootFilter") == 9) {
            NBTTagList tagList = compound.func_150295_c("RootFilter", 10);
            compound.func_82580_o("RootFilter");
            NBTTagCompound rootFilter = new NBTTagCompound();
            rootFilter.func_74782_a("FilterList", (NBTBase)tagList);
            compound.func_74782_a("RootFilter", (NBTBase)rootFilter);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.itemHandler.deserializeNBT(compound.func_74775_l("ItemHandler"));
        this.sortingInventory.deserializeNBT((NBTBase)compound.func_74775_l("SortingInventory"));
        TileSortingChest.fixRootFilterTag(compound);
        this.rootFilter.deserializeNBT((NBTBase)compound.func_74775_l("RootFilter"));
        this.nameTaggable.deserializeNBT(compound.func_74775_l("NameTaggable"));
    }

    @Override
    public void readFromNBTSynced(NBTTagCompound compound) {
        this.nameTaggable.setCustomName(compound.func_74779_i("CustomName"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("ItemHandler", (NBTBase)this.itemHandler.serializeNBT());
        compound.func_74782_a("SortingInventory", this.sortingInventory.serializeNBT());
        compound.func_74782_a("RootFilter", this.rootFilter.serializeNBT());
        compound.func_74782_a("NameTaggable", (NBTBase)this.nameTaggable.serializeNBT());
        return compound;
    }

    @Override
    public NBTTagCompound writeToNBTSynced(NBTTagCompound compound) {
        compound.func_74778_a("CustomName", this.nameTaggable.getCustomName());
        return compound;
    }

    public boolean func_145842_c(int id, int type) {
        return this.doorAnimator.receiveClientEvent(id, type) || super.func_145842_c(id, type);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == Capabilities.NAME_TAGGABLE || Capabilities.isSortingGridCapability(capability) || Capabilities.isFilterCapability(capability) || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemHandler;
        }
        if (Capabilities.isSortingGridCapability(capability)) {
            return (T)this.sortingInventory;
        }
        if (Capabilities.isFilterCapability(capability)) {
            return (T)this.rootFilter;
        }
        if (capability == Capabilities.NAME_TAGGABLE) {
            return (T)this.nameTaggable;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Nullable
    public ITextComponent func_145748_c_() {
        return this.nameTaggable.getDisplayName();
    }

    @Override
    public String getUnlocalizedName() {
        return "container.refinedrelocation:sorting_chest";
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }
}

