/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.tile;

import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.api.Capabilities;
import net.blay09.mods.refinedrelocation.api.INameTaggable;
import net.blay09.mods.refinedrelocation.block.BlockFastHopper;
import net.blay09.mods.refinedrelocation.tile.TileMod;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class TileFastHopper
extends TileMod
implements ITickable {
    private final ItemStackHandler itemHandler = this.createItemHandler();
    private final INameTaggable nameTaggable = Capabilities.getDefaultInstance(Capabilities.NAME_TAGGABLE);
    private int cooldown;

    protected ItemStackHandler createItemHandler() {
        return new ItemStackHandler(5){

            protected void onContentsChanged(int slot) {
                TileFastHopper.this.func_70296_d();
            }
        };
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            --this.cooldown;
            if (this.cooldown <= 0) {
                int i;
                EnumFacing facing = (EnumFacing)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockFastHopper.FACING);
                EnumFacing opposite = facing.func_176734_d();
                TileEntity facingTile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
                IItemHandler targetItemHandler = facingTile != null ? (IItemHandler)facingTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, opposite) : null;
                boolean hasSpace = false;
                if (targetItemHandler != null) {
                    for (i = 0; i < this.itemHandler.getSlots(); ++i) {
                        ItemStack itemStack = this.itemHandler.getStackInSlot(i);
                        if (!itemStack.func_190926_b()) {
                            this.pushItem(i, targetItemHandler);
                        }
                        if (hasSpace || !itemStack.func_190926_b() && itemStack.func_190916_E() >= itemStack.func_77976_d()) continue;
                        hasSpace = true;
                    }
                } else {
                    for (i = 0; i < this.itemHandler.getSlots(); ++i) {
                        if (!this.itemHandler.getStackInSlot(i).func_190926_b()) continue;
                        hasSpace = true;
                        break;
                    }
                }
                if (hasSpace) {
                    IItemHandler itemHandler;
                    BlockPos upPos = this.field_174879_c.func_177972_a(EnumFacing.UP);
                    TileEntity upTile = this.field_145850_b.func_175625_s(upPos);
                    IItemHandler iItemHandler = itemHandler = upTile != null ? (IItemHandler)upTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN) : null;
                    if (itemHandler != null) {
                        this.pullItem(itemHandler);
                    } else {
                        float range = 0.75f;
                        this.field_145850_b.func_175647_a(EntityItem.class, new AxisAlignedBB((double)((float)this.field_174879_c.func_177958_n() - range), (double)((float)this.field_174879_c.func_177956_o() - range), (double)((float)this.field_174879_c.func_177952_p() - range), (double)((float)this.field_174879_c.func_177958_n() + range), (double)((float)this.field_174879_c.func_177956_o() + 1.5f), (double)((float)this.field_174879_c.func_177952_p() + range)), EntitySelectors.field_94557_a).forEach(this::pullItem);
                    }
                }
                this.cooldown = 20;
            }
        }
    }

    public void pushItem(int sourceSlot, IItemHandler targetItemHandler) {
        ItemStack sourceStack = this.itemHandler.extractItem(sourceSlot, Items.field_190931_a.func_77639_j(), true);
        ItemStack restStack = ItemHandlerHelper.insertItem((IItemHandler)targetItemHandler, (ItemStack)sourceStack, (boolean)false);
        this.itemHandler.extractItem(sourceSlot, restStack.func_190926_b() ? sourceStack.func_190916_E() : sourceStack.func_190916_E() - restStack.func_190916_E(), false);
    }

    private void pullItem(IItemHandler sourceItemHandler) {
        for (int i = 0; i < sourceItemHandler.getSlots(); ++i) {
            ItemStack sourceStack = sourceItemHandler.extractItem(i, Items.field_190931_a.func_77639_j(), true);
            if (sourceStack.func_190926_b()) continue;
            ItemStack restStack = ItemHandlerHelper.insertItem((IItemHandler)this.itemHandler, (ItemStack)sourceStack, (boolean)false);
            sourceItemHandler.extractItem(i, restStack.func_190926_b() ? Items.field_190931_a.func_77639_j() : sourceStack.func_190916_E() - restStack.func_190916_E(), false);
            break;
        }
    }

    public boolean pullItem(EntityItem entityItem) {
        ItemStack sourceStack = entityItem.func_92059_d();
        ItemStack restStack = ItemHandlerHelper.insertItem((IItemHandler)this.itemHandler, (ItemStack)sourceStack, (boolean)false);
        if (!restStack.func_190926_b()) {
            entityItem.func_92058_a(restStack);
        } else {
            entityItem.func_70106_y();
        }
        return restStack.func_190926_b() || restStack.func_190916_E() < sourceStack.func_190916_E();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74782_a("ItemHandler", (NBTBase)this.itemHandler.serializeNBT());
        tagCompound.func_74782_a("NameTaggable", (NBTBase)this.nameTaggable.serializeNBT());
        return tagCompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.itemHandler.deserializeNBT(tagCompound.func_74775_l("ItemHandler"));
        this.nameTaggable.deserializeNBT(tagCompound.func_74775_l("NameTaggable"));
    }

    @Override
    public String getUnlocalizedName() {
        return "container.refinedrelocation:fast_hopper";
    }

    @Nullable
    public ITextComponent func_145748_c_() {
        return this.nameTaggable.getDisplayName();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == Capabilities.NAME_TAGGABLE || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemHandler;
        }
        if (capability == Capabilities.NAME_TAGGABLE) {
            return (T)this.nameTaggable;
        }
        return (T)super.getCapability(capability, facing);
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }
}

