/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.network;

import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.RefinedRelocation;
import net.blay09.mods.refinedrelocation.api.container.IContainerReturnable;
import net.blay09.mods.refinedrelocation.api.filter.IChecklistFilter;
import net.blay09.mods.refinedrelocation.api.filter.IConfigurableFilter;
import net.blay09.mods.refinedrelocation.api.filter.IFilter;
import net.blay09.mods.refinedrelocation.capability.CapabilityRootFilter;
import net.blay09.mods.refinedrelocation.client.gui.GuiBlockExtender;
import net.blay09.mods.refinedrelocation.client.gui.GuiChecklistFilter;
import net.blay09.mods.refinedrelocation.client.gui.GuiFastHopper;
import net.blay09.mods.refinedrelocation.client.gui.GuiRootFilter;
import net.blay09.mods.refinedrelocation.client.gui.GuiSortingChest;
import net.blay09.mods.refinedrelocation.container.ContainerBlockExtender;
import net.blay09.mods.refinedrelocation.container.ContainerChecklistFilter;
import net.blay09.mods.refinedrelocation.container.ContainerFastHopper;
import net.blay09.mods.refinedrelocation.container.ContainerRootFilter;
import net.blay09.mods.refinedrelocation.container.ContainerSortingChest;
import net.blay09.mods.refinedrelocation.network.MessageOpenGui;
import net.blay09.mods.refinedrelocation.tile.TileBlockExtender;
import net.blay09.mods.refinedrelocation.tile.TileFastHopper;
import net.blay09.mods.refinedrelocation.tile.TileSortingChest;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GuiHandler {
    public static final int GUI_SORTING_CHEST = 1;
    public static final int GUI_ROOT_FILTER = 2;
    public static final int GUI_ANY_FILTER = 3;
    public static final int GUI_FAST_HOPPER = 4;
    public static final int GUI_BLOCK_EXTENDER = 5;
    public static final int GUI_BLOCK_EXTENDER_ROOT_FILTER = 6;

    @Nullable
    public static Container getContainer(int id, EntityPlayer player, MessageOpenGui message) {
        TileEntity tileEntity = message.hasPosition() ? player.field_70170_p.func_175625_s(message.getPos()) : null;
        switch (id) {
            case 1: {
                return tileEntity instanceof TileSortingChest ? new ContainerSortingChest(player, (TileSortingChest)tileEntity) : null;
            }
            case 2: {
                return tileEntity != null ? (tileEntity.hasCapability(CapabilityRootFilter.CAPABILITY, null) ? new ContainerRootFilter(player, tileEntity).setReturnCallback(() -> RefinedRelocation.proxy.openGui(player, message)) : null) : null;
            }
            case 3: {
                Container container;
                if (tileEntity == null || !((container = player.field_71070_bA) instanceof ContainerRootFilter)) break;
                IFilter filter = ((ContainerRootFilter)container).getRootFilter().getFilter(message.getIntValue());
                Container filterContainer = GuiHandler.createFilterContainer(player, tileEntity, filter);
                if (filterContainer instanceof IContainerReturnable) {
                    ((IContainerReturnable)filterContainer).setReturnCallback(((ContainerRootFilter)container).getReturnCallback());
                }
                return filterContainer;
            }
            case 4: {
                return tileEntity instanceof TileFastHopper ? new ContainerFastHopper(player, (TileFastHopper)tileEntity) : null;
            }
            case 5: {
                return tileEntity instanceof TileBlockExtender ? new ContainerBlockExtender(player, (TileBlockExtender)tileEntity) : null;
            }
            case 6: {
                return tileEntity instanceof TileBlockExtender ? new ContainerRootFilter(player, tileEntity, message.getIntValue() == 1 ? ((TileBlockExtender)tileEntity).getOutputFilter() : ((TileBlockExtender)tileEntity).getInputFilter()).setReturnCallback(() -> RefinedRelocation.proxy.openGui(player, message)) : null;
            }
        }
        return null;
    }

    @Nullable
    private static Container createFilterContainer(EntityPlayer player, TileEntity tileEntity, @Nullable IFilter filter) {
        if (filter instanceof IConfigurableFilter) {
            return ((IConfigurableFilter)((Object)filter)).createContainer(player, tileEntity);
        }
        if (filter instanceof IChecklistFilter) {
            return new ContainerChecklistFilter(player, tileEntity, (IChecklistFilter)filter);
        }
        return null;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public static GuiScreen getGuiScreen(int id, EntityPlayer player, MessageOpenGui message) {
        TileEntity tileEntity = message.hasPosition() ? player.field_70170_p.func_175625_s(message.getPos()) : null;
        switch (id) {
            case 1: {
                return tileEntity instanceof TileSortingChest ? new GuiSortingChest(player, (TileSortingChest)tileEntity) : null;
            }
            case 2: {
                return tileEntity != null ? (tileEntity.hasCapability(CapabilityRootFilter.CAPABILITY, null) ? new GuiRootFilter(player, tileEntity) : null) : null;
            }
            case 3: {
                Container container;
                if (tileEntity == null || !((container = player.field_71070_bA) instanceof ContainerRootFilter)) break;
                IFilter filter = ((ContainerRootFilter)container).getRootFilter().getFilter(message.getIntValue());
                if (filter instanceof IConfigurableFilter) {
                    return ((IConfigurableFilter)((Object)filter)).createGuiScreen(player, tileEntity);
                }
                if (!(filter instanceof IChecklistFilter)) break;
                return new GuiChecklistFilter(player, tileEntity, (IChecklistFilter)filter);
            }
            case 4: {
                return tileEntity instanceof TileFastHopper ? new GuiFastHopper(player, (TileFastHopper)tileEntity) : null;
            }
            case 5: {
                EnumFacing clickedFace = EnumFacing.func_82600_a((int)message.getIntValue());
                return tileEntity instanceof TileBlockExtender ? new GuiBlockExtender(player, (TileBlockExtender)tileEntity, clickedFace) : null;
            }
            case 6: {
                return tileEntity instanceof TileBlockExtender ? new GuiRootFilter(new ContainerRootFilter(player, tileEntity, message.getIntValue() == 1 ? ((TileBlockExtender)tileEntity).getOutputFilter() : ((TileBlockExtender)tileEntity).getInputFilter())) : null;
            }
        }
        return null;
    }
}

