/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation;

import com.google.common.collect.Lists;
import java.util.List;
import net.blay09.mods.refinedrelocation.BlockRightClickHandler;
import net.blay09.mods.refinedrelocation.CommonProxy;
import net.blay09.mods.refinedrelocation.InternalMethodsImpl;
import net.blay09.mods.refinedrelocation.ModBlocks;
import net.blay09.mods.refinedrelocation.ModItems;
import net.blay09.mods.refinedrelocation.api.RefinedRelocationAPI;
import net.blay09.mods.refinedrelocation.capability.CapabilityNameTaggable;
import net.blay09.mods.refinedrelocation.capability.CapabilityRootFilter;
import net.blay09.mods.refinedrelocation.capability.CapabilitySimpleFilter;
import net.blay09.mods.refinedrelocation.capability.CapabilitySortingGridMember;
import net.blay09.mods.refinedrelocation.capability.CapabilitySortingInventory;
import net.blay09.mods.refinedrelocation.capability.CapabilitySortingUpgradable;
import net.blay09.mods.refinedrelocation.client.render.RenderSortingChest;
import net.blay09.mods.refinedrelocation.compat.RefinedAddon;
import net.blay09.mods.refinedrelocation.filter.CreativeTabFilter;
import net.blay09.mods.refinedrelocation.filter.ModFilter;
import net.blay09.mods.refinedrelocation.filter.NameFilter;
import net.blay09.mods.refinedrelocation.filter.PresetFilter;
import net.blay09.mods.refinedrelocation.filter.SameItemFilter;
import net.blay09.mods.refinedrelocation.filter.SameModFilter;
import net.blay09.mods.refinedrelocation.network.LoginSyncHandler;
import net.blay09.mods.refinedrelocation.network.MessageOpenGui;
import net.blay09.mods.refinedrelocation.network.NetworkHandler;
import net.blay09.mods.refinedrelocation.tile.TileBlockExtender;
import net.blay09.mods.refinedrelocation.tile.TileSortingChest;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
@Mod(modid="refinedrelocation", name="Refined Relocation", dependencies="after:ironchest", acceptedMinecraftVersions="[1.12]")
public class RefinedRelocation {
    public static final String MOD_ID = "refinedrelocation";
    public static final Logger logger = LogManager.getLogger((String)"refinedrelocation");
    @Mod.Instance(value="refinedrelocation")
    public static RefinedRelocation instance;
    @SidedProxy(clientSide="net.blay09.mods.refinedrelocation.client.ClientProxy", serverSide="net.blay09.mods.refinedrelocation.CommonProxy")
    public static CommonProxy proxy;
    public static final CreativeTabs creativeTab;
    private static final List<RefinedAddon> inbuiltAddons;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        RefinedRelocationAPI.__internal__setupAPI(new InternalMethodsImpl());
        NetworkHandler.init();
        ModBlocks.registerTileEntities();
        MinecraftForge.EVENT_BUS.register((Object)new LoginSyncHandler());
        MinecraftForge.EVENT_BUS.register((Object)new BlockRightClickHandler());
        CapabilitySimpleFilter.register();
        CapabilityRootFilter.register();
        CapabilitySortingGridMember.register();
        CapabilitySortingInventory.register();
        CapabilitySortingUpgradable.register();
        CapabilityNameTaggable.register();
        RefinedRelocationAPI.registerFilter(SameItemFilter.class);
        RefinedRelocationAPI.registerFilter(NameFilter.class);
        RefinedRelocationAPI.registerFilter(PresetFilter.class);
        RefinedRelocationAPI.registerFilter(CreativeTabFilter.class);
        RefinedRelocationAPI.registerFilter(ModFilter.class);
        RefinedRelocationAPI.registerFilter(SameModFilter.class);
        RefinedRelocationAPI.registerGuiHandler(TileSortingChest.class, (player, tileEntity) -> proxy.openGui(player, new MessageOpenGui(1, tileEntity.func_174877_v())));
        RefinedRelocationAPI.registerGuiHandler(TileBlockExtender.class, (player, tileEntity) -> proxy.openGui(player, new MessageOpenGui(5, tileEntity.func_174877_v())));
        if (Loader.isModLoaded((String)"ironchest")) {
            try {
                inbuiltAddons.add((RefinedAddon)Class.forName("net.blay09.mods.refinedrelocation.compat.ironchest.IronChestAddon").newInstance());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        for (RefinedAddon addon : inbuiltAddons) {
            addon.preInit();
        }
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        for (RefinedAddon addon : inbuiltAddons) {
            addon.init();
        }
        proxy.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        CreativeTabFilter.gatherCreativeTabs();
        ModFilter.gatherMods();
        proxy.postInit(event);
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        ModBlocks.register((IForgeRegistry<Block>)event.getRegistry());
        for (RefinedAddon addon : inbuiltAddons) {
            addon.registerBlocks((IForgeRegistry<Block>)event.getRegistry());
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        ModItems.register((IForgeRegistry<Item>)event.getRegistry());
        ModBlocks.registerItemBlocks((IForgeRegistry<Item>)event.getRegistry());
        for (RefinedAddon addon : inbuiltAddons) {
            addon.registerItems((IForgeRegistry<Item>)event.getRegistry());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void registerModels(ModelRegistryEvent event) {
        ModBlocks.registerModels();
        ModItems.registerModels();
        for (RefinedAddon addon : inbuiltAddons) {
            addon.registerModels();
        }
        ClientRegistry.bindTileEntitySpecialRenderer(TileSortingChest.class, (TileEntitySpecialRenderer)new RenderSortingChest());
    }

    public static List<RefinedAddon> getInbuiltAddons() {
        return inbuiltAddons;
    }

    static {
        creativeTab = new CreativeTabs(MOD_ID){

            public ItemStack func_78016_d() {
                return new ItemStack(ModBlocks.sortingChest);
            }
        };
        inbuiltAddons = Lists.newArrayList();
    }
}

