/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.world.decoration;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.MapGenBase;
import net.minecraftforge.oredict.OreDictionary;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.Configuration;
import zmaster587.libVulpes.block.BlockMeta;

public class MapGenGeode
extends MapGenBase {
    int chancePerChunk;
    private static List<BlockMeta> ores;

    public MapGenGeode(int chancePerChunk) {
        this.chancePerChunk = chancePerChunk;
        if (ores == null) {
            ores = new LinkedList<BlockMeta>();
            for (int i = 0; i < Configuration.standardGeodeOres.size(); ++i) {
                Block block;
                String oreDictName = Configuration.standardGeodeOres.get(i);
                NonNullList ores2 = OreDictionary.getOres((String)oreDictName);
                if (ores2 == null || ores2.isEmpty() || (block = Block.func_149634_a((Item)((ItemStack)ores2.get(0)).func_77973_b())) == null) continue;
                ores.add(new BlockMeta(block, ((ItemStack)ores2.get(0)).func_77952_i()));
            }
        }
    }

    protected void func_180701_a(World world, int chunkX, int chunkZ, int p_180701_4_, int p_180701_5_, ChunkPrimer chunkPrimerIn) {
        if (this.field_75038_b.nextInt(this.chancePerChunk) == Math.abs(chunkX) % this.chancePerChunk || this.field_75038_b.nextInt(this.chancePerChunk) == Math.abs(chunkZ) % this.chancePerChunk) {
            int radius = this.field_75038_b.nextInt(Configuration.geodeVariation) + Configuration.geodeBaseSize - Configuration.geodeVariation / 2;
            int depth = radius * radius;
            int xCoord = -chunkX + p_180701_4_;
            int zCoord = -chunkZ + p_180701_5_;
            BlockPos pos = new BlockPos(chunkX * 16, 0, chunkZ * 16);
            int avgY = (int)((world.func_180494_b(pos).func_185355_j() + 2.0f) * 32.0f) - 3 * radius / 4;
            for (int x = 15; x >= 0; --x) {
                for (int z = 15; z >= 0; --z) {
                    int count;
                    int index;
                    for (int y = 255; y >= 0; --y) {
                        index = (x * 16 + z) * 256 + y;
                        if (chunkPrimerIn.func_177856_a(x, y, z) != Blocks.field_150350_a.func_176223_P()) break;
                    }
                    if (avgY - (count = (depth - ((xCoord * 16 + x) * (xCoord * 16 + x) + (zCoord * 16 + z) * (zCoord * 16 + z))) / (radius * 2)) < 1 || avgY + count > 255) continue;
                    for (int dist = -count; dist < Math.min(count, 3); ++dist) {
                        index = (x * 16 + z) * 256 + avgY - dist;
                        chunkPrimerIn.func_177855_a(x, avgY - dist, z, Blocks.field_150350_a.func_176223_P());
                    }
                    if (count < 0) continue;
                    if (count > 4) {
                        int i;
                        int size = this.field_75038_b.nextInt(4) + 4;
                        if (x % 4 > 0 && z % 4 > 0) {
                            for (i = 1; i < size; ++i) {
                                chunkPrimerIn.func_177855_a(x, avgY + count - i, z, ores.get((x / 4 + z / 4) % ores.size()).getBlockState());
                            }
                        } else {
                            size -= 2;
                            for (i = 1; i < size; ++i) {
                                chunkPrimerIn.func_177855_a(x, avgY + count - i, z, Blocks.field_150348_b.func_176223_P());
                            }
                        }
                        if ((x + 2) % 4 > 0 && (z + 2) % 4 > 0) {
                            for (i = 1; i < size; ++i) {
                                chunkPrimerIn.func_177855_a(x, avgY - count + i, z, ores.get((x / 4 + z / 4) % ores.size()).getBlockState());
                            }
                        }
                    }
                    chunkPrimerIn.func_177855_a(x, avgY - count, z, AdvancedRocketryBlocks.blocksGeode.func_176223_P());
                    chunkPrimerIn.func_177855_a(x, avgY + count, z, AdvancedRocketryBlocks.blocksGeode.func_176223_P());
                }
            }
        }
    }
}

