/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.util;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class AsteroidSmall {
    public String ID;
    public int distance;
    public int mass;
    public int minLevel;
    public float massVariability;
    public float richness;
    public float richnessVariability;
    public float probability;
    public float timeMultiplier;
    public List<Float> stackProbabilites = new LinkedList<Float>();
    public List<ItemStack> itemStacks = new LinkedList<ItemStack>();
    public static Random rand = new Random();
    private static final int precision = 1000;

    public String getName() {
        return this.ID;
    }

    public int getDistance() {
        return this.distance;
    }

    public int getMass() {
        return this.mass;
    }

    public int getMinLevel() {
        return this.minLevel;
    }

    public float getProbability() {
        return this.probability;
    }

    public List<StackEntry> getHarvest(long seed) {
        return this.getHarvest(seed, 1.0f);
    }

    public List<StackEntry> getHarvest(long seed, float uncertainty) {
        int i;
        LinkedList<StackEntry> entries = new LinkedList<StackEntry>();
        rand.setSeed(seed);
        int myMass = (int)((float)this.mass + rand.nextFloat() * this.massVariability * (float)this.mass - this.massVariability * (float)this.mass / 2.0f);
        int numOres = (int)((float)myMass * (this.richness + rand.nextFloat() * this.richnessVariability - this.richnessVariability / 2.0f));
        StackEntry entry = new StackEntry();
        entry.stack = new ItemStack(Blocks.field_150347_e, myMass - numOres);
        entry.variablility = (int)(uncertainty * (float)entry.stack.func_190916_E());
        entry.midpoint = (int)((float)entry.variablility * rand.nextFloat() - uncertainty * (float)entry.variablility / 2.0f);
        entry.midpoint = entry.midpoint + myMass - numOres < entry.variablility ? entry.variablility : (entry.midpoint += myMass - numOres);
        entries.add(entry);
        int[] ores = new int[this.itemStacks.size()];
        float normFactor = 0.0f;
        for (Float prob : this.stackProbabilites) {
            normFactor += prob.floatValue();
        }
        for (i = 0; i < numOres; ++i) {
            float probability = rand.nextFloat();
            float currentLocation = 0.0f;
            int counter = 0;
            Item item = null;
            for (Float prob : this.stackProbabilites) {
                if (probability <= currentLocation + prob.floatValue() / normFactor && currentLocation <= probability) {
                    item = this.itemStacks.get(counter).func_77973_b();
                    break;
                }
                ++counter;
                currentLocation += prob.floatValue() / normFactor;
            }
            if (counter >= this.itemStacks.size()) continue;
            int n = counter;
            ores[n] = ores[n] + 1;
        }
        for (i = 0; i < this.itemStacks.size(); ++i) {
            int num = ores[i];
            if (num == 0) continue;
            ItemStack stack = new ItemStack(this.itemStacks.get(i).func_77973_b(), num, this.itemStacks.get(i).func_77960_j());
            entry = new StackEntry();
            entry.stack = stack;
            entry.variablility = (int)(uncertainty * rand.nextFloat() * (float)num);
            entry.midpoint = (int)((float)entry.variablility * rand.nextFloat() - (float)entry.variablility / 2.0f);
            entry.midpoint = entry.midpoint + num < entry.variablility ? entry.variablility : (entry.midpoint += num);
            entries.add(entry);
        }
        return entries;
    }

    public static class StackEntry {
        public ItemStack stack;
        public int variablility;
        public int midpoint;
        public boolean isKnown;
    }
}

