/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.infrastructure;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.Configuration;
import zmaster587.advancedRocketry.api.EntityRocketBase;
import zmaster587.advancedRocketry.api.IInfrastructure;
import zmaster587.advancedRocketry.api.IMission;
import zmaster587.advancedRocketry.api.fuel.FuelRegistry;
import zmaster587.advancedRocketry.block.BlockTileRedstoneEmitter;
import zmaster587.advancedRocketry.tile.TileRocketBuilder;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.gui.CommonResources;
import zmaster587.libVulpes.interfaces.ILinkableTile;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleImage;
import zmaster587.libVulpes.inventory.modules.ModuleLiquidIndicator;
import zmaster587.libVulpes.inventory.modules.ModulePower;
import zmaster587.libVulpes.inventory.modules.ModuleRedstoneOutputButton;
import zmaster587.libVulpes.inventory.modules.ModuleSlotArray;
import zmaster587.libVulpes.items.ItemLinker;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.tile.IMultiblock;
import zmaster587.libVulpes.tile.TileInventoriedRFConsumerTank;
import zmaster587.libVulpes.util.HashedBlockPosition;
import zmaster587.libVulpes.util.INetworkMachine;
import zmaster587.libVulpes.util.IconResource;
import zmaster587.libVulpes.util.ZUtils;

public class TileEntityFuelingStation
extends TileInventoriedRFConsumerTank
implements IModularInventory,
IMultiblock,
IInfrastructure,
ILinkableTile,
INetworkMachine,
IButtonInventory {
    EntityRocketBase linkedRocket;
    HashedBlockPosition masterBlock = new HashedBlockPosition(0, -1, 0);
    ModuleRedstoneOutputButton redstoneControl = new ModuleRedstoneOutputButton(174, 4, 0, "", (IButtonInventory)this);
    ZUtils.RedstoneState state = ZUtils.RedstoneState.ON;

    public TileEntityFuelingStation() {
        super(1000, 3, 5000);
    }

    @Override
    public int getMaxLinkDistance() {
        return 10;
    }

    private void setRedstoneState(boolean condition) {
        if (this.state == ZUtils.RedstoneState.INVERTED) {
            condition = !condition;
        } else if (this.state == ZUtils.RedstoneState.OFF) {
            condition = false;
        }
        ((BlockTileRedstoneEmitter)AdvancedRocketryBlocks.blockFuelingStation).setRedstoneState(this.field_145850_b, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_174879_c, condition);
    }

    public void performFunction() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.tank.getFluid() != null) {
                float multiplier = FuelRegistry.instance.getMultiplier(FuelRegistry.FuelType.LIQUID, this.tank.getFluid().getFluid());
                this.tank.drain(this.linkedRocket.addFuelAmount((int)(multiplier * (float)Configuration.fuelPointsPer10Mb)), true);
            }
            this.setRedstoneState(this.linkedRocket.getFuelAmount() == this.linkedRocket.getFuelCapacity());
        }
        this.useBucket(0, this.inventory.func_70301_a(0));
    }

    public int getPowerPerOperation() {
        return 30;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public boolean canPerformFunction() {
        return this.linkedRocket != null && this.tank.getFluid() != null && this.tank.getFluidAmount() > 9 && this.linkedRocket.getRocketStats().getFuelAmount(FuelRegistry.FuelType.LIQUID) < this.linkedRocket.getRocketStats().getFuelCapacity(FuelRegistry.FuelType.LIQUID);
    }

    public boolean canFill(Fluid fluid) {
        return FuelRegistry.instance.isFuel(FuelRegistry.FuelType.LIQUID, fluid);
    }

    public String getModularInventoryName() {
        return "Fueling Station";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        super.func_70299_a(slot, stack);
        while (this.useBucket(0, this.func_70301_a(0))) {
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean useBucket(int slot, ItemStack stack) {
        if (slot != 0 || !stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, EnumFacing.UP)) return false;
        IFluidHandlerItem fluidItem = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, EnumFacing.UP);
        FluidStack fluidStack = fluidItem.getTankProperties()[0].getContents();
        if (fluidStack == null || !FuelRegistry.instance.isFuel(FuelRegistry.FuelType.LIQUID, fluidStack.getFluid()) || this.tank.getFluidAmount() + fluidItem.getTankProperties()[0].getCapacity() > this.tank.getCapacity()) return false;
        ItemStack emptyContainer = stack.func_77946_l();
        emptyContainer.func_190920_e(1);
        ((IFluidHandlerItem)emptyContainer.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, EnumFacing.UP)).drain(8000, true);
        if (emptyContainer.func_190926_b()) {
            this.tank.fill(fluidStack, true);
            this.func_70298_a(0, 1);
            return true;
        } else {
            if (((emptyContainer = ((IFluidHandlerItem)emptyContainer.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, EnumFacing.UP)).getContainer()).func_190926_b() || !this.inventory.func_70301_a(1).func_190926_b()) && (!emptyContainer.func_77969_a(this.inventory.func_70301_a(1)) || this.inventory.func_70301_a(1).func_190916_E() >= this.inventory.func_70301_a(1).func_77976_d())) return false;
            this.tank.fill(fluidStack, true);
            if (this.inventory.func_70301_a(1).func_190926_b()) {
                super.func_70299_a(1, emptyContainer);
            } else {
                this.inventory.func_70301_a(1).func_190920_e(this.inventory.func_70301_a(1).func_190916_E() + 1);
            }
            this.func_70298_a(0, 1);
        }
        return true;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, EnumFacing.UP)) {
            FluidStack fstack = ((IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, EnumFacing.UP)).getTankProperties()[0].getContents();
            return fstack != null && FuelRegistry.instance.isFuel(FuelRegistry.FuelType.LIQUID, fstack.getFluid());
        }
        return FuelRegistry.instance.isFuel(FuelRegistry.FuelType.LIQUID, stack);
    }

    @Override
    public void unlinkRocket() {
        this.linkedRocket = null;
        ((BlockTileRedstoneEmitter)AdvancedRocketryBlocks.blockFuelingStation).setRedstoneState(this.field_145850_b, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_174879_c, false);
    }

    @Override
    public boolean disconnectOnLiftOff() {
        return true;
    }

    @Override
    public boolean linkRocket(EntityRocketBase rocket) {
        this.linkedRocket = rocket;
        this.setRedstoneState(this.linkedRocket.getFuelAmount() == this.linkedRocket.getFuelCapacity());
        return true;
    }

    public boolean onLinkStart(ItemStack item, TileEntity entity, EntityPlayer player, World world) {
        ItemLinker.setMasterCoords((ItemStack)item, (BlockPos)this.field_174879_c);
        if (this.linkedRocket != null) {
            this.linkedRocket.unlinkInfrastructure(this);
            this.unlinkRocket();
        }
        if (player.field_70170_p.field_72995_K) {
            Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentString(LibVulpes.proxy.getLocalizedString("msg.fuelingStation.link") + ": " + this.field_174879_c.func_177958_n() + " " + this.field_174879_c.func_177956_o() + " " + this.field_174879_c.func_177952_p()));
        }
        return true;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.getMasterBlock() instanceof TileRocketBuilder) {
            ((TileRocketBuilder)this.getMasterBlock()).removeConnectedInfrastructure((TileEntity)this);
        }
        if (this.linkedRocket != null) {
            this.linkedRocket.unlinkInfrastructure(this);
        }
    }

    public boolean onLinkComplete(ItemStack item, TileEntity entity, EntityPlayer player, World world) {
        if (player.field_70170_p.field_72995_K) {
            Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentTranslation("msg.linker.error.firstMachine", new Object[0]));
        }
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return new int[]{1};
        }
        return new int[]{0};
    }

    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        ArrayList<ModuleBase> list = new ArrayList<ModuleBase>();
        list.add((ModuleBase)new ModulePower(156, 12, (IUniversalEnergy)this));
        list.add((ModuleBase)new ModuleSlotArray(45, 18, (IInventory)this, 0, 1));
        list.add((ModuleBase)new ModuleSlotArray(45, 54, (IInventory)this, 1, 2));
        list.add((ModuleBase)this.redstoneControl);
        if (this.field_145850_b.field_72995_K) {
            list.add((ModuleBase)new ModuleImage(44, 35, new IconResource(194, 0, 18, 18, CommonResources.genericBackground)));
        }
        list.add((ModuleBase)new ModuleLiquidIndicator(27, 18, (IFluidHandler)this));
        return list;
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean canInteractWithContainer(EntityPlayer entity) {
        return true;
    }

    @Override
    public boolean linkMission(IMission misson) {
        return false;
    }

    @Override
    public void unlinkMission() {
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("redstoneState", (byte)this.state.ordinal());
        if (this.hasMaster()) {
            nbt.func_74783_a("masterPos", new int[]{this.masterBlock.x, this.masterBlock.y, this.masterBlock.z});
        }
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.state = ZUtils.RedstoneState.values()[nbt.func_74771_c("redstoneState")];
        this.redstoneControl.setRedstoneState(this.state);
        if (nbt.func_74764_b("masterPos")) {
            int[] pos = nbt.func_74759_k("masterPos");
            this.setMasterBlock(new BlockPos(pos[0], pos[1], pos[2]));
        }
    }

    public boolean hasMaster() {
        return this.masterBlock.y > -1;
    }

    public TileEntity getMasterBlock() {
        return this.field_145850_b.func_175625_s(new BlockPos(this.masterBlock.x, (int)this.masterBlock.y, this.masterBlock.z));
    }

    public void setComplete(BlockPos pos) {
    }

    public void setIncomplete() {
        this.masterBlock.y = (short)-1;
    }

    public void setMasterBlock(BlockPos pos) {
        this.masterBlock = new HashedBlockPosition(pos);
    }

    @Override
    public boolean canRenderConnection() {
        return true;
    }

    public void onInventoryButtonPressed(int buttonId) {
        this.state = this.redstoneControl.getState();
        PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 0));
    }

    public void writeDataToNetwork(ByteBuf out, byte id) {
        out.writeByte(this.state.ordinal());
    }

    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt) {
        nbt.func_74774_a("state", in.readByte());
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        this.state = ZUtils.RedstoneState.values()[nbt.func_74771_c("state")];
        if (this.linkedRocket != null) {
            this.setRedstoneState(this.linkedRocket.getFuelAmount() == this.linkedRocket.getFuelCapacity());
        }
    }

    public boolean func_191420_l() {
        return this.inventory.func_191420_l();
    }
}

