/*
 * Decompiled with CFR 0.152.
 */
package vazkii.arl.util;

import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="autoreglib")
public final class ClientTicker {
    public static int ticksInGame = 0;
    public static float partialTicks = 0.0f;
    public static float delta = 0.0f;
    public static float total = 0.0f;
    private static Queue<Runnable> pendingActions = new ArrayDeque<Runnable>();

    public static void addAction(Runnable action) {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            pendingActions.add(action);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void calcDelta() {
        float oldTotal = total;
        total = (float)ticksInGame + partialTicks;
        delta = total - oldTotal;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void renderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            partialTicks = event.renderTickTime;
        } else {
            ClientTicker.calcDelta();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void clientTickEnd(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
            if (gui == null || !gui.func_73868_f()) {
                ++ticksInGame;
                partialTicks = 0.0f;
            }
            while (!pendingActions.isEmpty()) {
                pendingActions.poll().run();
            }
            ClientTicker.calcDelta();
        }
    }
}

