/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.Internal;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IIngredientType;
import mezz.jei.ingredients.IngredientRegistry;

public class Ingredients
implements IIngredients {
    private final Map<IIngredientType, List<List>> inputs = new IdentityHashMap<IIngredientType, List<List>>();
    private final Map<IIngredientType, List<List>> outputs = new IdentityHashMap<IIngredientType, List<List>>();

    @Override
    public <T> void setInput(IIngredientType<T> ingredientType, T input) {
        this.setInputs(ingredientType, Collections.singletonList(input));
    }

    @Override
    @Deprecated
    public <T> void setInput(Class<? extends T> ingredientClass, T input) {
        IngredientRegistry ingredientRegistry = Internal.getIngredientRegistry();
        IIngredientType<? extends T> ingredientType = ingredientRegistry.getIngredientType(ingredientClass);
        this.setInput(ingredientType, input);
    }

    @Override
    public <T> void setInputLists(IIngredientType<T> ingredientType, List<List<T>> inputs) {
        IngredientRegistry ingredientRegistry = Internal.getIngredientRegistry();
        IIngredientHelper<T> ingredientHelper = ingredientRegistry.getIngredientHelper(ingredientType);
        ArrayList<List<T>> expandedInputs = new ArrayList<List<T>>();
        for (List<T> input : inputs) {
            List<T> itemStacks = ingredientHelper.expandSubtypes(input);
            expandedInputs.add(itemStacks);
        }
        this.inputs.put(ingredientType, expandedInputs);
    }

    @Override
    @Deprecated
    public <T> void setInputLists(Class<? extends T> ingredientClass, List<List<T>> inputs) {
        IngredientRegistry ingredientRegistry = Internal.getIngredientRegistry();
        IIngredientType<? extends T> ingredientType = ingredientRegistry.getIngredientType(ingredientClass);
        this.setInputLists(ingredientType, inputs);
    }

    @Override
    public <T> void setInputs(IIngredientType<T> ingredientType, List<T> input) {
        IngredientRegistry ingredientRegistry = Internal.getIngredientRegistry();
        IIngredientHelper<T> ingredientHelper = ingredientRegistry.getIngredientHelper(ingredientType);
        ArrayList<List<T>> expandedInputs = new ArrayList<List<T>>();
        for (T input1 : input) {
            List<T> itemStacks = ingredientHelper.expandSubtypes(Collections.singletonList(input1));
            expandedInputs.add(itemStacks);
        }
        this.inputs.put(ingredientType, expandedInputs);
    }

    @Override
    @Deprecated
    public <T> void setInputs(Class<? extends T> ingredientClass, List<T> input) {
        IngredientRegistry ingredientRegistry = Internal.getIngredientRegistry();
        IIngredientType<? extends T> ingredientType = ingredientRegistry.getIngredientType(ingredientClass);
        this.setInputs(ingredientType, input);
    }

    @Override
    public <T> void setOutput(IIngredientType<T> ingredientType, T output) {
        this.setOutputs(ingredientType, Collections.singletonList(output));
    }

    @Override
    @Deprecated
    public <T> void setOutput(Class<? extends T> ingredientClass, T output) {
        IngredientRegistry ingredientRegistry = Internal.getIngredientRegistry();
        IIngredientType<? extends T> ingredientType = ingredientRegistry.getIngredientType(ingredientClass);
        this.setOutput(ingredientType, output);
    }

    @Override
    public <T> void setOutputs(IIngredientType<T> ingredientType, List<T> outputs) {
        IngredientRegistry ingredientRegistry = Internal.getIngredientRegistry();
        IIngredientHelper<T> ingredientHelper = ingredientRegistry.getIngredientHelper(ingredientType);
        ArrayList<List<T>> expandedOutputs = new ArrayList<List<T>>();
        for (T output : outputs) {
            List<T> expandedOutput = ingredientHelper.expandSubtypes(Collections.singletonList(output));
            expandedOutputs.add(expandedOutput);
        }
        this.outputs.put(ingredientType, expandedOutputs);
    }

    @Override
    @Deprecated
    public <T> void setOutputs(Class<? extends T> ingredientClass, List<T> outputs) {
        IngredientRegistry ingredientRegistry = Internal.getIngredientRegistry();
        IIngredientType<? extends T> ingredientType = ingredientRegistry.getIngredientType(ingredientClass);
        this.setOutputs(ingredientType, outputs);
    }

    @Override
    public <T> void setOutputLists(IIngredientType<T> ingredientType, List<List<T>> outputs) {
        IngredientRegistry ingredientRegistry = Internal.getIngredientRegistry();
        IIngredientHelper<T> ingredientHelper = ingredientRegistry.getIngredientHelper(ingredientType);
        ArrayList<List<T>> expandedOutputs = new ArrayList<List<T>>();
        for (List<T> output : outputs) {
            List<T> itemStacks = ingredientHelper.expandSubtypes(output);
            expandedOutputs.add(itemStacks);
        }
        this.outputs.put(ingredientType, expandedOutputs);
    }

    @Override
    @Deprecated
    public <T> void setOutputLists(Class<? extends T> ingredientClass, List<List<T>> outputs) {
        IngredientRegistry ingredientRegistry = Internal.getIngredientRegistry();
        IIngredientType<? extends T> ingredientType = ingredientRegistry.getIngredientType(ingredientClass);
        this.setOutputLists(ingredientType, outputs);
    }

    @Override
    public <T> List<List<T>> getInputs(IIngredientType<T> ingredientType) {
        List<List<T>> inputs = this.inputs.get(ingredientType);
        if (inputs == null) {
            return Collections.emptyList();
        }
        return inputs;
    }

    @Override
    @Deprecated
    public <T> List<List<T>> getInputs(Class<? extends T> ingredientClass) {
        IngredientRegistry ingredientRegistry = Internal.getIngredientRegistry();
        IIngredientType<? extends T> ingredientType = ingredientRegistry.getIngredientType(ingredientClass);
        return this.getInputs(ingredientType);
    }

    @Override
    public <T> List<List<T>> getOutputs(IIngredientType<T> ingredientType) {
        List<List<T>> outputs = this.outputs.get(ingredientType);
        if (outputs == null) {
            return Collections.emptyList();
        }
        return outputs;
    }

    @Override
    @Deprecated
    public <T> List<List<T>> getOutputs(Class<? extends T> ingredientClass) {
        IngredientRegistry ingredientRegistry = Internal.getIngredientRegistry();
        IIngredientType<? extends T> ingredientType = ingredientRegistry.getIngredientType(ingredientClass);
        return this.getOutputs(ingredientType);
    }

    public Map<IIngredientType, List> getInputIngredients() {
        IdentityHashMap<IIngredientType, List> inputIngredients = new IdentityHashMap<IIngredientType, List>();
        for (Map.Entry<IIngredientType, List<List>> entry : this.inputs.entrySet()) {
            ArrayList flatIngredients = new ArrayList();
            for (List ingredients : entry.getValue()) {
                flatIngredients.addAll(ingredients);
            }
            inputIngredients.put(entry.getKey(), flatIngredients);
        }
        return inputIngredients;
    }

    public Map<IIngredientType, List> getOutputIngredients() {
        IdentityHashMap<IIngredientType, List> outputIngredients = new IdentityHashMap<IIngredientType, List>();
        for (Map.Entry<IIngredientType, List<List>> entry : this.outputs.entrySet()) {
            ArrayList flatIngredients = new ArrayList();
            for (List ingredients : entry.getValue()) {
                flatIngredients.addAll(ingredients);
            }
            outputIngredients.put(entry.getKey(), flatIngredients);
        }
        return outputIngredients;
    }
}

