/*
 * Decompiled with CFR 0.152.
 */
package rustic.compat.dynamictrees;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.ferreusveritas.dynamictrees.api.worldgen.IBiomeDataBasePopulator;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDataBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import rustic.common.Config;

public class BiomeDataBasePopulator
implements IBiomeDataBasePopulator {
    private static Species olive;
    private static Species ironwood;

    private static void createStaticAliases() {
        olive = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("rustic", "olive"));
        ironwood = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("rustic", "ironwood"));
    }

    public void populate(BiomeDataBase dbase) {
        if (olive == null) {
            BiomeDataBasePopulator.createStaticAliases();
        }
        int oliveWeight = (int)(Config.OLIVE_GEN_CHANCE * 500.0f);
        int ironWeight = (int)(Config.IRONWOOD_GEN_CHANCE * 500.0f);
        BiomePropertySelectors.RandomSpeciesSelector oliveSelector = oliveWeight == 0 ? null : new BiomePropertySelectors.RandomSpeciesSelector().add(1000 - oliveWeight).add(olive, oliveWeight);
        BiomePropertySelectors.RandomSpeciesSelector ironSelector = ironWeight == 0 ? null : new BiomePropertySelectors.RandomSpeciesSelector().add(1000 - ironWeight).add(ironwood, ironWeight);
        BiomePropertySelectors.RandomSpeciesSelector bothSelector = oliveWeight == 0 || ironWeight == 0 ? null : new BiomePropertySelectors.RandomSpeciesSelector().add(1000 - (oliveWeight + ironWeight)).add(olive, oliveWeight).add(ironwood, ironWeight);
        Biome.field_185377_q.forEach(biome -> {
            boolean ironSplice;
            boolean oliveSplice = oliveSelector != null && !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY) && !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY) && !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DEAD) && !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA) && (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN));
            boolean bl = ironSplice = ironSelector != null && !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY) && !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY) && !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DEAD) && !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA) && (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE));
            if (oliveSplice || ironSplice) {
                dbase.setSpeciesSelector(biome, (BiomePropertySelectors.ISpeciesSelector)(oliveSplice && ironSplice ? bothSelector : (ironSplice ? ironSelector : oliveSelector)), BiomeDataBase.Operation.SPLICE_BEFORE);
            }
        });
    }
}

