/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.blocks;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import rustic.common.blocks.BlockBase;
import rustic.common.blocks.BlockRetort;
import rustic.common.blocks.ModBlocks;
import rustic.common.tileentity.TileEntityCondenserAdvanced;
import rustic.core.Rustic;

public class BlockCondenserAdvanced
extends BlockBase
implements ITileEntityProvider {
    public static final int GUI_ID = 5;
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyBool BOTTOM = PropertyBool.func_177716_a((String)"bottom");

    public BlockCondenserAdvanced() {
        super(Material.field_151576_e, "condenser_advanced");
        this.func_149711_c(2.0f);
        this.func_149647_a(Rustic.alchemyTab);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BOTTOM, (Comparable)Boolean.valueOf(true)));
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)BOTTOM, (Comparable)Boolean.valueOf(true));
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && worldIn.func_175623_d(pos.func_177984_a());
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)BOTTOM)).booleanValue()) {
            world.func_175656_a(pos.func_177984_a(), state.func_177226_a((IProperty)BOTTOM, (Comparable)Boolean.valueOf(false)));
        }
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if ((((Boolean)state.func_177229_b((IProperty)BOTTOM)).booleanValue() && world.func_180495_p(pos.func_177984_a()).func_177230_c() == this || !((Boolean)state.func_177229_b((IProperty)BOTTOM)).booleanValue() && world.func_180495_p(pos.func_177977_b()).func_177230_c() == this) && !world.field_72995_K && !player.field_71075_bZ.field_75098_d) {
            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, new ItemStack((Block)this, 1, 0)));
        }
        if (((Boolean)state.func_177229_b((IProperty)BOTTOM)).booleanValue()) {
            world.func_175698_g(pos.func_177984_a());
        } else {
            world.func_175698_g(pos.func_177977_b());
        }
    }

    public boolean func_149686_d(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BOTTOM);
    }

    public boolean func_149662_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BOTTOM);
    }

    public int func_149717_k(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BOTTOM) != false ? super.func_149717_k(state) : 0;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)BOTTOM, (Comparable)Boolean.valueOf((meta & 4) > 0));
        return state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(5 - (meta & 3))));
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        if (((Boolean)state.func_177229_b((IProperty)BOTTOM)).booleanValue()) {
            meta |= 4;
        }
        return meta |= 5 - ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, BOTTOM});
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        if (((Boolean)this.func_176203_a(meta).func_177229_b((IProperty)BOTTOM)).booleanValue()) {
            return new TileEntityCondenserAdvanced();
        }
        return null;
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(id, param);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity;
        if (((Boolean)state.func_177229_b((IProperty)BOTTOM)).booleanValue() && (tileentity = worldIn.func_175625_s(pos)) != null && tileentity instanceof TileEntityCondenserAdvanced) {
            ((TileEntityCondenserAdvanced)tileentity).breakBlock(worldIn, pos, state);
            worldIn.func_175713_t(pos);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (((Boolean)state.func_177229_b((IProperty)BOTTOM)).booleanValue()) {
            if (world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof TileEntityCondenserAdvanced && this.hasRetorts(world, pos, state)) {
                if (!((TileEntityCondenserAdvanced)world.func_175625_s(pos)).activate(world, pos, state, player, hand, side, hitX, hitY, hitZ)) {
                    if (world.field_72995_K) {
                        return true;
                    }
                    player.openGui((Object)Rustic.instance, 5, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    return true;
                }
                return true;
            }
        } else if (world.func_175625_s(pos.func_177977_b()) != null && world.func_175625_s(pos.func_177977_b()) instanceof TileEntityCondenserAdvanced && this.hasRetorts(world, pos.func_177977_b(), world.func_180495_p(pos.func_177977_b()))) {
            if (!((TileEntityCondenserAdvanced)world.func_175625_s(pos.func_177977_b())).activate(world, pos.func_177977_b(), state, player, hand, side, hitX, hitY, hitZ)) {
                if (world.field_72995_K) {
                    return true;
                }
                player.openGui((Object)Rustic.instance, 5, world, pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p());
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean hasRetorts(World world, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() != this) {
            return false;
        }
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case NORTH: {
                if (world.func_180495_p(pos.func_177974_f()).func_177230_c() != ModBlocks.RETORT_ADVANCED || world.func_180495_p(pos.func_177976_e()).func_177230_c() != ModBlocks.RETORT_ADVANCED || world.func_180495_p(pos.func_177968_d()).func_177230_c() != ModBlocks.RETORT_ADVANCED) {
                    return false;
                }
                if (world.func_180495_p(pos.func_177974_f()).func_177229_b((IProperty)BlockRetort.FACING) == EnumFacing.EAST && world.func_180495_p(pos.func_177976_e()).func_177229_b((IProperty)BlockRetort.FACING) == EnumFacing.WEST && world.func_180495_p(pos.func_177968_d()).func_177229_b((IProperty)BlockRetort.FACING) == EnumFacing.SOUTH) break;
                return false;
            }
            case SOUTH: {
                if (world.func_180495_p(pos.func_177974_f()).func_177230_c() != ModBlocks.RETORT_ADVANCED || world.func_180495_p(pos.func_177976_e()).func_177230_c() != ModBlocks.RETORT_ADVANCED || world.func_180495_p(pos.func_177978_c()).func_177230_c() != ModBlocks.RETORT_ADVANCED) {
                    return false;
                }
                if (world.func_180495_p(pos.func_177974_f()).func_177229_b((IProperty)BlockRetort.FACING) == EnumFacing.EAST && world.func_180495_p(pos.func_177976_e()).func_177229_b((IProperty)BlockRetort.FACING) == EnumFacing.WEST && world.func_180495_p(pos.func_177978_c()).func_177229_b((IProperty)BlockRetort.FACING) == EnumFacing.NORTH) break;
                return false;
            }
            case WEST: {
                if (world.func_180495_p(pos.func_177978_c()).func_177230_c() != ModBlocks.RETORT_ADVANCED || world.func_180495_p(pos.func_177968_d()).func_177230_c() != ModBlocks.RETORT_ADVANCED || world.func_180495_p(pos.func_177974_f()).func_177230_c() != ModBlocks.RETORT_ADVANCED) {
                    return false;
                }
                if (world.func_180495_p(pos.func_177978_c()).func_177229_b((IProperty)BlockRetort.FACING) == EnumFacing.NORTH && world.func_180495_p(pos.func_177968_d()).func_177229_b((IProperty)BlockRetort.FACING) == EnumFacing.SOUTH && world.func_180495_p(pos.func_177974_f()).func_177229_b((IProperty)BlockRetort.FACING) == EnumFacing.EAST) break;
                return false;
            }
            case EAST: {
                if (world.func_180495_p(pos.func_177978_c()).func_177230_c() != ModBlocks.RETORT_ADVANCED || world.func_180495_p(pos.func_177968_d()).func_177230_c() != ModBlocks.RETORT_ADVANCED || world.func_180495_p(pos.func_177976_e()).func_177230_c() != ModBlocks.RETORT_ADVANCED) {
                    return false;
                }
                if (world.func_180495_p(pos.func_177978_c()).func_177229_b((IProperty)BlockRetort.FACING) == EnumFacing.NORTH && world.func_180495_p(pos.func_177968_d()).func_177229_b((IProperty)BlockRetort.FACING) == EnumFacing.SOUTH && world.func_180495_p(pos.func_177976_e()).func_177229_b((IProperty)BlockRetort.FACING) == EnumFacing.WEST) break;
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        if (((Boolean)state.func_177229_b((IProperty)BOTTOM)).booleanValue()) {
            return BlockFaceShape.SOLID;
        }
        if (side == EnumFacing.UP) {
            return BlockFaceShape.CENTER_BIG;
        }
        return BlockFaceShape.UNDEFINED;
    }
}

