/*
 * Decompiled with CFR 0.152.
 */
package extendedrenderer.render;

import CoroUtil.util.CoroUtilBlockLightCache;
import extendedrenderer.foliage.Foliage;
import extendedrenderer.particle.ParticleRegistry;
import extendedrenderer.particle.ShaderManager;
import extendedrenderer.render.RotatingParticleManager;
import extendedrenderer.shader.InstancedMeshFoliage;
import extendedrenderer.shader.Matrix4fe;
import extendedrenderer.shader.MeshBufferManagerFoliage;
import extendedrenderer.shader.ShaderEngine;
import extendedrenderer.shader.ShaderProgram;
import extendedrenderer.shader.Transformation;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class FoliageRenderer {
    private final TextureManager renderer;
    public static FloatBuffer projectionMatrixBuffer = BufferUtils.createFloatBuffer((int)16);
    public static FloatBuffer viewMatrixBuffer = BufferUtils.createFloatBuffer((int)16);
    public Transformation transformation;
    public ConcurrentHashMap<TextureAtlasSprite, List<Foliage>> foliage = new ConcurrentHashMap();
    public float windDir = 0.0f;
    public float windSpeedSmooth = 0.0f;
    public Lock lockVBO2 = new ReentrantLock();
    public static int radialRange = 40;
    public static boolean testStaticLimit = false;
    public static long windTime = 0L;

    public FoliageRenderer(TextureManager rendererIn) {
        this.renderer = rendererIn;
        this.transformation = new Transformation();
    }

    public List<Foliage> getFoliageForSprite(TextureAtlasSprite sprite) {
        if (!this.foliage.containsKey(sprite)) {
            ArrayList list = new ArrayList();
            this.foliage.put(sprite, list);
        }
        return this.foliage.get(sprite);
    }

    public void render(Entity entityIn, float partialTicks) {
        if (RotatingParticleManager.useShaders) {
            Minecraft mc = Minecraft.func_71410_x();
            EntityRenderer er = mc.field_71460_t;
            WorldClient world = mc.field_71441_e;
            GlStateManager.func_179132_a((boolean)true);
            mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            this.renderJustShaders(entityIn, partialTicks);
        }
    }

    public boolean getFlag(InstancedMeshFoliage mesh) {
        return mesh.dirtyVBO2Flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderJustShaders(Entity entityIn, float partialTicks) {
        int i;
        Minecraft mc = Minecraft.func_71410_x();
        EntityRenderer er = mc.field_71460_t;
        WorldClient world = mc.field_71441_e;
        Matrix4fe projectionMatrix = new Matrix4fe();
        FloatBuffer buf = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloat((int)2983, (FloatBuffer)buf);
        buf.rewind();
        Matrix4fe.get(projectionMatrix, 0, buf);
        boolean distantRendering = false;
        if (distantRendering) {
            float zNear = 0.05f;
            float zFar = (float)(mc.field_71474_y.field_151451_c * 16) * 4.0f;
            projectionMatrix.m22 = (zFar + zNear) / (zNear - zFar);
            projectionMatrix.m32 = (zFar + zFar) * zNear / (zNear - zFar);
        }
        Matrix4fe viewMatrix = new Matrix4fe();
        FloatBuffer buf2 = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloat((int)2982, (FloatBuffer)buf2);
        buf2.rewind();
        Matrix4fe.get(viewMatrix, 0, buf2);
        boolean threadedVBOUpdate = true;
        boolean test1 = false;
        ShaderProgram shaderProgram = ShaderEngine.renderer.getShaderProgram("foliage");
        shaderProgram.bind();
        if (test1) {
            try {
                shaderProgram.setUniformEfficient("projectionMatrix", projectionMatrix, projectionMatrixBuffer);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        shaderProgram.setUniform("texture_sampler", 0);
        int glFogMode = GL11.glGetInteger((int)2917);
        int modeIndex = 0;
        if (glFogMode == 9729) {
            modeIndex = 0;
        } else if (glFogMode == 2048) {
            modeIndex = 1;
        } else if (glFogMode == 2049) {
            modeIndex = 2;
        }
        shaderProgram.setUniform("fogmode", modeIndex);
        Random rand = new Random(5L);
        shaderProgram.setUniform("partialTick", partialTicks);
        shaderProgram.setUniform("windDir", this.windDir - 135.0f);
        shaderProgram.setUniform("windSpeed", this.windSpeedSmooth);
        try {
            shaderProgram.setUniform("time", (int)windTime);
        }
        catch (Exception exception) {
            // empty catch block
        }
        MeshBufferManagerFoliage.setupMeshIfMissing(ParticleRegistry.potato);
        MeshBufferManagerFoliage.setupMeshIfMissing(ParticleRegistry.chicken);
        for (i = 0; i < ParticleRegistry.listFish.size(); ++i) {
            MeshBufferManagerFoliage.setupMeshIfMissing(ParticleRegistry.listFish.get(i));
        }
        for (i = 0; i < ParticleRegistry.listSeaweed.size(); ++i) {
            MeshBufferManagerFoliage.setupMeshIfMissing(ParticleRegistry.listSeaweed.get(i));
        }
        int meshCount = 0;
        for (Map.Entry<TextureAtlasSprite, List<Foliage>> entry : this.foliage.entrySet()) {
            InstancedMeshFoliage mesh;
            block32: {
                mesh = MeshBufferManagerFoliage.getMesh(entry.getKey());
                if (mesh == null) {
                    System.out.println("NULL MESH FOR: " + entry.getKey().toString());
                    continue;
                }
                mesh.initRender();
                mesh.initRenderVBO1();
                mesh.initRenderVBO2();
                boolean updateVBO1 = true;
                if (this.lockVBO2.tryLock()) {
                    try {
                        if (this.getFlag(mesh)) {
                            mesh.interpPosX = mesh.interpPosXThread;
                            mesh.interpPosY = mesh.interpPosYThread;
                            mesh.interpPosZ = mesh.interpPosZThread;
                            OpenGlHelper.func_176072_g((int)34962, (int)mesh.instanceDataVBO2);
                            ShaderManager.glBufferData(34962, mesh.instanceDataBufferVBO2, 35048);
                            mesh.dirtyVBO2Flag = false;
                            mesh.curBufferPosVBO2Thread = mesh.curBufferPosVBO2;
                        }
                        if (!updateVBO1) break block32;
                        List<Foliage> listFoliage = entry.getValue();
                        mesh.instanceDataBufferVBO1.clear();
                        mesh.curBufferPosVBO1 = 0;
                        try {
                            for (int i2 = 0; i2 < listFoliage.size(); ++i2) {
                                Foliage foliage = listFoliage.get(i2);
                                boolean doAlpha = false;
                                if (doAlpha) {
                                    float distMax = 3.0f;
                                    double distFadeRange = 20.0;
                                    int rangeAdj = radialRange - (int)distFadeRange;
                                    double dist = entityIn.func_70011_f(foliage.posX, foliage.posY, foliage.posZ);
                                    if (dist > (double)rangeAdj - distFadeRange) {
                                        double diff = dist - ((double)rangeAdj - distFadeRange);
                                        foliage.particleAlpha = (float)(1.0 - diff / distFadeRange);
                                        if (foliage.particleAlpha < 0.0f) {
                                            foliage.particleAlpha = 0.0f;
                                        }
                                    } else {
                                        foliage.particleAlpha = 1.0f;
                                    }
                                } else {
                                    foliage.particleAlpha = 1.0f;
                                }
                                foliage.brightnessCache = CoroUtilBlockLightCache.brightnessPlayer + 0.0f;
                                foliage.renderForShaderVBO1(mesh, this.transformation, viewMatrix, entityIn, partialTicks);
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        if (testStaticLimit) {
                            mesh.instanceDataBufferVBO1.limit(30000 * 2);
                        } else {
                            mesh.instanceDataBufferVBO1.limit(mesh.curBufferPosVBO1 * 2);
                        }
                        OpenGlHelper.func_176072_g((int)34962, (int)mesh.instanceDataVBO1);
                        ShaderManager.glBufferData(34962, mesh.instanceDataBufferVBO1, 35048);
                    }
                    finally {
                        this.lockVBO2.unlock();
                    }
                }
            }
            float interpX = (float)(entityIn.field_70169_q + (entityIn.field_70165_t - entityIn.field_70169_q) * (double)partialTicks - mesh.interpPosX);
            float interpY = (float)(entityIn.field_70167_r + (entityIn.field_70163_u - entityIn.field_70167_r) * (double)partialTicks - mesh.interpPosY);
            float interpZ = (float)(entityIn.field_70166_s + (entityIn.field_70161_v - entityIn.field_70166_s) * (double)partialTicks - mesh.interpPosZ);
            Matrix4fe matrixFix = new Matrix4fe();
            matrixFix = matrixFix.translationRotateScale(-interpX, -interpY, -interpZ, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            projectionMatrix = new Matrix4fe();
            buf = BufferUtils.createFloatBuffer((int)16);
            GL11.glGetFloat((int)2983, (FloatBuffer)buf);
            buf.rewind();
            Matrix4fe.get(projectionMatrix, 0, buf);
            Matrix4fe modelViewMatrix = projectionMatrix.mul(viewMatrix);
            matrixFix = modelViewMatrix.mul(matrixFix);
            shaderProgram.setUniformEfficient("modelViewMatrixCamera", matrixFix, viewMatrixBuffer);
            if (mesh.curBufferPosVBO2Thread > 0) {
                ShaderManager.glDrawElementsInstanced(4, mesh.getVertexCount(), 5125, 0L, mesh.curBufferPosVBO2Thread);
                meshCount += mesh.curBufferPosVBO2Thread;
            }
            OpenGlHelper.func_176072_g((int)34962, (int)0);
            mesh.endRenderVBO1();
            mesh.endRenderVBO2();
            mesh.endRender();
        }
        boolean debugMeshCount = false;
        if (debugMeshCount) {
            System.out.println("meshCount: " + meshCount);
        }
        ShaderEngine.renderer.getShaderProgram("foliage").unbind();
    }
}

