/*
 * Decompiled with CFR 0.152.
 */
package extendedrenderer.particle.entity;

import CoroUtil.api.weather.IWindHandler;
import CoroUtil.util.CoroUtilBlockLightCache;
import CoroUtil.util.Vec3;
import extendedrenderer.ExtendedRenderer;
import extendedrenderer.particle.behavior.ParticleBehaviors;
import extendedrenderer.render.RotatingParticleManager;
import extendedrenderer.shader.IShaderRenderedEntity;
import extendedrenderer.shader.InstancedMeshParticle;
import extendedrenderer.shader.Matrix4fe;
import extendedrenderer.shader.Transformation;
import java.util.List;
import javax.vecmath.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Quaternion;
import org.lwjgl.util.vector.ReadableVector4f;
import org.lwjgl.util.vector.Vector4f;

@SideOnly(value=Side.CLIENT)
public class EntityRotFX
extends Particle
implements IWindHandler,
IShaderRenderedEntity {
    public boolean weatherEffect = false;
    public float spawnY = -1.0f;
    public int particleTextureIndexInt = 0;
    public float brightness = 0.7f;
    public ParticleBehaviors pb = null;
    public boolean callUpdateSuper = true;
    public boolean callUpdatePB = true;
    public float renderRange = 128.0f;
    public int renderOrder = 0;
    private int entityID = 0;
    public int debugID = 0;
    public float rotationYaw;
    public float rotationPitch;
    public float windWeight = 5.0f;
    public int particleDecayExtra = 0;
    public boolean isTransparent = true;
    public boolean killOnCollide = false;
    public boolean facePlayer = false;
    public boolean facePlayerYaw = false;
    public boolean vanillaMotionDampen = true;
    public double aboveGroundHeight = 4.5;
    public boolean checkAheadToBounce = true;
    public boolean collisionSpeedDampen = true;
    public double bounceSpeed = 0.05;
    public double bounceSpeedMax = 0.15;
    public double bounceSpeedAhead = 0.35;
    public double bounceSpeedMaxAhead = 0.25;
    public boolean spinFast = false;
    private float ticksFadeInMax = 0.0f;
    private float ticksFadeOutMax = 0.0f;
    private boolean dontRenderUnderTopmostBlock = false;
    private boolean killWhenUnderTopmostBlock = false;
    private int killWhenUnderTopmostBlock_ScanAheadRange = 0;
    public int killWhenUnderCameraAtLeast = 0;
    public int killWhenFarFromCameraAtLeast = 0;
    private float ticksFadeOutMaxOnDeath = -1.0f;
    private float ticksFadeOutCurOnDeath = 0.0f;
    protected boolean fadingOut = false;
    public float avoidTerrainAngle = 0.0f;
    public boolean useRotationAroundCenter = false;
    public float rotationAroundCenter = 0.0f;
    public float rotationAroundCenterPrev = 0.0f;
    public float rotationSpeedAroundCenter = 0.0f;
    public float rotationDistAroundCenter = 0.0f;
    private boolean slantParticleToWind = false;
    public Quaternion rotation;
    public Quaternion rotationPrev;
    public boolean quatControl = false;
    public boolean fastLight = false;
    public float brightnessCache = 0.5f;
    public boolean rotateOrderXY = false;
    public float extraYRotation = 0.0f;
    public boolean isCollidedHorizontally = false;
    public boolean isCollidedVerticallyDownwards = false;
    public boolean isCollidedVerticallyUpwards = false;
    public Vector3f rotationAround = new Vector3f();

    public EntityRotFX(World par1World, double par2, double par4, double par6, double par8, double par10, double par12) {
        super(par1World, par2, par4, par6, par8, par10, par12);
        this.func_187115_a(0.3f, 0.3f);
        this.entityID = par1World.field_73012_v.nextInt(100000);
        this.rotation = new Quaternion();
        this.brightnessCache = CoroUtilBlockLightCache.getBrightnessCached(this.field_187122_b, (float)this.field_187126_f, (float)this.field_187127_g, (float)this.field_187128_h);
    }

    public boolean isSlantParticleToWind() {
        return this.slantParticleToWind;
    }

    public void setSlantParticleToWind(boolean slantParticleToWind) {
        this.slantParticleToWind = slantParticleToWind;
    }

    public float getTicksFadeOutMaxOnDeath() {
        return this.ticksFadeOutMaxOnDeath;
    }

    public void setTicksFadeOutMaxOnDeath(float ticksFadeOutMaxOnDeath) {
        this.ticksFadeOutMaxOnDeath = ticksFadeOutMaxOnDeath;
    }

    public boolean isKillWhenUnderTopmostBlock() {
        return this.killWhenUnderTopmostBlock;
    }

    public void setKillWhenUnderTopmostBlock(boolean killWhenUnderTopmostBlock) {
        this.killWhenUnderTopmostBlock = killWhenUnderTopmostBlock;
    }

    public boolean isDontRenderUnderTopmostBlock() {
        return this.dontRenderUnderTopmostBlock;
    }

    public void setDontRenderUnderTopmostBlock(boolean dontRenderUnderTopmostBlock) {
        this.dontRenderUnderTopmostBlock = dontRenderUnderTopmostBlock;
    }

    public float getTicksFadeInMax() {
        return this.ticksFadeInMax;
    }

    public void setTicksFadeInMax(float ticksFadeInMax) {
        this.ticksFadeInMax = ticksFadeInMax;
    }

    public float getTicksFadeOutMax() {
        return this.ticksFadeOutMax;
    }

    public void setTicksFadeOutMax(float ticksFadeOutMax) {
        this.ticksFadeOutMax = ticksFadeOutMax;
    }

    public int getParticleTextureIndex() {
        return this.particleTextureIndexInt;
    }

    public void func_187114_a(int par) {
        this.field_70547_e = par;
    }

    public float getAlphaF() {
        return this.field_82339_as;
    }

    public void func_187112_i() {
        if (this.pb != null) {
            this.pb.particles.remove(this);
        }
        super.func_187112_i();
    }

    public void func_189213_a() {
        super.func_189213_a();
        Entity ent = Minecraft.func_71410_x().func_175606_aa();
        if (!this.isVanillaMotionDampen()) {
            this.field_187129_i /= (double)0.98f;
            this.field_187130_j /= (double)0.98f;
            this.field_187131_k /= (double)0.98f;
        }
        if (!this.field_187133_m && !this.fadingOut) {
            int height;
            if (this.killOnCollide && this.isCollided()) {
                this.startDeath();
            }
            if (this.killWhenUnderTopmostBlock && this.field_187127_g - (double)this.killWhenUnderTopmostBlock_ScanAheadRange <= (double)(height = this.field_187122_b.func_175725_q(new BlockPos(this.field_187126_f, this.field_187127_g, this.field_187128_h)).func_177956_o())) {
                this.startDeath();
            }
            if (this.killWhenUnderCameraAtLeast != 0 && this.field_187127_g < ent.field_70163_u - (double)this.killWhenUnderCameraAtLeast) {
                this.startDeath();
            }
            if (this.killWhenFarFromCameraAtLeast != 0 && this.getAge() > 20 && this.getAge() % 5 == 0 && ent.func_70011_f(this.field_187126_f, this.field_187127_g, this.field_187128_h) > (double)this.killWhenFarFromCameraAtLeast) {
                this.startDeath();
            }
        }
        if (!this.collisionSpeedDampen && this.field_187132_l) {
            this.field_187129_i /= (double)0.7f;
            this.field_187131_k /= (double)0.7f;
        }
        if (this.spinFast) {
            this.rotationPitch += this.entityID % 2 == 0 ? 10.0f : -10.0f;
            this.rotationYaw += this.entityID % 2 == 0 ? -10.0f : 10.0f;
        }
        if (!this.fadingOut) {
            if (this.ticksFadeInMax > 0.0f && (float)this.getAge() < this.ticksFadeInMax) {
                this.func_82338_g((float)this.getAge() / this.ticksFadeInMax);
            } else if (this.ticksFadeOutMax > 0.0f && (float)this.getAge() > (float)this.getMaxAge() - this.ticksFadeOutMax) {
                float count = (float)this.getAge() - ((float)this.getMaxAge() - this.ticksFadeOutMax);
                float val = (this.ticksFadeOutMax - count) / this.ticksFadeOutMax;
                this.func_82338_g(val);
            } else if (this.ticksFadeInMax > 0.0f || this.ticksFadeOutMax > 0.0f) {
                this.func_82338_g(1.0f);
            }
        } else {
            if (this.ticksFadeOutCurOnDeath < this.ticksFadeOutMaxOnDeath) {
                this.ticksFadeOutCurOnDeath += 1.0f;
            } else {
                this.func_187112_i();
            }
            float val = 1.0f - this.ticksFadeOutCurOnDeath / this.ticksFadeOutMaxOnDeath;
            this.func_82338_g(val);
        }
        if (this.field_187122_b.func_82737_E() % 5L == 0L) {
            this.brightnessCache = CoroUtilBlockLightCache.getBrightnessCached(this.field_187122_b, (float)this.field_187126_f, (float)this.field_187127_g, (float)this.field_187128_h);
        }
        this.rotationAroundCenter += this.rotationSpeedAroundCenter;
        this.rotationAroundCenter %= 360.0f;
        this.tickExtraRotations();
    }

    public void tickExtraRotations() {
        if (this.slantParticleToWind) {
            double motionXZ = Math.sqrt(this.field_187129_i * this.field_187129_i + this.field_187131_k * this.field_187131_k);
            this.rotationPitch = (float)Math.atan2(this.field_187130_j, motionXZ);
        }
        if (!this.quatControl) {
            this.rotationPrev = new Quaternion((ReadableVector4f)this.rotation);
            Entity ent = Minecraft.func_71410_x().func_175606_aa();
            this.updateQuaternion(ent);
        }
    }

    public void startDeath() {
        if (this.ticksFadeOutMaxOnDeath > 0.0f) {
            this.ticksFadeOutCurOnDeath = 0.0f;
            this.fadingOut = true;
        } else {
            this.func_187112_i();
        }
    }

    public void func_70536_a(int par1) {
        this.particleTextureIndexInt = par1;
        if (this.func_70537_b() == 0) {
            super.func_70536_a(par1);
        }
    }

    public int func_70537_b() {
        return 5;
    }

    public void spawnAsWeatherEffect() {
        this.weatherEffect = true;
        ExtendedRenderer.rotEffRenderer.addEffect(this);
    }

    public int getAge() {
        return this.field_70546_d;
    }

    public void setAge(int age) {
        this.field_70546_d = age;
    }

    public int getMaxAge() {
        return this.field_70547_e;
    }

    public void func_187115_a(float par1, float par2) {
        super.func_187115_a(par1, par2);
        this.func_187109_b(this.field_187126_f, this.field_187127_g, this.field_187128_h);
    }

    public void setGravity(float par) {
        this.field_70545_g = par;
    }

    public float maxRenderRange() {
        return this.renderRange;
    }

    public void setScale(float parScale) {
        this.field_70544_f = parScale;
    }

    @Override
    public Vector3f getPosition() {
        return new Vector3f((float)this.field_187126_f, (float)this.field_187127_g, (float)this.field_187128_h);
    }

    @Override
    public Quaternion getQuaternion() {
        return this.rotation;
    }

    @Override
    public Quaternion getQuaternionPrev() {
        return this.rotationPrev;
    }

    @Override
    public float getScale() {
        return this.field_70544_f;
    }

    public Vec3 getPos() {
        return new Vec3(this.field_187126_f, this.field_187127_g, this.field_187128_h);
    }

    public double getPosX() {
        return this.field_187126_f;
    }

    public void setPosX(double posX) {
        this.field_187126_f = posX;
    }

    public double getPosY() {
        return this.field_187127_g;
    }

    public void setPosY(double posY) {
        this.field_187127_g = posY;
    }

    public double getPosZ() {
        return this.field_187128_h;
    }

    public void setPosZ(double posZ) {
        this.field_187128_h = posZ;
    }

    public double getMotionX() {
        return this.field_187129_i;
    }

    public void setMotionX(double motionX) {
        this.field_187129_i = motionX;
    }

    public double getMotionY() {
        return this.field_187130_j;
    }

    public void setMotionY(double motionY) {
        this.field_187130_j = motionY;
    }

    public double getMotionZ() {
        return this.field_187131_k;
    }

    public void setMotionZ(double motionZ) {
        this.field_187131_k = motionZ;
    }

    public double getPrevPosX() {
        return this.field_187123_c;
    }

    public void setPrevPosX(double prevPosX) {
        this.field_187123_c = prevPosX;
    }

    public double getPrevPosY() {
        return this.field_187124_d;
    }

    public void setPrevPosY(double prevPosY) {
        this.field_187124_d = prevPosY;
    }

    public double getPrevPosZ() {
        return this.field_187125_e;
    }

    public void setPrevPosZ(double prevPosZ) {
        this.field_187125_e = prevPosZ;
    }

    public int getEntityId() {
        return this.entityID;
    }

    public World getWorld() {
        return this.field_187122_b;
    }

    public void setCanCollide(boolean val) {
        this.field_190017_n = val;
    }

    public boolean getCanCollide() {
        return this.field_190017_n;
    }

    public boolean isCollided() {
        return this.field_187132_l;
    }

    public double getDistance(double x, double y, double z) {
        double d0 = this.field_187126_f - x;
        double d1 = this.field_187127_g - y;
        double d2 = this.field_187128_h - z;
        return MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
    }

    public void func_180434_a(BufferBuilder worldRendererIn, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        if (!this.facePlayer) {
            rotationX = MathHelper.func_76134_b((float)(this.rotationYaw * (float)Math.PI / 180.0f));
            rotationYZ = MathHelper.func_76126_a((float)(this.rotationYaw * (float)Math.PI / 180.0f));
            rotationXY = -rotationYZ * MathHelper.func_76126_a((float)(this.rotationPitch * (float)Math.PI / 180.0f));
            rotationXZ = rotationX * MathHelper.func_76126_a((float)(this.rotationPitch * (float)Math.PI / 180.0f));
            rotationZ = MathHelper.func_76134_b((float)(this.rotationPitch * (float)Math.PI / 180.0f));
        }
        super.func_180434_a(worldRendererIn, entityIn, partialTicks, rotationX, rotationZ, rotationYZ, rotationXY, rotationXZ);
    }

    public void renderParticleForShader(InstancedMeshParticle mesh, Transformation transformation, Matrix4fe viewMatrix, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        if (mesh.curBufferPos >= mesh.numInstances) {
            return;
        }
        float posX = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
        float posY = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
        float posZ = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
        Vector3f pos = new Vector3f(posX, posY, posZ);
        Matrix4fe modelMatrix = transformation.buildModelMatrix(this, pos, partialTicks);
        modelMatrix.get(21 * mesh.curBufferPos, mesh.instanceDataBuffer);
        float brightness = this.brightnessCache;
        mesh.instanceDataBuffer.put(21 * mesh.curBufferPos + 16, brightness);
        int rgbaIndex = 0;
        mesh.instanceDataBuffer.put(21 * mesh.curBufferPos + 16 + 1 + rgbaIndex++, this.func_70534_d());
        mesh.instanceDataBuffer.put(21 * mesh.curBufferPos + 16 + 1 + rgbaIndex++, this.func_70542_f());
        mesh.instanceDataBuffer.put(21 * mesh.curBufferPos + 16 + 1 + rgbaIndex++, this.func_70535_g());
        mesh.instanceDataBuffer.put(21 * mesh.curBufferPos + 16 + 1 + rgbaIndex++, this.getAlphaF());
        ++mesh.curBufferPos;
    }

    @Override
    public float getWindWeight() {
        return this.windWeight;
    }

    @Override
    public int getParticleDecayExtra() {
        return this.particleDecayExtra;
    }

    public boolean func_187111_c() {
        return this.isTransparent;
    }

    public void setKillOnCollide(boolean val) {
        this.killOnCollide = val;
    }

    public void func_187110_a(double x, double y, double z) {
        double yy = y;
        double xx = x;
        double zz = z;
        if (this.field_190017_n) {
            List list = this.field_187122_b.func_184144_a((Entity)null, this.func_187116_l().func_72321_a(x, y, z));
            for (AxisAlignedBB axisalignedbb : list) {
                y = axisalignedbb.func_72323_b(this.func_187116_l(), y);
            }
            this.func_187108_a(this.func_187116_l().func_72317_d(0.0, y, 0.0));
            for (AxisAlignedBB axisalignedbb1 : list) {
                x = axisalignedbb1.func_72316_a(this.func_187116_l(), x);
            }
            this.func_187108_a(this.func_187116_l().func_72317_d(x, 0.0, 0.0));
            for (AxisAlignedBB axisalignedbb2 : list) {
                z = axisalignedbb2.func_72322_c(this.func_187116_l(), z);
            }
            this.func_187108_a(this.func_187116_l().func_72317_d(0.0, 0.0, z));
        } else {
            this.func_187108_a(this.func_187116_l().func_72317_d(x, y, z));
        }
        this.func_187118_j();
        this.field_187132_l = yy != y || xx != x || zz != z;
        this.isCollidedHorizontally = xx != x || zz != z;
        this.isCollidedVerticallyDownwards = yy < y;
        boolean bl = this.isCollidedVerticallyUpwards = yy > y;
        if (xx != x) {
            this.field_187129_i = 0.0;
        }
        if (zz != z) {
            this.field_187131_k = 0.0;
        }
    }

    public void setFacePlayer(boolean val) {
        this.facePlayer = val;
    }

    public TextureAtlasSprite getParticleTexture() {
        return this.field_187119_C;
    }

    public boolean isVanillaMotionDampen() {
        return this.vanillaMotionDampen;
    }

    public void setVanillaMotionDampen(boolean motionDampen) {
        this.vanillaMotionDampen = motionDampen;
    }

    public int func_189214_a(float p_189214_1_) {
        return super.func_189214_a(p_189214_1_);
    }

    public void updateQuaternion(Entity camera) {
        if (camera != null) {
            if (this.facePlayer) {
                this.rotationYaw = camera.field_70177_z;
                this.rotationPitch = camera.field_70125_A;
            } else if (this.facePlayerYaw) {
                this.rotationYaw = camera.field_70177_z;
            }
        }
        Quaternion qY = new Quaternion();
        Quaternion qX = new Quaternion();
        qY.setFromAxisAngle(new Vector4f(0.0f, 1.0f, 0.0f, (float)Math.toRadians(-this.rotationYaw - 180.0f)));
        qX.setFromAxisAngle(new Vector4f(1.0f, 0.0f, 0.0f, (float)Math.toRadians(-this.rotationPitch)));
        if (this.rotateOrderXY) {
            Quaternion.mul((Quaternion)qX, (Quaternion)qY, (Quaternion)this.rotation);
        } else {
            Quaternion.mul((Quaternion)qY, (Quaternion)qX, (Quaternion)this.rotation);
        }
    }

    public void func_70538_b(float particleRedIn, float particleGreenIn, float particleBlueIn) {
        super.func_70538_b(particleRedIn, particleGreenIn, particleBlueIn);
        RotatingParticleManager.markDirtyVBO2();
    }

    public void func_82338_g(float alpha) {
        super.func_82338_g(alpha);
        RotatingParticleManager.markDirtyVBO2();
    }

    public int getKillWhenUnderTopmostBlock_ScanAheadRange() {
        return this.killWhenUnderTopmostBlock_ScanAheadRange;
    }

    public void setKillWhenUnderTopmostBlock_ScanAheadRange(int killWhenUnderTopmostBlock_ScanAheadRange) {
        this.killWhenUnderTopmostBlock_ScanAheadRange = killWhenUnderTopmostBlock_ScanAheadRange;
    }

    public boolean isCollidedVertically() {
        return this.isCollidedVerticallyDownwards || this.isCollidedVerticallyUpwards;
    }
}

