/*
 * Decompiled with CFR 0.152.
 */
package extendedrenderer.particle.behavior;

import CoroUtil.util.Vec3;
import extendedrenderer.particle.behavior.ParticleBehaviors;
import extendedrenderer.particle.entity.EntityRotFX;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class ParticleBehaviorFogGround
extends ParticleBehaviors {
    public int curTick = 0;
    public int ticksMax = 1;

    public ParticleBehaviorFogGround(Vec3 source) {
        super(source);
    }

    @Override
    public EntityRotFX initParticle(EntityRotFX particle) {
        super.initParticle(particle);
        particle.rotationYaw = this.rand.nextInt(360);
        particle.rotationPitch = this.rand.nextInt(50) - this.rand.nextInt(50);
        particle.func_187114_a(450 + this.rand.nextInt(10));
        float randFloat = this.rand.nextFloat() * 0.6f;
        float baseBright = 0.7f;
        float finalBright = Math.min(1.0f, baseBright + randFloat);
        particle.func_70538_b(finalBright, finalBright, finalBright);
        particle.brightness = 1.0f;
        particle.func_82338_g(1.0f);
        float sizeBase = (float)(30.0 + this.rand.nextDouble() * 4.0);
        particle.setScale(sizeBase);
        particle.setCanCollide(true);
        particle.renderRange = 2048.0f;
        particle.setFacePlayer(true);
        particle.setGravity(0.03f);
        return particle;
    }

    @Override
    public void tickUpdateAct(EntityRotFX particle) {
        if (!particle.func_187113_k()) {
            this.particles.remove(particle);
        } else {
            particle.rotationYaw = particle.getEntityId() % 2 == 0 ? (float)((double)particle.rotationYaw - 0.1) : (float)((double)particle.rotationYaw + 0.1);
            float ticksFadeInMax = 50.0f;
            float ticksFadeOutMax = 50.0f;
            if ((float)particle.getAge() < ticksFadeInMax) {
                particle.func_82338_g((float)particle.getAge() / ticksFadeInMax);
            } else if ((float)particle.getAge() > (float)particle.getMaxAge() - ticksFadeOutMax) {
                float count = (float)particle.getAge() - ((float)particle.getMaxAge() - ticksFadeOutMax);
                float val = (ticksFadeOutMax - count) / ticksFadeOutMax;
                particle.func_82338_g(val);
            }
            double moveSpeed = 0.001;
            BlockPos pos = new BlockPos(particle.getPosX(), particle.getPosY() - 0.5, particle.getPosZ());
            IBlockState state = particle.getWorld().func_180495_p(pos);
            if (!state.func_177230_c().isAir(state, (IBlockAccess)particle.field_187122_b, pos) && particle.field_187130_j < 0.09) {
                particle.field_187130_j += 0.02;
            }
            if (particle.isCollided()) {
                particle.rotationYaw = (float)((double)particle.rotationYaw + 0.1);
            }
            particle.setMotionX(particle.getMotionX() - Math.sin(Math.toRadians((particle.rotationYaw + (float)particle.getEntityId()) % 360.0f)) * moveSpeed);
            particle.setMotionZ(particle.getMotionZ() + Math.cos(Math.toRadians((particle.rotationYaw + (float)particle.getEntityId()) % 360.0f)) * moveSpeed);
            double moveSpeedRand = 0.005;
            particle.setMotionX(particle.getMotionX() + (this.rand.nextDouble() * moveSpeedRand - this.rand.nextDouble() * moveSpeedRand));
            particle.setMotionZ(particle.getMotionZ() + (this.rand.nextDouble() * moveSpeedRand - this.rand.nextDouble() * moveSpeedRand));
            particle.setScale(particle.getScale() - 0.1f);
            if (particle.spawnY != -1.0f) {
                particle.func_187109_b(particle.getPosX(), particle.spawnY, particle.getPosZ());
            }
        }
    }
}

