/*
 * Decompiled with CFR 0.152.
 */
package extendedrenderer.particle.behavior;

import CoroUtil.util.Vec3;
import extendedrenderer.particle.behavior.ParticleBehaviors;
import extendedrenderer.particle.entity.EntityRotFX;

public class ParticleBehaviorCharge
extends ParticleBehaviors {
    public int curTick = 0;
    public int ticksMax = 1;

    public ParticleBehaviorCharge(Vec3 source) {
        super(source);
    }

    @Override
    public EntityRotFX initParticle(EntityRotFX particle) {
        super.initParticle(particle);
        particle.rotationYaw = this.rand.nextInt(360);
        particle.func_187114_a(1 + this.rand.nextInt(10));
        particle.setGravity(0.0f);
        particle.func_70538_b(0.28235295f, 0.9372549f, 0.03137255f);
        particle.func_70538_b(0.6f + this.rand.nextFloat() * 0.4f, 0.2f + this.rand.nextFloat() * 0.7f, 0.0f);
        particle.setScale(0.25f + 0.2f * this.rand.nextFloat());
        particle.brightness = 1.0f;
        particle.setScale(0.1f + this.rand.nextFloat() * 0.5f);
        particle.spawnY = (float)particle.getPosY();
        particle.setCanCollide(false);
        return particle;
    }

    @Override
    public void tickUpdateAct(EntityRotFX particle) {
        if (this.curTick == 0 || !particle.func_187113_k()) {
            this.particles.remove(particle);
        } else {
            double centerX = this.coordSource.xCoord + 0.0;
            double centerY = this.coordSource.yCoord + 0.5;
            double centerZ = this.coordSource.zCoord + 0.0;
            double vecX = centerX - particle.getPosX();
            double vecZ = centerZ - particle.getPosZ();
            double rotYaw = (float)(Math.atan2(vecZ, vecX) * 180.0 / Math.PI);
            double speed = 0.01 + 0.5 * (double)this.curTick / (double)this.ticksMax;
            particle.setMotionX(Math.cos((rotYaw -= 75.0) * 0.017453) * speed);
            particle.setMotionZ(Math.sin(rotYaw * 0.017453) * speed);
            int cycle = 60;
            if (this.curTick + 20 < this.ticksMax) {
                if (particle.getAge() % cycle < cycle / 2) {
                    particle.setGravity(-0.02f);
                } else {
                    particle.setGravity(0.09f);
                }
            } else if (particle.getPosY() > this.coordSource.yCoord + 1.0) {
                particle.setGravity(0.15f);
            } else {
                particle.setGravity(-0.15f);
            }
        }
    }
}

