/*
 * Decompiled with CFR 0.152.
 */
package extendedrenderer.foliage;

import CoroUtil.util.CoroUtilBlockLightCache;
import extendedrenderer.shader.IShaderRenderedEntity;
import extendedrenderer.shader.InstancedMeshFoliage;
import extendedrenderer.shader.Matrix4fe;
import extendedrenderer.shader.Transformation;
import java.nio.FloatBuffer;
import java.util.Random;
import javax.vecmath.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import org.lwjgl.BufferUtils;
import org.lwjgl.util.vector.Quaternion;
import org.lwjgl.util.vector.Vector4f;

public class Foliage
implements IShaderRenderedEntity {
    public double posX;
    public double posY;
    public double posZ;
    public double prevPosX;
    public double prevPosY;
    public double prevPosZ;
    public float width = 1.0f;
    public float height = 1.0f;
    public float particleScale = 1.0f;
    public float particleRed = 1.0f;
    public float particleGreen = 1.0f;
    public float particleBlue = 1.0f;
    public float particleAlpha = 1.0f;
    public TextureAtlasSprite particleTexture;
    public float rotationYaw;
    public float rotationPitch;
    public Quaternion rotation = new Quaternion();
    public boolean rotateOrderXY = false;
    public float brightnessCache = 0.5f;
    public int animationID = 0;
    public int heightIndex = 0;
    public float looseness = 1.0f;
    private static final Random rand = new Random(439875L);
    private static final NoiseGeneratorPerlin angleNoise = new NoiseGeneratorPerlin(rand, 1);
    private static final NoiseGeneratorPerlin delayNoise = new NoiseGeneratorPerlin(rand, 3);

    public Foliage(TextureAtlasSprite sprite) {
        this.particleTexture = sprite;
    }

    public void setPosition(BlockPos pos) {
        this.posX = pos.func_177958_n();
        this.posY = pos.func_177956_o();
        this.posZ = pos.func_177952_p();
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
    }

    public BlockPos getBlockPosition() {
        return new BlockPos(this.posX, this.posY, this.posZ);
    }

    @Override
    public Vector3f getPosition() {
        return new Vector3f((float)this.posX, (float)this.posY, (float)this.posZ);
    }

    @Override
    public Quaternion getQuaternion() {
        return this.rotation;
    }

    @Override
    public Quaternion getQuaternionPrev() {
        return null;
    }

    @Override
    public float getScale() {
        return this.particleScale;
    }

    public void updateQuaternion(Entity camera) {
        Quaternion qY = new Quaternion();
        Quaternion qX = new Quaternion();
        qY.setFromAxisAngle(new Vector4f(0.0f, 1.0f, 0.0f, (float)Math.toRadians(-this.rotationYaw - 180.0f)));
        qX.setFromAxisAngle(new Vector4f(1.0f, 0.0f, 0.0f, (float)Math.toRadians(-this.rotationPitch)));
        if (this.rotateOrderXY) {
            Quaternion.mul((Quaternion)qX, (Quaternion)qY, (Quaternion)this.rotation);
        } else {
            Quaternion.mul((Quaternion)qY, (Quaternion)qX, (Quaternion)this.rotation);
        }
    }

    public void renderForShaderVBO1(InstancedMeshFoliage mesh, Transformation transformation, Matrix4fe viewMatrix, Entity entityIn, float partialTicks) {
        if (mesh.curBufferPosVBO1 >= mesh.numInstances) {
            return;
        }
        mesh.instanceDataBufferVBO1.put(2 * mesh.curBufferPosVBO1, this.particleAlpha);
        float brightness = CoroUtilBlockLightCache.getBrightnessCached((World)Minecraft.func_71410_x().field_71441_e, (float)this.posX, (float)this.posY, (float)this.posZ);
        mesh.instanceDataBufferVBO1.put(2 * mesh.curBufferPosVBO1 + 1, brightness);
        ++mesh.curBufferPosVBO1;
    }

    public void renderForShaderVBO2(InstancedMeshFoliage mesh, Transformation transformation, Matrix4fe viewMatrix, Entity entityIn, float partialTicks) {
        boolean autoGrowBuffer = false;
        if (mesh.curBufferPosVBO2 >= mesh.numInstances) {
            if (autoGrowBuffer) {
                mesh.numInstances *= 2;
                System.out.println("hit max mesh count, doubling in size to " + mesh.numInstances);
                FloatBuffer newBuffer = BufferUtils.createFloatBuffer((int)(mesh.numInstances * 24));
                mesh.instanceDataBufferVBO2.rewind();
                newBuffer.put(mesh.instanceDataBufferVBO2);
                mesh.instanceDataBufferVBO2.rewind();
                newBuffer.flip();
                mesh.instanceDataBufferVBO2 = newBuffer;
                mesh.instanceDataBufferVBO2.position(mesh.curBufferPosVBO2 * 24);
                newBuffer = BufferUtils.createFloatBuffer((int)(mesh.numInstances * 2));
                newBuffer.clear();
                mesh.instanceDataBufferVBO1 = newBuffer;
            } else {
                return;
            }
        }
        float posX = (float)(this.prevPosX + (this.posX - this.prevPosX) * (double)partialTicks - mesh.interpPosXThread);
        float posY = (float)(this.prevPosY + (this.posY - this.prevPosY) * (double)partialTicks - mesh.interpPosYThread);
        float posZ = (float)(this.prevPosZ + (this.posZ - this.prevPosZ) * (double)partialTicks - mesh.interpPosZThread);
        Vector3f pos = new Vector3f(posX, posY, posZ);
        Matrix4fe modelMatrix = transformation.buildModelMatrix(this, pos, partialTicks);
        modelMatrix.get(24 * mesh.curBufferPosVBO2, mesh.instanceDataBufferVBO2);
        int floatIndex = 0;
        mesh.instanceDataBufferVBO2.put(24 * mesh.curBufferPosVBO2 + 16 + floatIndex++, this.particleRed);
        mesh.instanceDataBufferVBO2.put(24 * mesh.curBufferPosVBO2 + 16 + floatIndex++, this.particleGreen);
        mesh.instanceDataBufferVBO2.put(24 * mesh.curBufferPosVBO2 + 16 + floatIndex++, this.particleBlue);
        mesh.instanceDataBufferVBO2.put(24 * mesh.curBufferPosVBO2 + 16 + floatIndex++, this.rotationYaw);
        mesh.instanceDataBufferVBO2.put(24 * mesh.curBufferPosVBO2 + 16 + floatIndex++, (float)delayNoise.func_151601_a(this.posX, this.posZ));
        mesh.instanceDataBufferVBO2.put(24 * mesh.curBufferPosVBO2 + 16 + floatIndex++, this.animationID);
        mesh.instanceDataBufferVBO2.put(24 * mesh.curBufferPosVBO2 + 16 + floatIndex++, this.heightIndex);
        mesh.instanceDataBufferVBO2.put(24 * mesh.curBufferPosVBO2 + 16 + floatIndex++, this.looseness);
        ++mesh.curBufferPosVBO2;
    }
}

