/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.util;

import CoroUtil.config.ConfigCoroUtilAdvanced;
import CoroUtil.forge.CommonProxy;
import CoroUtil.util.BlockCoord;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class UtilMining {
    public static GameProfile fakePlayerProfile = null;

    public static boolean canMineBlock(World world, BlockCoord pos, Block block) {
        return UtilMining.canMineBlock(world, pos.toBlockPos(), block);
    }

    public static boolean canMineBlock(World world, BlockPos pos, Block block) {
        IBlockState state = world.func_180495_p(pos);
        if (block.isAir(state, (IBlockAccess)world, pos) || block == CommonProxy.blockRepairingBlock) {
            return false;
        }
        if (world.func_175625_s(pos) != null) {
            return false;
        }
        return !state.func_185904_a().func_76224_d();
    }

    public static boolean canConvertToRepairingBlock(World world, IBlockState state) {
        if (state.func_185904_a() == Material.field_151592_s) {
            return true;
        }
        return state.func_185917_h();
    }

    public static boolean tryRemoveBlockWithFakePlayer(World world, BlockPos pos) {
        IBlockState stateRemove = world.func_180495_p(pos);
        if (UtilMining.canGrabEventCheck(world, stateRemove, pos)) {
            boolean forceRemoveIfNeeded = true;
            if (fakePlayerProfile == null) {
                fakePlayerProfile = new GameProfile(UUID.fromString("4365749c-bd72-497c-a0dd-73f28dafd8a1"), "coroutilMiningFakePlayer");
            }
            FakePlayer player = FakePlayerFactory.get((WorldServer)((WorldServer)world), (GameProfile)fakePlayerProfile);
            player.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            boolean actuallyRemoved = stateRemove.func_177230_c().removedByPlayer(stateRemove, world, pos, (EntityPlayer)player, true);
            boolean canHarvest = stateRemove.func_177230_c().canHarvestBlock((IBlockAccess)world, pos, (EntityPlayer)player);
            if (!actuallyRemoved && forceRemoveIfNeeded) {
                world.func_175698_g(pos);
                actuallyRemoved = true;
            }
            if (actuallyRemoved) {
                stateRemove.func_177230_c().func_176206_d(world, pos, stateRemove);
                if (canHarvest) {
                    ItemStack stack = new ItemStack(Items.field_151046_w);
                    stateRemove.func_177230_c().func_180657_a(world, (EntityPlayer)player, pos, stateRemove, world.func_175625_s(pos), stack);
                }
            }
        }
        return false;
    }

    public static boolean canGrabEventCheck(World world, IBlockState state, BlockPos pos) {
        if (!ConfigCoroUtilAdvanced.blockBreakingInvokesCancellableEvent) {
            return true;
        }
        if (world instanceof WorldServer) {
            if (fakePlayerProfile == null) {
                fakePlayerProfile = new GameProfile(UUID.fromString("4365749c-bd72-497c-a0dd-73f28dafd8a1"), "coroutilMiningFakePlayer");
            }
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, (EntityPlayer)FakePlayerFactory.get((WorldServer)((WorldServer)world), (GameProfile)fakePlayerProfile));
            MinecraftForge.EVENT_BUS.post((Event)event);
            return !event.isCanceled();
        }
        return false;
    }
}

