/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.util;

import org.lwjgl.util.vector.Quaternion;

public class CoroUtilMath {
    static final double EPS = 1.0E-6;

    public static Quaternion rotation(Quaternion q, float angleX, float angleY, float angleZ) {
        double s;
        double thetaX = (double)angleX * 0.5;
        double thetaY = (double)angleY * 0.5;
        double thetaZ = (double)angleZ * 0.5;
        double thetaMagSq = thetaX * thetaX + thetaY * thetaY + thetaZ * thetaZ;
        if (thetaMagSq * thetaMagSq / 24.0 < (double)1.0E-8f) {
            q.w = (float)(1.0 - thetaMagSq / 2.0);
            s = 1.0 - thetaMagSq / 6.0;
        } else {
            double thetaMag = Math.sqrt(thetaMagSq);
            double sin = Math.sin(thetaMag);
            s = sin / thetaMag;
            q.w = (float)CoroUtilMath.cosFromSin(sin, thetaMag);
        }
        q.x = (float)(thetaX * s);
        q.y = (float)(thetaY * s);
        q.z = (float)(thetaZ * s);
        return q;
    }

    public static double cosFromSin(double sin, double angle) {
        return Math.sin(angle + 1.5707963267948966);
    }

    public static Quaternion interpolate(Quaternion q1, Quaternion q2, float alpha) {
        double s2;
        double s1;
        double dot = q2.x * q1.x + q2.y * q1.y + q2.z * q1.z + q2.w * q1.w;
        if (dot < 0.0) {
            q1.x = -q1.x;
            q1.y = -q1.y;
            q1.z = -q1.z;
            q1.w = -q1.w;
            dot = -dot;
        }
        if (1.0 - dot > 1.0E-6) {
            double om = Math.acos(dot);
            double sinom = Math.sin(om);
            s1 = Math.sin((1.0 - (double)alpha) * om) / sinom;
            s2 = Math.sin((double)alpha * om) / sinom;
        } else {
            s1 = 1.0 - (double)alpha;
            s2 = alpha;
        }
        return new Quaternion((float)(s1 * (double)q1.x + s2 * (double)q2.x), (float)(s1 * (double)q1.y + s2 * (double)q2.y), (float)(s1 * (double)q1.z + s2 * (double)q2.z), (float)(s1 * (double)q1.w + s2 * (double)q2.w));
    }
}

