/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.util;

import CoroUtil.config.ConfigCoroUtilAdvanced;
import CoroUtil.difficulty.UtilEntityBuffs;
import CoroUtil.util.BlockCoord;
import CoroUtil.util.CoroUtilBlock;
import CoroUtil.util.Vec3;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class CoroUtilEntity {
    public static boolean canCoordBeSeen(EntityLivingBase ent, int x, int y, int z) {
        return ent.field_70170_p.func_72933_a(new Vec3d(ent.field_70165_t, ent.field_70163_u + (double)ent.func_70047_e(), ent.field_70161_v), new Vec3d((double)x, (double)y, (double)z)) == null;
    }

    public static boolean canCoordBeSeenFromFeet(EntityLivingBase ent, int x, int y, int z) {
        return ent.field_70170_p.func_72933_a(new Vec3d(ent.field_70165_t, ent.func_174813_aQ().field_72338_b + 0.15, ent.field_70161_v), new Vec3d((double)x, (double)y, (double)z)) == null;
    }

    public static double getDistance(Entity ent, BlockCoord coords) {
        double d3 = ent.field_70165_t - (double)coords.posX;
        double d4 = ent.field_70163_u - (double)coords.posY;
        double d5 = ent.field_70161_v - (double)coords.posZ;
        return MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
    }

    public static double getDistance(Entity ent, TileEntity tEnt) {
        double d3 = ent.field_70165_t - (double)tEnt.func_174877_v().func_177958_n();
        double d4 = ent.field_70163_u - (double)tEnt.func_174877_v().func_177956_o();
        double d5 = ent.field_70161_v - (double)tEnt.func_174877_v().func_177952_p();
        return MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
    }

    public static Vec3 getTargetVector(EntityLivingBase parEnt, EntityLivingBase target) {
        double vecX = target.field_70165_t - parEnt.field_70165_t;
        double vecY = target.field_70163_u - parEnt.field_70163_u;
        double vecZ = target.field_70161_v - parEnt.field_70161_v;
        double dist = Math.sqrt(vecX * vecX + vecY * vecY + vecZ * vecZ);
        Vec3 vec3 = new Vec3(vecX / dist, vecY / dist, vecZ / dist);
        return vec3;
    }

    public static void moveTowards(Entity ent, Entity targ, float speed) {
        double vecX = targ.field_70165_t - ent.field_70165_t;
        double vecY = targ.field_70163_u - ent.field_70163_u;
        double vecZ = targ.field_70161_v - ent.field_70161_v;
        double dist2 = Math.sqrt(vecX * vecX + vecY * vecY + vecZ * vecZ);
        ent.field_70159_w += vecX / dist2 * (double)speed;
        ent.field_70181_x += vecY / dist2 * (double)speed;
        ent.field_70179_y += vecZ / dist2 * (double)speed;
    }

    public static String getName(Entity ent) {
        return ent != null ? ent.func_70005_c_() : "nullObject";
    }

    public static EntityPlayer getPlayerByUUID(UUID uuid) {
        for (EntityPlayerMP entityplayermp : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
            if (!entityplayermp.func_146103_bH().getId().equals(uuid)) continue;
            return entityplayermp;
        }
        return null;
    }

    public static EntityPlayer getClosestVulnerablePlayerToEntity(World world, Entity p_72856_1_, double p_72856_2_) {
        return CoroUtilEntity.getClosestVulnerablePlayer(world, p_72856_1_.field_70165_t, p_72856_1_.field_70163_u, p_72856_1_.field_70161_v, p_72856_2_);
    }

    public static EntityPlayer getClosestVulnerablePlayer(World world, double p_72846_1_, double p_72846_3_, double p_72846_5_, double p_72846_7_) {
        double d4 = -1.0;
        EntityPlayer entityplayer = null;
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            EntityPlayer entityplayer1 = (EntityPlayer)world.field_73010_i.get(i);
            if (entityplayer1.field_71075_bZ.field_75102_a || !entityplayer1.func_70089_S()) continue;
            double d5 = entityplayer1.func_70092_e(p_72846_1_, p_72846_3_, p_72846_5_);
            double d6 = p_72846_7_;
            if (entityplayer1.func_70093_af()) {
                d6 = p_72846_7_ * (double)0.8f;
            }
            if (entityplayer1.func_82150_aj()) {
                float f = entityplayer1.func_82243_bO();
                if (f < 0.1f) {
                    f = 0.1f;
                }
                d6 *= (double)(0.7f * f);
            }
            if (!(p_72846_7_ < 0.0) && !(d5 < d6 * d6) || d4 != -1.0 && !(d5 < d4)) continue;
            d4 = d5;
            entityplayer = entityplayer1;
        }
        return entityplayer;
    }

    public static boolean canProcessForList(String playerName, String list, boolean whitelistMode) {
        return !(whitelistMode ? !list.contains(playerName) : list.contains(playerName));
    }

    public static Class getClassFromRegistry(String name) {
        Class clazz = EntityList.getClass((ResourceLocation)new ResourceLocation(name));
        return clazz;
    }

    public static boolean canSpawnMobOnGround(World world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        return !CoroUtilBlock.isAir(block) && block.canCreatureSpawn(state, (IBlockAccess)world, pos, EntityLiving.SpawnPlacementType.ON_GROUND);
    }

    public static boolean isInDarkCave(World world, int x, int y, int z, boolean checkSpaceToSpawn, boolean skipLightCheck) {
        BlockPos pos = new BlockPos(x, y, z);
        BlockPos posAir = new BlockPos(x, y + 1, z);
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!(world.func_175678_i(posAir) || !skipLightCheck && world.func_175671_l(posAir) >= 5 || CoroUtilBlock.isAir(block) || state.func_185904_a() != Material.field_151576_e)) {
            if (!checkSpaceToSpawn) {
                return true;
            }
            if (world.func_175623_d(posAir) && world.func_175623_d(pos.func_177981_b(2))) {
                return true;
            }
        }
        return false;
    }

    public static boolean attackEntityAsMobForPassives(EntityLivingBase source, Entity entityIn) {
        boolean flag;
        float f = source.func_110148_a(SharedMonsterAttributes.field_111264_e) != null ? (float)source.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() : 3.0f;
        int i = 0;
        if (entityIn instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)source.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)source);
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)source), f)) {
            int j;
            if (i > 0 && entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)source, (float)i * 0.5f, (double)MathHelper.func_76126_a((float)(source.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(source.field_70177_z * ((float)Math.PI / 180)))));
                source.field_70159_w *= 0.6;
                source.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)source)) > 0) {
                entityIn.func_70015_d(j * 4);
            }
            if (entityIn instanceof EntityPlayer) {
                ItemStack itemstack1;
                EntityPlayer entityplayer = (EntityPlayer)entityIn;
                ItemStack itemstack = source.func_184614_ca();
                ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : ItemStack.field_190927_a;
                if (!itemstack.func_190926_b() && !itemstack1.func_190926_b() && itemstack.func_77973_b().canDisableShield(itemstack, itemstack1, (EntityLivingBase)entityplayer, source) && itemstack1.func_77973_b().isShield(itemstack1, (EntityLivingBase)entityplayer)) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)source) * 0.05f;
                    if (source.field_70170_p.field_73012_v.nextFloat() < f1) {
                        entityplayer.func_184811_cZ().func_185145_a(itemstack1.func_77973_b(), 100);
                        source.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                    }
                }
            }
        }
        return flag;
    }

    public static boolean canPathfindLongDist(EntityCreature ent) {
        long lastPathTime = ent.getEntityData().func_74763_f(UtilEntityBuffs.dataEntityBuffed_LastTimePathfindLongDist);
        return ent.field_70170_p.func_82737_E() > lastPathTime + (long)ConfigCoroUtilAdvanced.worldTimeDelayBetweenLongDistancePathfindTries;
    }

    public static void updateLastTimeLongDistPathfinded(EntityCreature ent) {
        ent.getEntityData().func_74772_a(UtilEntityBuffs.dataEntityBuffed_LastTimePathfindLongDist, ent.field_70170_p.func_82737_E() + (long)(ent.func_145782_y() % 20));
    }
}

