/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.util;

import CoroUtil.config.ConfigCoroUtilAdvanced;
import CoroUtil.difficulty.UtilEntityBuffs;
import CoroUtil.forge.CULog;
import CoroUtil.util.CoroUtilCompatibility;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;

public class CoroUtilCrossMod {
    private static boolean checkHasInfernalMobs = true;
    private static boolean hasInfernalMobs = false;
    public static List<String> listModifiers = new ArrayList<String>();

    public static boolean hasInfernalMobs() {
        if (!checkHasInfernalMobs) {
            return hasInfernalMobs;
        }
        checkHasInfernalMobs = false;
        try {
            Class<?> clazz = Class.forName("atomicstryker.infernalmobs.common.InfernalMobsCore");
            if (clazz != null) {
                hasInfernalMobs = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        CULog.log("CoroUtil detected Infernal Mobs " + (hasInfernalMobs ? "Installed" : "Not Installed") + " for use");
        return hasInfernalMobs;
    }

    public static boolean infernalMobs_AddRandomModifiers(EntityLivingBase ent, List<String> listModifiersToUse, int modifierCount) {
        int i;
        String listMods = "";
        CULog.dbg("infernalMobs_AddRandomModifiers perform:");
        if (modifierCount >= listModifiersToUse.size()) {
            modifierCount = listModifiersToUse.size() - 1;
        }
        CULog.dbg("modifierCount: " + modifierCount);
        CULog.dbg("listModifiersToUse size: " + listModifiersToUse.size());
        ArrayList<Integer> listInts = new ArrayList<Integer>();
        for (i = 0; i < listModifiersToUse.size(); ++i) {
            listInts.add(i);
        }
        Collections.shuffle(listInts);
        for (i = 0; i < modifierCount; ++i) {
            listMods = listMods + listModifiersToUse.get((Integer)listInts.get(i)) + " ";
        }
        CULog.dbg("listMods final: " + listMods);
        if (!listMods.equals("")) {
            return CoroUtilCrossMod.infernalMobs_AddModifiers(ent, listMods);
        }
        return true;
    }

    public static boolean infernalMobs_AddModifiers(EntityLivingBase ent, String modifiers) {
        if (!CoroUtilCrossMod.hasInfernalMobs()) {
            return false;
        }
        try {
            Class<?> clazz = Class.forName("atomicstryker.infernalmobs.common.InfernalMobsCore");
            if (clazz != null) {
                Method method = clazz.getDeclaredMethod("instance", new Class[0]);
                Object obj = method.invoke(null, new Object[0]);
                Method methodMods = obj.getClass().getDeclaredMethod("addEntityModifiersByString", EntityLivingBase.class, String.class);
                methodMods.invoke(obj, ent, modifiers);
                return true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public static boolean infernalMobs_RemoveAllModifiers(EntityLivingBase ent) {
        if (!CoroUtilCrossMod.hasInfernalMobs()) {
            return false;
        }
        try {
            Class<?> clazz = Class.forName("atomicstryker.infernalmobs.common.InfernalMobsCore");
            if (clazz != null) {
                Method method = clazz.getDeclaredMethod("removeEntFromElites", EntityLivingBase.class);
                method.invoke(null, ent);
                return true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public static void processSpawnOverride(EntityJoinWorldEvent event) {
        EntityLivingBase ent;
        if (!CoroUtilCrossMod.hasInfernalMobs()) {
            return;
        }
        if (!ConfigCoroUtilAdvanced.difficulty_OverrideInfernalMobs) {
            return;
        }
        if (!CoroUtilCompatibility.isHWMonstersInstalled()) {
            return;
        }
        String infernalNBTString = "InfernalMobsMod";
        if (event.getEntity() instanceof EntityLivingBase && (ent = (EntityLivingBase)event.getEntity()).getEntityData().func_74764_b(infernalNBTString) && !ent.getEntityData().func_74775_l(UtilEntityBuffs.dataEntityBuffed_Data).func_74767_n(UtilEntityBuffs.dataEntityBuffed_AI_Infernal)) {
            CULog.dbg("detected infernal mob, overriding its attributes for " + event.getEntity().func_70005_c_());
            CoroUtilCrossMod.infernalMobs_RemoveAllModifiers(ent);
            ent.getEntityData().func_82580_o(infernalNBTString);
        }
    }

    static {
        listModifiers.add("1UP");
        listModifiers.add("Alchemist");
        listModifiers.add("Berserk");
        listModifiers.add("Blastoff");
        listModifiers.add("Bulwark");
        listModifiers.add("Choke");
        listModifiers.add("Cloaking");
        listModifiers.add("Darkness");
        listModifiers.add("Ender");
        listModifiers.add("Exhaust");
        listModifiers.add("Fiery");
        listModifiers.add("Ghastly");
        listModifiers.add("Gravity");
        listModifiers.add("LifeSteal");
        listModifiers.add("Ninja");
        listModifiers.add("Poisonous");
        listModifiers.add("Quicksand");
        listModifiers.add("Regen");
        listModifiers.add("Rust");
        listModifiers.add("Sapper");
        listModifiers.add("Sprint");
        listModifiers.add("Sticky");
        listModifiers.add("Storm");
        listModifiers.add("Vengeance");
        listModifiers.add("Weakness");
        listModifiers.add("Webber");
        listModifiers.add("Wither");
    }
}

