/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.util;

import java.awt.Color;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

public class CoroUtilBlockLightCache {
    public static HashMap<Long, Float> lookupPosToBrightness = new HashMap();
    public static HashMap<Integer, HashMap<Integer, HashMap<Integer, Float>>> lookupPosToBrightness2 = new HashMap();
    private static final int NUM_X_BITS;
    private static final int NUM_Z_BITS;
    private static final int NUM_Y_BITS;
    private static final int Y_SHIFT;
    private static final int X_SHIFT;
    private static final long X_MASK;
    private static final long Y_MASK;
    private static final long Z_MASK;
    public static float brightnessPlayer;
    public static Color[] lightmapColors;

    public static float getBrightnessCached(World world, float x, float y, float z) {
        boolean crazy = false;
        int xx = MathHelper.func_76141_d((float)x);
        int yy = MathHelper.func_76141_d((float)y);
        int zz = MathHelper.func_76141_d((float)z);
        if (crazy) {
            Float brightness;
            HashMap<Integer, HashMap<Integer, Float>> xxx = lookupPosToBrightness2.get(xx);
            HashMap<Integer, Float> yyy = null;
            if (xxx != null && (yyy = xxx.get(yy)) != null && (brightness = yyy.get(zz)) != null) {
                return brightness.floatValue();
            }
            float brightnesss = CoroUtilBlockLightCache.getBrightnessNonLightmap(world, x, y, z);
            if (xxx == null) {
                xxx = new HashMap();
            }
            if (yyy == null) {
                yyy = new HashMap();
            }
            yyy.put(zz, Float.valueOf(brightnesss));
            xxx.put(yy, yyy);
            lookupPosToBrightness2.put(xx, xxx);
            return brightnesss;
        }
        long hash = ((long)xx & X_MASK) << X_SHIFT | ((long)yy & Y_MASK) << Y_SHIFT | ((long)zz & Z_MASK) << 0;
        boolean containsWay = false;
        if (containsWay) {
            if (lookupPosToBrightness.containsKey(hash)) {
                return lookupPosToBrightness.get(hash).floatValue();
            }
            float brightnesss = CoroUtilBlockLightCache.getBrightnessNonLightmap(world, x, y, z);
            lookupPosToBrightness.put(hash, Float.valueOf(brightnesss + 0.001f));
            return brightnesss;
        }
        Float brightness = lookupPosToBrightness.get(hash);
        if (brightness != null) {
            return brightness.floatValue();
        }
        float brightnesss = CoroUtilBlockLightCache.getBrightnessFromLightmap(world, x, y, z);
        lookupPosToBrightness.put(hash, Float.valueOf(brightnesss));
        return brightnesss;
    }

    public static void clear() {
        lookupPosToBrightness.clear();
        lookupPosToBrightness2.clear();
    }

    public static float getBrightnessNonLightmap(World world, float x, float y, float z) {
        float brightnessSky = world.func_72971_b(1.0f);
        float brightnessBlock = (float)world.func_175705_a(EnumSkyBlock.BLOCK, new BlockPos((double)x, (double)y, (double)z)) / 15.0f;
        float brightness = brightnessSky;
        if (brightnessBlock > brightnessSky) {
            brightness = brightnessBlock;
        }
        return brightness;
    }

    public static float getBrightnessFromLightmap(World world, float x, float y, float z) {
        BlockPos pos = new BlockPos((double)x, (double)y, (double)z);
        int i = world.func_175705_a(EnumSkyBlock.SKY, pos);
        int j = world.func_175705_a(EnumSkyBlock.BLOCK, pos);
        int[] texData = Minecraft.func_71410_x().field_71460_t.field_78513_d.func_110565_c();
        int color = texData[i * 16 + j];
        return color;
    }

    static {
        NUM_Z_BITS = NUM_X_BITS = 1 + MathHelper.func_151239_c((int)MathHelper.func_151236_b((int)30000000));
        NUM_Y_BITS = 64 - NUM_X_BITS - NUM_Z_BITS;
        Y_SHIFT = 0 + NUM_Z_BITS;
        X_SHIFT = Y_SHIFT + NUM_Y_BITS;
        X_MASK = (1L << NUM_X_BITS) - 1L;
        Y_MASK = (1L << NUM_Y_BITS) - 1L;
        Z_MASK = (1L << NUM_Z_BITS) - 1L;
        brightnessPlayer = 0.0f;
        lightmapColors = new Color[255];
    }
}

