/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.forge;

import CoroUtil.difficulty.DynamicDifficulty;
import CoroUtil.forge.CULog;
import CoroUtil.forge.CoroAIWorldAccess;
import CoroUtil.forge.CoroUtil;
import CoroUtil.quest.PlayerQuestManager;
import CoroUtil.quest.PlayerQuests;
import CoroUtil.test.SoundTest;
import CoroUtil.world.WorldDirectorManager;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EventHandlerFML {
    @SideOnly(value=Side.CLIENT)
    public static SoundTest soundTest;
    public static long timeLast;

    @SubscribeEvent
    public void tickWorld(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            CoroUtil.initTry();
        }
    }

    @SubscribeEvent
    public void worldLoad(WorldEvent.Load event) {
        int dimID = event.getWorld().field_73011_w.getDimension();
        CULog.dbg("adding CoroUtil world listener for dimID: " + dimID + ", remote?: " + event.getWorld().field_72995_K);
        event.getWorld().func_72954_a((IWorldEventListener)new CoroAIWorldAccess());
    }

    @SubscribeEvent
    public void tickServer(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            boolean testSendRequestIMC;
            WorldServer[] worlds = DimensionManager.getWorlds();
            for (int i = 0; i < worlds.length; ++i) {
                PlayerQuestManager.i().tick((World)worlds[i]);
            }
            WorldDirectorManager.instance().onTick();
            boolean debugIMC = false;
            if (debugIMC) {
                try {
                    ImmutableList listMsgs = new ArrayList();
                    listMsgs = FMLInterModComms.fetchRuntimeMessages((Object)"CoroAI");
                    for (int i = 0; i < listMsgs.size(); ++i) {
                        System.out.println("CoroAI side: " + ((FMLInterModComms.IMCMessage)listMsgs.get((int)i)).key + " - modID: " + ((FMLInterModComms.IMCMessage)listMsgs.get(i)).getSender() + " - source: " + ((FMLInterModComms.IMCMessage)listMsgs.get(i)).toString() + " - " + ((FMLInterModComms.IMCMessage)listMsgs.get(i)).getNBTValue());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (testSendRequestIMC = false) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74768_a("x", 1);
                nbt.func_74768_a("y", 2);
                nbt.func_74768_a("z", 3);
                nbt.func_74778_a("replymod", "CoroAI");
                FMLInterModComms.sendRuntimeMessage((Object)"weather2", (String)"weather2", (String)"weather.raining", (NBTTagCompound)nbt);
            }
            DynamicDifficulty.tickServer(event);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void tickRender(TickEvent.RenderTickEvent event) {
        if (FMLClientHandler.instance().getClient().field_71441_e == null || FMLClientHandler.instance().getClient().field_71439_g == null || event.phase == TickEvent.Phase.END) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerQuests quests = PlayerQuestManager.i().getPlayerQuests(event.player);
        quests.sync();
    }

    static {
        timeLast = 0L;
    }
}

