/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.difficulty.data.spawns;

import CoroUtil.difficulty.data.DataCmod;
import CoroUtil.difficulty.data.DeserializerAllJson;
import CoroUtil.difficulty.data.DifficultyDataReader;
import CoroUtil.util.CoroUtilEntity;
import CoroUtil.util.EnumSpawnPlacementType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.text.TextFormatting;

public class DataActionMobSpawns {
    public int count;
    public int count_max = -1;
    public double count_difficulty_multiplier = 0.0;
    public EnumSpawnPlacementType spawnType = EnumSpawnPlacementType.GROUND;
    public List<String> entities = new ArrayList<String>();
    public List<DataCmod> cmods = new ArrayList<DataCmod>();

    public DataActionMobSpawns copy() {
        DataActionMobSpawns copy = new DataActionMobSpawns();
        copy.count = this.count;
        copy.count_max = this.count_max;
        copy.count_difficulty_multiplier = this.count_difficulty_multiplier;
        copy.spawnType = this.spawnType;
        copy.entities.addAll(this.entities);
        for (DataCmod cmod : this.cmods) {
            copy.cmods.add(cmod);
        }
        return copy;
    }

    public int getMaxMobCountDynamic(double difficulty) {
        int count = this.count;
        count = (int)((double)count + (double)count * (difficulty * this.count_difficulty_multiplier));
        if (this.count_max != -1 && count > this.count_max) {
            count = this.count_max;
        }
        return count;
    }

    public String toString() {
        String str = TextFormatting.GOLD + "Entities: " + TextFormatting.RESET;
        for (String entity : this.entities) {
            String code = "";
            if (DifficultyDataReader.debugValidate()) {
                code = TextFormatting.GREEN.toString();
                if (CoroUtilEntity.getClassFromRegistry(entity) == null) {
                    code = TextFormatting.RED.toString() + "MISSING! ";
                }
            }
            str = str + code + entity + ", ";
        }
        str = str + "a count of " + this.count + " * difficulty * multiplier of " + this.count_difficulty_multiplier + " maxing at " + this.count_max;
        if (DifficultyDataReader.getDebugDifficulty() != -1.0) {
            str = str + ", test calculated to count of " + this.getMaxMobCountDynamic(DifficultyDataReader.getDebugDifficulty());
        }
        str = str + " | " + TextFormatting.GOLD + "With cmods: " + TextFormatting.RESET;
        List<DataCmod> cmodsToUse = this.cmods;
        if (DifficultyDataReader.debugFlattenCmodsAndConditions()) {
            cmodsToUse = DeserializerAllJson.getCmodsFlattened(this.cmods);
        }
        for (DataCmod cmod : cmodsToUse) {
            str = str + cmod.toString() + ", ";
        }
        str = str + " | ";
        return str;
    }
}

