/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.difficulty.data;

import CoroUtil.ai.tasks.EntityAIAttackMeleePassiveMobs;
import CoroUtil.ai.tasks.EntityAIHoist;
import CoroUtil.ai.tasks.EntityAITaskAntiAir;
import CoroUtil.ai.tasks.EntityAITaskEnhancedCombat;
import CoroUtil.ai.tasks.TaskDigTowardsTarget;
import CoroUtil.ai.tasks.TaskExplodeTowardsTarget;
import CoroUtil.difficulty.UtilEntityBuffs;
import CoroUtil.difficulty.buffs.BuffAI_Infernal;
import CoroUtil.difficulty.buffs.BuffAI_TaskBase;
import CoroUtil.difficulty.buffs.BuffAI_TaskMining;
import CoroUtil.difficulty.buffs.BuffAI_TaskOmniscience;
import CoroUtil.difficulty.buffs.BuffAttackDamage;
import CoroUtil.difficulty.buffs.BuffHealth;
import CoroUtil.difficulty.buffs.BuffInventory;
import CoroUtil.difficulty.buffs.BuffInventoryDifficultyScaled;
import CoroUtil.difficulty.buffs.BuffMobDrops;
import CoroUtil.difficulty.buffs.BuffSpeed;
import CoroUtil.difficulty.buffs.BuffXP;
import CoroUtil.difficulty.data.DeserializerAllJson;
import CoroUtil.difficulty.data.DifficultyData;
import CoroUtil.difficulty.data.cmods.CmodAIInfernal;
import CoroUtil.difficulty.data.cmods.CmodAITaskBase;
import CoroUtil.difficulty.data.cmods.CmodAttributeAttackDamage;
import CoroUtil.difficulty.data.cmods.CmodAttributeHealth;
import CoroUtil.difficulty.data.cmods.CmodAttributeSpeed;
import CoroUtil.difficulty.data.cmods.CmodInventory;
import CoroUtil.difficulty.data.cmods.CmodInventoryDifficultyScaled;
import CoroUtil.difficulty.data.cmods.CmodMobDrops;
import CoroUtil.difficulty.data.cmods.CmodTemplateReference;
import CoroUtil.difficulty.data.cmods.CmodXP;
import CoroUtil.difficulty.data.conditions.ConditionContext;
import CoroUtil.difficulty.data.conditions.ConditionDifficulty;
import CoroUtil.difficulty.data.conditions.ConditionFilterMobs;
import CoroUtil.difficulty.data.conditions.ConditionInvasionNumber;
import CoroUtil.difficulty.data.conditions.ConditionInvasionRate;
import CoroUtil.difficulty.data.conditions.ConditionModLoaded;
import CoroUtil.difficulty.data.conditions.ConditionRandom;
import CoroUtil.difficulty.data.conditions.ConditionTemplateReference;
import CoroUtil.forge.CULog;
import CoroUtil.forge.CoroUtil;
import CoroUtil.util.CoroUtilCompatibility;
import CoroUtil.util.UtilClasspath;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.ai.EntityAIZombieAttack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class DifficultyDataReader {
    private static final Gson GSONBuffInventory = new GsonBuilder().registerTypeAdapter(DifficultyData.class, (Object)new DeserializerAllJson()).create();
    private static DifficultyData data;
    public static String lootTablesFolder;
    public static HashMap<String, Class> lookupJsonNameToCmodDeserializer;
    public static HashMap<String, Class> lookupJsonNameToConditionDeserializer;
    private static boolean debugValidate;
    private static boolean debugFlattenCmodsAndConditions;
    private static double debugDifficulty;
    public static String pathData;
    public static File dataFolder;
    public static File dataHashes;

    public static boolean debugValidate() {
        return debugValidate;
    }

    public static void setDebugValidate(boolean debugValidate) {
        DifficultyDataReader.debugValidate = debugValidate;
    }

    public static boolean debugFlattenCmodsAndConditions() {
        return debugFlattenCmodsAndConditions;
    }

    public static void setDebugFlattenCmodsAndConditions(boolean debugFlattenCmodsAndConditions) {
        DifficultyDataReader.debugFlattenCmodsAndConditions = debugFlattenCmodsAndConditions;
    }

    public static double getDebugDifficulty() {
        return debugDifficulty;
    }

    public static void setDebugDifficulty(double debugDifficulty) {
        DifficultyDataReader.debugDifficulty = debugDifficulty;
    }

    public static void init() {
        data = new DifficultyData();
        lookupJsonNameToCmodDeserializer.clear();
        lookupJsonNameToCmodDeserializer.put(UtilEntityBuffs.dataEntityBuffed_Inventory, CmodInventory.class);
        lookupJsonNameToCmodDeserializer.put(UtilEntityBuffs.dataEntityBuffed_InventoryDifficultyScaled, CmodInventoryDifficultyScaled.class);
        lookupJsonNameToCmodDeserializer.put(UtilEntityBuffs.dataEntityBuffed_MobDrops, CmodMobDrops.class);
        lookupJsonNameToCmodDeserializer.put(UtilEntityBuffs.dataEntityBuffed_Health, CmodAttributeHealth.class);
        lookupJsonNameToCmodDeserializer.put(UtilEntityBuffs.dataEntityBuffed_AttackDamage, CmodAttributeAttackDamage.class);
        lookupJsonNameToCmodDeserializer.put(UtilEntityBuffs.dataEntityBuffed_Speed, CmodAttributeSpeed.class);
        lookupJsonNameToCmodDeserializer.put(UtilEntityBuffs.dataEntityBuffed_Speed_Flying, CmodAttributeSpeed.class);
        lookupJsonNameToCmodDeserializer.put(UtilEntityBuffs.dataEntityBuffed_XP, CmodXP.class);
        lookupJsonNameToCmodDeserializer.put(UtilEntityBuffs.dataEntityBuffed_AI_AntiAir, CmodAITaskBase.class);
        lookupJsonNameToCmodDeserializer.put(UtilEntityBuffs.dataEntityBuffed_AI_Digging, CmodAITaskBase.class);
        lookupJsonNameToCmodDeserializer.put(UtilEntityBuffs.dataEntityBuffed_AI_ExplodeOnStuck, CmodAITaskBase.class);
        lookupJsonNameToCmodDeserializer.put(UtilEntityBuffs.dataEntityBuffed_AI_Omniscience, CmodAITaskBase.class);
        lookupJsonNameToCmodDeserializer.put(UtilEntityBuffs.dataEntityBuffed_AI_CounterLeap, CmodAITaskBase.class);
        lookupJsonNameToCmodDeserializer.put(UtilEntityBuffs.dataEntityBuffed_AI_Hoist, CmodAITaskBase.class);
        lookupJsonNameToCmodDeserializer.put(UtilEntityBuffs.dataEntityBuffed_AI_Lunge, CmodAITaskBase.class);
        lookupJsonNameToCmodDeserializer.put(UtilEntityBuffs.dataEntityBuffed_AI_Attack_Melee, CmodAITaskBase.class);
        lookupJsonNameToCmodDeserializer.put(UtilEntityBuffs.dataEntityBuffed_AI_Infernal, CmodAIInfernal.class);
        lookupJsonNameToCmodDeserializer.put("template", CmodTemplateReference.class);
        lookupJsonNameToConditionDeserializer.clear();
        lookupJsonNameToConditionDeserializer.put("context", ConditionContext.class);
        lookupJsonNameToConditionDeserializer.put("difficulty", ConditionDifficulty.class);
        lookupJsonNameToConditionDeserializer.put("invasion_number", ConditionInvasionNumber.class);
        lookupJsonNameToConditionDeserializer.put("invasion_rate", ConditionInvasionRate.class);
        lookupJsonNameToConditionDeserializer.put("random", ConditionRandom.class);
        lookupJsonNameToConditionDeserializer.put("filter_mobs", ConditionFilterMobs.class);
        lookupJsonNameToConditionDeserializer.put("template", ConditionTemplateReference.class);
        lookupJsonNameToConditionDeserializer.put("mod_loaded", ConditionModLoaded.class);
        UtilEntityBuffs.registerBuff(new BuffHealth());
        UtilEntityBuffs.registerBuff(new BuffSpeed(false));
        UtilEntityBuffs.registerBuff(new BuffSpeed(true));
        UtilEntityBuffs.registerBuff(new BuffAttackDamage());
        UtilEntityBuffs.registerBuff(new BuffXP());
        UtilEntityBuffs.registerBuff(new BuffMobDrops());
        UtilEntityBuffs.registerBuff(new BuffInventory());
        UtilEntityBuffs.registerBuff(new BuffInventoryDifficultyScaled());
        UtilEntityBuffs.registerBuff(new BuffAI_Infernal());
        UtilEntityBuffs.registerBuff(new BuffAI_TaskMining(UtilEntityBuffs.dataEntityBuffed_AI_Digging, TaskDigTowardsTarget.class, 5));
        UtilEntityBuffs.registerBuff(new BuffAI_TaskBase(UtilEntityBuffs.dataEntityBuffed_AI_ExplodeOnStuck, TaskExplodeTowardsTarget.class, 3));
        UtilEntityBuffs.registerBuff(new BuffAI_TaskBase(UtilEntityBuffs.dataEntityBuffed_AI_AntiAir, EntityAITaskAntiAir.class, 3));
        UtilEntityBuffs.registerBuff(new BuffAI_TaskOmniscience(UtilEntityBuffs.dataEntityBuffed_AI_Omniscience));
        UtilEntityBuffs.registerBuff(new BuffAI_TaskBase(UtilEntityBuffs.dataEntityBuffed_AI_CounterLeap, EntityAITaskEnhancedCombat.class, 2, EntityAIZombieAttack.class).setAllowRedundantAttempts());
        UtilEntityBuffs.registerBuff(new BuffAI_TaskBase(UtilEntityBuffs.dataEntityBuffed_AI_Lunge, EntityAITaskEnhancedCombat.class, 2, EntityAIZombieAttack.class).setAllowRedundantAttempts());
        UtilEntityBuffs.registerBuff(new BuffAI_TaskBase(UtilEntityBuffs.dataEntityBuffed_AI_Hoist, EntityAIHoist.class, 2).setAllowRedundantAttempts());
        UtilEntityBuffs.registerBuff(new BuffAI_TaskBase(UtilEntityBuffs.dataEntityBuffed_AI_Attack_Melee, EntityAIAttackMeleePassiveMobs.class, 2));
    }

    public static DifficultyData getData() {
        return data;
    }

    public static void loadFiles() {
        data.reset();
        if (CoroUtilCompatibility.isHWInvasionsInstalled()) {
            CoroUtil.dbg("Start reading CoroUtil json difficulty files");
            try {
                if (!dataFolder.exists() || dataFolder.listFiles().length <= 0 || DifficultyDataReader.isTemplatesUnchanged()) {
                    CULog.log("Detected coroutil json data missing or unchanged from previous generation, generating from templates");
                    DifficultyDataReader.generateDataTemplates();
                } else {
                    CULog.dbg("Preserving existing configs as they have been changed since generation");
                }
                if (dataFolder.exists()) {
                    DifficultyDataReader.processFolder(dataFolder);
                } else {
                    CULog.err("CRITICAL Error generating data folder");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            CoroUtil.dbg("done processing difficulty files");
        }
    }

    public static boolean isTemplatesUnchanged() {
        try {
            List<File> listFiles;
            if (!dataHashes.exists()) {
                return true;
            }
            String fileContentsHash = Files.toString((File)dataHashes, (Charset)Charsets.UTF_8);
            String[] hashes = fileContentsHash.split("@@@");
            if (hashes.length != (listFiles = DifficultyDataReader.getFiles(dataFolder)).size()) {
                CoroUtil.dbg("Detected file count mismatch: " + hashes.length + " vs " + listFiles.size());
                return false;
            }
            for (File child : listFiles) {
                String hash = DifficultyDataReader.getMD5(child);
                boolean found = false;
                for (String hashTry : hashes) {
                    if (!hash.equals(hashTry)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                CoroUtil.dbg("Detected file changed from last template generation: " + child);
                return false;
            }
            CoroUtil.dbg("Detected no files changed in filesystem, allowing template regen");
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static String getMD5(File file) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            return String.format("%016x", ByteBuffer.wrap(digest.digest(IOUtils.toByteArray((InputStream)new FileInputStream(file)))).getLong());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public static List<File> getFiles(File file) {
        ArrayList<File> listFiles = new ArrayList<File>();
        for (File child : file.listFiles()) {
            if (child.isFile()) {
                try {
                    if (!child.toString().endsWith(".json")) continue;
                    listFiles.add(child);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                continue;
            }
            listFiles.addAll(DifficultyDataReader.getFiles(child));
        }
        return listFiles;
    }

    public static void generateDataTemplates() {
        dataFolder.mkdirs();
        ArrayList listFiles = new ArrayList();
        ArrayList<String> listFileHashes = new ArrayList<String>();
        for (ModContainer mod : Loader.instance().getActiveModList()) {
            if (!mod.getModId().equals("coroutil")) continue;
            CraftingHelper.findFiles((ModContainer)mod, (String)("assets/" + mod.getModId() + "/config"), null, (root, file) -> {
                if (file.toString().endsWith("json")) {
                    listFiles.add(file.toString());
                }
                return true;
            }, (boolean)true, (boolean)true);
        }
        for (Object file2 : listFiles) {
            listFileHashes.add(DifficultyDataReader.copyFileFromJarPath((String)file2));
        }
        String hashFileContents = "";
        for (String hash : listFileHashes) {
            hashFileContents = hashFileContents + hash + "@@@";
        }
        try {
            FileUtils.writeStringToFile((File)dataHashes, (String)hashFileContents, (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void processFileFromJarPath(String path) {
        try {
            String pathRoot = path.substring(path.indexOf("assets/coroutil/"));
            if (path.contains(lootTablesFolder)) {
                CULog.dbg("processing, detected as loot table: " + path.substring(path.lastIndexOf("/") + 1).toString());
                String temp = pathRoot.replace("assets/coroutil/", "");
                String fileContents = UtilClasspath.getContentsFromResourceLocation(new ResourceLocation("coroutil", temp));
                CULog.dbg("file contents size: " + fileContents.length());
                String fileName = path.substring(path.lastIndexOf("/") + 1).replace(".json", "");
                ResourceLocation resName = new ResourceLocation("coroutil:loot_tables." + fileName);
                LootTable lootTable = ForgeHooks.loadLootTable((Gson)LootTableManager.field_186526_b, (ResourceLocation)resName, (String)fileContents, (boolean)true, null);
                DifficultyDataReader.data.lookupLootTables.put(fileName, lootTable);
            } else {
                CULog.dbg("processing, detected as DifficultyData: " + path.substring(path.lastIndexOf("/") + 1).toString());
                String temp = pathRoot.replace("assets/coroutil/", "");
                String fileContents = UtilClasspath.getContentsFromResourceLocation(new ResourceLocation("coroutil", temp));
                CULog.dbg("file contents size: " + fileContents.length());
                GSONBuffInventory.fromJson(fileContents, DifficultyData.class);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String copyFileFromJarPath(String path) {
        String md5 = "";
        try {
            String temp;
            String pathRoot = path.substring(path.indexOf("assets/coroutil/"));
            String pathSub = "assets/coroutil/config";
            String pathRoot2 = path.substring(path.indexOf(pathSub) + pathSub.length());
            String fileContents = "";
            if (path.contains(lootTablesFolder)) {
                temp = pathRoot.replace("assets/coroutil/", "");
                fileContents = UtilClasspath.getContentsFromResourceLocation(new ResourceLocation("coroutil", temp));
            } else {
                temp = pathRoot.replace("assets/coroutil/", "");
                fileContents = UtilClasspath.getContentsFromResourceLocation(new ResourceLocation("coroutil", temp));
            }
            if (!fileContents.equals("")) {
                File fileOut = new File(dataFolder + pathRoot2);
                CULog.dbg("copying " + path.substring(path.lastIndexOf("/") + 1).toString() + " to " + fileOut.toString());
                FileUtils.writeStringToFile((File)fileOut, (String)fileContents, (Charset)StandardCharsets.UTF_8);
                md5 = DifficultyDataReader.getMD5(fileOut);
            } else {
                CULog.err("couldnt get contents of file: " + path);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return md5;
    }

    public static void processFileFromFilesystem(File file) {
        try {
            String lastPath = file.getParent().toLowerCase();
            if (lastPath.endsWith(lootTablesFolder)) {
                CULog.dbg("processing, detected as loot table: " + file.toString());
                String fileContents = Files.toString((File)file, (Charset)Charsets.UTF_8);
                String fileName = file.getName().replace(".json", "");
                ResourceLocation resName = new ResourceLocation("coroutil:loot_tables." + fileName);
                LootTable lootTable = ForgeHooks.loadLootTable((Gson)LootTableManager.field_186526_b, (ResourceLocation)resName, (String)fileContents, (boolean)true, null);
                DifficultyDataReader.data.lookupLootTables.put(fileName, lootTable);
            } else {
                CULog.dbg("processing, detected as DifficultyData: " + file.toString());
                GSONBuffInventory.fromJson((Reader)new BufferedReader(new FileReader(file)), DifficultyData.class);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void processFolder(File path) {
        for (File child : path.listFiles()) {
            if (child.isFile()) {
                try {
                    if (!child.toString().endsWith(".json")) continue;
                    DifficultyDataReader.processFileFromFilesystem(child);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                continue;
            }
            DifficultyDataReader.processFolder(child);
        }
    }

    static {
        lootTablesFolder = "loot_tables";
        lookupJsonNameToCmodDeserializer = new HashMap();
        lookupJsonNameToConditionDeserializer = new HashMap();
        debugValidate = false;
        debugFlattenCmodsAndConditions = false;
        debugDifficulty = -1.0;
        pathData = "./config/CoroUtil/data/";
        dataFolder = new File(pathData);
        dataHashes = new File(pathData + "filehashes.txt");
    }
}

