/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.config;

import CoroUtil.difficulty.DynamicDifficulty;
import java.io.File;
import java.util.Arrays;
import modconfig.ConfigComment;
import modconfig.IConfigCategory;

public class ConfigDynamicDifficulty
implements IConfigCategory {
    @ConfigComment(value={"How long it takes to reach max difficulty level for a specific player in gameplay ticks (50 hours)"})
    public static int difficulty_MaxTicksOnServer = 3600000;
    @ConfigComment(value={"How long it takes to reach max difficulty level for a specific chunk in gameplay ticks (50 hours)"})
    public static int difficulty_MaxTicksInChunk = 3600000;
    @ConfigComment(value={"Distance from spawn required to hit the max difficulty for this setting"})
    public static int difficulty_DistFromSpawnMax = 5000;
    @ConfigComment(value={"How far around a player to lookup DPS info to average out a DPS calculation for local difficulty"})
    public static int difficulty_BestDPSChunkRadius = 4;
    @ConfigComment(value={"The expected best dps possible without mods, used to scale rating from 0 to 1"})
    public static int difficulty_BestVanillaDPS = 20;
    @ConfigComment(value={"The expected best health possible without mods, used to scale rating from 0 to 1"})
    public static int difficulty_BestVanillaHealth = 20;
    @ConfigComment(value={"The expected best armor possible without mods, used to scale rating from 0 to 1"})
    public static int difficulty_BestVanillaArmor = 20;
    @ConfigComment(value={"The expected best armor enchantment bonus possible without mods, used to scale rating from 0 to 1"})
    public static int difficulty_BestVanillaArmorEnchant = 25;
    @ConfigComment(value={"Enable to exclude things like passive mobs, cows, etc from being used to figure out DPS for a chunk"})
    public static boolean difficulty_OnlyLogDPSToHostiles = false;
    @ConfigComment(value={"Enable to only log things that can be tracked back to player, melee, bow usage, things like being on fire"})
    public static boolean difficulty_OnlyLogDPSFromPlayerAsSource = false;
    @ConfigComment(value={"Skip logging things like being in fire, being on fire, suffocation, fall damage. Lava damage will still be counted"})
    public static boolean difficulty_DontLogDPSFromEnvironment = true;
    @ConfigComment(value={"How much influence vanilla chunk inhabited time has on the averaged difficulty rating, higher number = more"})
    public static double weightPosOccupy = 1.0;
    @ConfigComment(value={"How much influence player equipment rating has on the averaged difficulty rating, higher number = more"})
    public static double weightPlayerEquipment = 1.5;
    @ConfigComment(value={"How much influence the players time in the game has on the averaged difficulty rating, higher number = more"})
    public static double weightPlayerServerTime = 0.0;
    @ConfigComment(value={"How much influence a players calculated damage per second has on the averaged difficulty rating, higher number = more"})
    public static double weightDPS = 1.5;
    @ConfigComment(value={"How much influence a players max health has on the averaged difficulty rating, higher number = more"})
    public static double weightHealth = 1.0;
    @ConfigComment(value={"How much influence a players distance from spawn has on the averaged difficulty rating, higher number = more"})
    public static double weightDistFromSpawn = 1.0;
    @ConfigComment(value={"How much influence a buffed location has on the averaged difficulty rating, higher number = more, currently unused"})
    public static double weightBuffedLocation = 2.0;
    @ConfigComment(value={"How much influence debuffed location has on the averaged difficulty rating, higher number = more"})
    public static double weightDebuffedLocation = 1.0;
    @ConfigComment(value={"Unmodded difficulty is expected from 0 to 1, anything above 1 should be from mods, use this if you feel mods are making the difficulty way too high, -1 = dont cap it"})
    public static double difficulty_Max = -1.0;
    @ConfigComment(value={"How many game ticks until a repairing block fully restores to its original block"})
    public static int ticksToRepairBlock = 6000;
    @ConfigComment(value={"For entities with block mining ability, how fast they mine a block per tick, higher is faster"})
    public static double digSpeed = 0.01;
    @ConfigComment(value={"Prevents permanent damage caused by explosions during invasions, since zombie miners will be making holes they can get in"})
    public static boolean convertExplodedBlocksToRepairingBlocksDuringInvasion = true;
    @ConfigComment(value={"Chests, machines, etc, arent normal blocks that we can convert to repairing blocks, so instead this setting just protects them from being harmed at all by explosions"})
    public static boolean preventExplodedTileEntitiesDuringInvasions = true;
    @ConfigComment(value={"Blacklist things like mob grinders from DPS calculation, supports damage_type or player name for fake players. See invasion customization wiki page for how to get these names"})
    public static String blacklistDamageSourcesForDPS = "mob_crusher, [Draconic-Evolution]";

    @Override
    public String getName() {
        return "DynamicDifficulty";
    }

    @Override
    public String getRegistryName() {
        return "coroutildd";
    }

    @Override
    public String getConfigFileName() {
        return "CoroUtil" + File.separator + this.getName();
    }

    @Override
    public String getCategory() {
        return this.getName();
    }

    @Override
    public void hookUpdatedValues() {
        try {
            String[] names = blacklistDamageSourcesForDPS.split(",");
            for (int i = 0; i < names.length; ++i) {
                names[i] = names[i].trim();
            }
            DynamicDifficulty.listBlacklistedDamageSources = Arrays.asList(names);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

