/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.ai.tasks;

import CoroUtil.ai.IInvasionControlledTask;
import CoroUtil.ai.ITaskInitializer;
import CoroUtil.block.TileEntityRepairingBlock;
import CoroUtil.config.ConfigCoroUtilAdvanced;
import CoroUtil.config.ConfigDynamicDifficulty;
import CoroUtil.forge.CULog;
import CoroUtil.util.BlockCoord;
import CoroUtil.util.CoroUtilEntity;
import CoroUtil.util.UtilMining;
import CoroUtil.world.WorldDirectorManager;
import CoroUtil.world.grid.block.BlockDataPoint;
import java.util.ArrayDeque;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class TaskDigTowardsTarget
extends EntityAIBase
implements ITaskInitializer,
IInvasionControlledTask {
    private EntityCreature entity = null;
    private IBlockState stateCurMining = null;
    private BlockCoord posCurMining = null;
    private EntityLivingBase targetLastTracked = null;
    private int digTimeCur = 0;
    private int digTimeMax = 300;
    private int noMoveTicks = 0;
    private ArrayDeque<BlockPos> listPillarToMine = new ArrayDeque();
    private Vec3d posLastTracked = null;
    public boolean debug = false;
    public static String dataUseInvasionRules = "HW_Inv_UseInvasionRules";
    public static String dataUsePlayerList = "HW_Inv_UsePlayerList";
    public static String dataWhitelistMode = "HW_Inv_WhitelistMode";
    public static String dataListPlayers = "HW_Inv_ListPlayers";

    public TaskDigTowardsTarget() {
        this.func_75248_a(3);
    }

    @Override
    public void setEntity(EntityCreature creature) {
        this.entity = creature;
    }

    public boolean func_75250_a() {
        double movementThreshold = 0.05;
        int noMoveThreshold = 5;
        if (this.posLastTracked == null) {
            this.posLastTracked = this.entity.func_174791_d();
        } else if (this.posLastTracked.func_72438_d(this.entity.func_174791_d()) < 2.0) {
            ++this.noMoveTicks;
        } else {
            this.posLastTracked = this.entity.func_174791_d();
            this.noMoveTicks = 0;
        }
        if (!this.entity.field_70122_E && !this.entity.func_70090_H()) {
            return false;
        }
        if (this.entity.func_70638_az() != null || this.targetLastTracked != null) {
            if (this.entity.func_70638_az() == null) {
                this.entity.func_70624_b(this.targetLastTracked);
                if (this.entity.func_70638_az() == null) {
                    return false;
                }
            } else {
                this.targetLastTracked = this.entity.func_70638_az();
            }
            if (this.entity.getEntityData().func_74767_n(dataUsePlayerList)) {
                String playerName = CoroUtilEntity.getName((Entity)this.entity.func_70638_az());
                boolean whitelistMode = this.entity.getEntityData().func_74767_n(dataWhitelistMode);
                String listPlayers = this.entity.getEntityData().func_74779_i(dataListPlayers);
                if (whitelistMode ? !listPlayers.contains(playerName) : listPlayers.contains(playerName)) {
                    return false;
                }
            }
            if ((this.entity.func_70661_as().func_75500_f() || this.entity.func_70661_as().func_75505_d().func_75874_d() == 1 || this.noMoveTicks > noMoveThreshold) && this.updateBlockToMine()) {
                return true;
            }
        }
        return false;
    }

    public boolean func_75253_b() {
        if (this.posCurMining == null) {
            this.dbg("shouldContinueExecuting fail because posCurMining == null");
            return false;
        }
        BlockPos pos = new BlockPos(this.posCurMining.posX, this.posCurMining.posY, this.posCurMining.posZ);
        if (!this.entity.field_70170_p.func_175623_d(pos) && UtilMining.canMineBlock(this.entity.field_70170_p, pos, this.entity.field_70170_p.func_180495_p(pos).func_177230_c())) {
            return true;
        }
        this.setMiningBlock(null, null);
        this.dbg("shouldContinueExecuting fail because not air");
        return false;
    }

    public void func_75249_e() {
        this.dbg("start mining task");
    }

    public void func_75251_c() {
        this.digTimeCur = 0;
        this.listPillarToMine.clear();
        this.setMiningBlock(null, null);
    }

    public void func_75246_d() {
        this.entity.field_70708_bq = 0;
        if (this.entity.func_70638_az() != null) {
            this.targetLastTracked = this.entity.func_70638_az();
        } else if (this.targetLastTracked != null) {
            this.entity.func_70624_b(this.targetLastTracked);
        }
        this.tickMineBlock();
    }

    public boolean updateBlockToMine() {
        IBlockState state;
        if (this.entity.func_70638_az() == null) {
            return false;
        }
        this.setMiningBlock(null, null);
        double entPosX = Math.floor(this.entity.field_70165_t) + 0.5;
        double entPosZ = Math.floor(this.entity.field_70161_v) + 0.5;
        double vecX = this.entity.func_70638_az().field_70165_t - entPosX;
        double vecY = this.entity.func_70638_az().func_174813_aQ().field_72338_b - this.entity.func_174813_aQ().field_72338_b;
        double vecZ = this.entity.func_70638_az().field_70161_v - entPosZ;
        double angle = Math.atan2(vecZ, vecX);
        angle = Math.round(Math.toDegrees(angle) / 90.0) * 90L;
        double relX = Math.cos(angle);
        double relZ = Math.sin(angle);
        double scanX = entPosX + relX;
        double scanZ = entPosZ + relZ;
        double distHoriz = Math.sqrt(vecX * vecX + vecZ * vecZ);
        if (distHoriz < 0.0) {
            distHoriz = 1.0;
        }
        double distVert = vecY;
        double factor = distVert / distHoriz;
        this.dbg("factor: " + factor);
        this.listPillarToMine.clear();
        if (distHoriz <= 1.0) {
            scanX = entPosX;
            scanZ = entPosZ;
        }
        BlockPos posFrontFeet = new BlockPos(MathHelper.func_76128_c((double)scanX), MathHelper.func_76128_c((double)this.entity.func_174813_aQ().field_72338_b), MathHelper.func_76128_c((double)scanZ));
        BlockPos posFeetCheck = new BlockPos(MathHelper.func_76128_c((double)entPosX), MathHelper.func_76128_c((double)this.entity.func_174813_aQ().field_72338_b), MathHelper.func_76128_c((double)entPosZ));
        boolean wasDiggingStrait = false;
        if (factor <= (double)-0.3f) {
            this.dbg("Digging Down");
            this.listPillarToMine.add(posFrontFeet.func_177981_b(1));
            this.listPillarToMine.add(posFrontFeet);
            this.listPillarToMine.add(posFrontFeet.func_177979_c(1));
        } else if (factor >= (double)0.1f) {
            if (!this.entity.field_70170_p.func_175623_d(posFeetCheck.func_177981_b(2)) && UtilMining.canMineBlock(this.entity.field_70170_p, posFeetCheck.func_177981_b(2), this.entity.field_70170_p.func_180495_p(posFeetCheck.func_177981_b(2)).func_177230_c())) {
                this.dbg("Detected block above head, dig it out");
                this.listPillarToMine.add(posFeetCheck.func_177981_b(2));
            } else {
                this.dbg("Digging Up");
                this.listPillarToMine.add(posFrontFeet.func_177981_b(1));
                this.listPillarToMine.add(posFrontFeet.func_177981_b(2));
                this.listPillarToMine.add(posFrontFeet.func_177981_b(3));
            }
        } else {
            wasDiggingStrait = true;
            this.dbg("Digging Strait");
            this.listPillarToMine.add(posFrontFeet.func_177981_b(1));
            this.listPillarToMine.add(posFrontFeet);
        }
        boolean fail = false;
        boolean oneMinable = false;
        for (BlockPos pos : this.listPillarToMine) {
            state = this.entity.field_70170_p.func_180495_p(pos);
            this.dbg("set: " + pos + " - " + state.func_177230_c());
        }
        for (BlockPos pos : this.listPillarToMine) {
            if (this.entity.field_70170_p.func_175623_d(pos) || !UtilMining.canMineBlock(this.entity.field_70170_p, pos, this.entity.field_70170_p.func_180495_p(pos).func_177230_c())) continue;
            oneMinable = true;
            break;
        }
        if (!oneMinable) {
            this.dbg("All air blocks or unmineable, trying to fallback to alternate");
            this.listPillarToMine.clear();
            wasDiggingStrait = this.entity.field_70170_p.field_73012_v.nextBoolean();
            if (wasDiggingStrait) {
                if (factor < 0.0) {
                    this.dbg("Digging Down Fallback try, but not infront of feet, instead directly under");
                    this.listPillarToMine.add(posFeetCheck.func_177981_b(1));
                    this.listPillarToMine.add(posFeetCheck);
                    this.listPillarToMine.add(posFeetCheck.func_177979_c(1));
                } else if (factor >= 0.0) {
                    if (!this.entity.field_70170_p.func_175623_d(posFeetCheck.func_177981_b(2)) && UtilMining.canMineBlock(this.entity.field_70170_p, posFeetCheck.func_177981_b(2), this.entity.field_70170_p.func_180495_p(posFeetCheck.func_177981_b(2)).func_177230_c())) {
                        IBlockState check = this.entity.field_70170_p.func_180495_p(posFeetCheck.func_177981_b(2));
                        this.dbg("Digging Up Fallback try, Detected block above head, dig it out Fallback try, block was: " + check);
                        this.listPillarToMine.add(posFeetCheck.func_177981_b(2));
                    } else {
                        this.dbg("Digging Up Fallback try");
                        this.listPillarToMine.add(posFrontFeet.func_177981_b(1));
                        this.listPillarToMine.add(posFrontFeet.func_177981_b(2));
                        this.listPillarToMine.add(posFrontFeet.func_177981_b(3));
                    }
                }
            } else {
                this.dbg("Digging Strait Fallback try");
                this.listPillarToMine.add(posFrontFeet.func_177981_b(1));
                this.listPillarToMine.add(posFrontFeet);
            }
            for (BlockPos pos : this.listPillarToMine) {
                state = this.entity.field_70170_p.func_180495_p(pos);
                this.dbg("set try2: " + pos + " - " + state.func_177230_c());
            }
            for (BlockPos pos : this.listPillarToMine) {
                if (this.entity.field_70170_p.func_175623_d(pos) || !UtilMining.canMineBlock(this.entity.field_70170_p, pos, this.entity.field_70170_p.func_180495_p(pos).func_177230_c())) continue;
                oneMinable = true;
                break;
            }
            if (!oneMinable) {
                this.dbg("All air blocks or unmineable, fallback failed, cancelling");
                this.listPillarToMine.clear();
                return false;
            }
        }
        this.setMiningBlock(this.entity.field_70170_p.func_180495_p(this.listPillarToMine.getFirst()), new BlockCoord(this.listPillarToMine.getFirst()));
        return true;
    }

    public void setMiningBlock(IBlockState state, BlockCoord pos) {
        this.dbg("setMiningBlock: " + pos + (state != null ? " - " + state.func_177230_c() : ""));
        this.posCurMining = pos;
        this.stateCurMining = state;
    }

    public void tickMineBlock() {
        if (this.posCurMining == null) {
            return;
        }
        IBlockState state = this.entity.field_70170_p.func_180495_p(this.posCurMining.toBlockPos());
        Block block = state.func_177230_c();
        while (this.entity.field_70170_p.func_175623_d(this.posCurMining.toBlockPos()) || !UtilMining.canMineBlock(this.entity.field_70170_p, this.posCurMining.toBlockPos(), this.entity.field_70170_p.func_180495_p(this.posCurMining.toBlockPos()).func_177230_c())) {
            this.dbg("Detected air or unmineable block, moving to next block in list, cur size: " + this.listPillarToMine.size());
            if (this.listPillarToMine.size() <= 1) {
                this.func_75251_c();
                return;
            }
            this.listPillarToMine.removeFirst();
            BlockPos pos = this.listPillarToMine.getFirst();
            this.setMiningBlock(this.entity.field_70170_p.func_180495_p(pos), new BlockCoord(pos));
            state = this.entity.field_70170_p.func_180495_p(this.posCurMining.toBlockPos());
            block = state.func_177230_c();
        }
        if (this.stateCurMining != state || this.entity.func_70011_f((double)this.posCurMining.posX, (double)this.posCurMining.posY, (double)this.posCurMining.posZ) > 6.0) {
            this.dbg("too far or block changed state");
            this.entity.field_70170_p.func_175715_c(2147483597, this.posCurMining.toBlockPos(), 0);
            this.setMiningBlock(null, null);
            return;
        }
        double blockStrength = state.func_185887_b(this.entity.field_70170_p, this.posCurMining.toBlockPos());
        if (blockStrength == -1.0) {
            this.setMiningBlock(null, null);
            return;
        }
        if (this.entity.field_70170_p.func_82737_E() % 10L == 0L) {
            this.entity.func_184609_a(EnumHand.MAIN_HAND);
            this.entity.field_70170_p.func_184133_a(null, this.posCurMining.toBlockPos(), block.getSoundType(state, this.entity.field_70170_p, this.posCurMining.toBlockPos(), (Entity)this.entity).func_185845_c(), SoundCategory.HOSTILE, 0.5f, 1.0f);
        }
        BlockDataPoint bdp = WorldDirectorManager.instance().getBlockDataGrid(this.entity.field_70170_p).getBlockData(this.posCurMining.getX(), this.posCurMining.getY(), this.posCurMining.getZ());
        int maxTimeBetweenDigProgress = 600;
        if (bdp.lastTickTimeDig + (long)maxTimeBetweenDigProgress <= this.entity.field_70170_p.func_82737_E()) {
            bdp.digDamage = 0.0f;
        }
        bdp.lastTickTimeDig = this.entity.field_70170_p.func_82737_E();
        double digSpeed = ConfigDynamicDifficulty.digSpeed;
        bdp.digDamage = (float)((double)bdp.digDamage + digSpeed / blockStrength);
        if ((double)bdp.digDamage > 1.0) {
            this.entity.field_70170_p.func_175715_c(2147483597, this.posCurMining.toBlockPos(), 0);
            if (UtilMining.canConvertToRepairingBlock(this.entity.field_70170_p, state)) {
                if (UtilMining.canGrabEventCheck(this.entity.field_70170_p, state, this.posCurMining.toBlockPos())) {
                    TileEntityRepairingBlock.replaceBlockAndBackup(this.entity.field_70170_p, this.posCurMining.toBlockPos());
                }
            } else {
                boolean useFakePlayer = true;
                if (useFakePlayer) {
                    UtilMining.tryRemoveBlockWithFakePlayer(this.entity.field_70170_p, this.posCurMining.toBlockPos());
                } else {
                    Block.func_180635_a((World)this.entity.field_70170_p, (BlockPos)this.posCurMining.toBlockPos(), (ItemStack)new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state)));
                    this.entity.field_70170_p.func_175698_g(this.posCurMining.toBlockPos());
                }
            }
            if (this.listPillarToMine.size() > 1) {
                this.listPillarToMine.removeFirst();
                BlockPos pos = this.listPillarToMine.getFirst();
                this.setMiningBlock(this.entity.field_70170_p.func_180495_p(pos), new BlockCoord(pos));
            } else {
                this.listPillarToMine.clear();
                this.setMiningBlock(null, null);
            }
            bdp.digDamage = 0.0f;
        } else {
            this.entity.field_70170_p.func_175715_c(2147483597, this.posCurMining.toBlockPos(), (int)((double)bdp.digDamage * 10.0));
        }
    }

    @Override
    public boolean shouldBeRemoved() {
        boolean forInvasion = this.entity.getEntityData().func_74767_n(dataUseInvasionRules);
        if (forInvasion && ConfigCoroUtilAdvanced.removeInvasionAIWhenInvasionDone && this.entity.field_70170_p.func_72935_r()) {
            CULog.dbg("removing digging from " + this.entity.func_70005_c_());
            return true;
        }
        return false;
    }

    public void dbg(String str) {
        this.debug = false;
        if (this.debug) {
            CULog.dbg(str);
        }
    }
}

