/*
 * Decompiled with CFR 0.152.
 */
package T145.metalchests.core;

import T145.metalchests.api.BlocksMC;
import T145.metalchests.api.ItemsMC;
import T145.metalchests.api.chests.UpgradeRegistry;
import T145.metalchests.api.immutable.ChestType;
import T145.metalchests.api.immutable.ModSupport;
import T145.metalchests.api.immutable.RegistryMC;
import T145.metalchests.client.gui.GuiHandler;
import T145.metalchests.config.ModConfig;
import T145.metalchests.entities.EntityMinecartMetalChest;
import T145.metalchests.tiles.TileHungryMetalChest;
import T145.metalchests.tiles.TileMetalChest;
import T145.metalchests.tiles.TileSortingMetalChest;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.datafix.walkers.ItemStackDataLists;
import net.minecraftforge.common.util.CompoundDataFixer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.research.ResearchCategories;

@Mod(modid="metalchests", name="MetalChests", version="v4.0.1.g01955d6", updateJSON="https://raw.githubusercontent.com/T145/metalchests/master/update.json", dependencies="after:thaumcraft", acceptedMinecraftVersions="[1.12.2]")
public class MetalChests {
    static final String VERSION = "v4.0.1.g01955d6";
    static final String UPDATE_JSON = "https://raw.githubusercontent.com/T145/metalchests/master/update.json";
    public static final Logger LOG = LogManager.getLogger((String)"metalchests");
    public static final CreativeTabs TAB = new CreativeTabs("metalchests"){

        @SideOnly(value=Side.CLIENT)
        public boolean hasSearchBar() {
            return true;
        }

        @SideOnly(value=Side.CLIENT)
        public ItemStack func_78016_d() {
            return new ItemStack(BlocksMC.METAL_CHEST, 1, 1);
        }

        @SideOnly(value=Side.CLIENT)
        public void func_78018_a(NonNullList<ItemStack> items) {
            BlocksMC.METAL_CHEST.func_149666_a((CreativeTabs)this, items);
            ItemsMC.CHEST_UPGRADE.func_150895_a((CreativeTabs)this, items);
            if (BlocksMC.HUNGRY_METAL_CHEST != null) {
                BlocksMC.HUNGRY_METAL_CHEST.func_149666_a((CreativeTabs)this, items);
            }
            if (ItemsMC.HUNGRY_CHEST_UPGRADE != null) {
                ItemsMC.HUNGRY_CHEST_UPGRADE.func_150895_a((CreativeTabs)this, items);
            }
            if (BlocksMC.SORTING_METAL_CHEST != null) {
                BlocksMC.SORTING_METAL_CHEST.func_149666_a((CreativeTabs)this, items);
            }
            if (BlocksMC.SORTING_HUNGRY_METAL_CHEST != null) {
                BlocksMC.SORTING_HUNGRY_METAL_CHEST.func_149666_a((CreativeTabs)this, items);
            }
            if (ModConfig.GENERAL.enableMinecarts) {
                ItemsMC.MINECART_METAL_CHEST.func_150895_a((CreativeTabs)this, items);
            }
        }
    }.func_78025_a("item_search.png");
    @Mod.Instance(value="metalchests")
    public static MetalChests instance;
    public static final DataSerializer<ChestType> CHEST_TYPE;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ModMetadata meta = event.getModMetadata();
        meta.authorList.add("T145");
        meta.autogenerated = false;
        meta.credits = "The fans!";
        meta.description = "The better alternative to IronChests";
        meta.logoFile = "logo.png";
        meta.modId = "metalchests";
        meta.name = "MetalChests";
        meta.url = "https://github.com/T145/metalchests";
        meta.useDependencyInformation = false;
        meta.version = VERSION;
        DataSerializers.func_187189_a(CHEST_TYPE);
    }

    private void registerFixes(DataFixer fixer, Class tileClass) {
        fixer.func_188258_a(FixTypes.BLOCK_ENTITY, (IDataWalker)new ItemStackDataLists(tileClass, new String[]{"Items"}));
    }

    private void registerEntityFixes(DataFixer fixer, Class entityClass) {
        fixer.func_188258_a(FixTypes.ENTITY, (IDataWalker)new ItemStackDataLists(entityClass, new String[]{"Items"}));
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        CompoundDataFixer fixer = FMLCommonHandler.instance().getDataFixer();
        this.registerFixes((DataFixer)fixer, TileMetalChest.class);
        this.registerEntityFixes((DataFixer)fixer, EntityMinecartMetalChest.class);
        if (ModSupport.hasRefinedRelocation()) {
            this.registerFixes((DataFixer)fixer, TileSortingMetalChest.class);
        }
        if (ModSupport.hasThaumcraft()) {
            this.registerFixes((DataFixer)fixer, TileHungryMetalChest.class);
            ThaumcraftApi.registerResearchLocation((ResourceLocation)new ResourceLocation("metalchests", "research/hungry_metal_chests"));
            ResearchCategories.registerCategory((String)"HUNGRYMETALCHESTS", (String)"UNLOCKARTIFICE", (AspectList)new AspectList().add(Aspect.MECHANISM, 10).add(Aspect.CRAFT, 10).add(Aspect.METAL, 10).add(Aspect.TOOL, 10).add(Aspect.ENERGY, 10).add(Aspect.LIGHT, 5).add(Aspect.FLIGHT, 5).add(Aspect.TRAP, 5).add(Aspect.FIRE, 5), (ResourceLocation)new ResourceLocation("thaumcraft", "textures/research/rd_chest.png"), (ResourceLocation)new ResourceLocation("thaumcraft", "textures/gui/gui_research_back_4.jpg"), (ResourceLocation)ModSupport.Thaumcraft.BACK_OVER);
        }
        if (ModSupport.hasThaumcraft() && ModSupport.hasRefinedRelocation()) {
            this.registerFixes((DataFixer)fixer, TileSortingMetalChest.class);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        for (ItemStack stack : OreDictionary.getOres((String)"chestWood")) {
            UpgradeRegistry.registerChest(RegistryMC.RESOURCE_CHEST_UPGRADE, Block.func_149634_a((Item)stack.func_77973_b()), BlocksMC.METAL_CHEST);
        }
    }

    static {
        CHEST_TYPE = new DataSerializer<ChestType>(){

            public void write(PacketBuffer buf, ChestType value) {
                buf.func_179249_a((Enum)value);
            }

            public ChestType read(PacketBuffer buf) throws IOException {
                return (ChestType)buf.func_179257_a(ChestType.class);
            }

            public DataParameter<ChestType> func_187161_a(int id) {
                return new DataParameter(id, (DataSerializer)this);
            }

            public ChestType copyValue(ChestType value) {
                return value;
            }
        };
    }
}

