/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.nether.block.saplings;

import com.progwml6.natura.Natura;
import com.progwml6.natura.library.NaturaRegistry;
import com.progwml6.natura.nether.NaturaNether;
import com.progwml6.natura.nether.block.leaves.BlockNetherLeaves;
import com.progwml6.natura.nether.block.logs.BlockNetherLog2;
import com.progwml6.natura.world.worldgen.trees.BaseTreeGenerator;
import com.progwml6.natura.world.worldgen.trees.nether.BloodwoodTreeGenerator;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.terraingen.TerrainGen;
import slimeknights.mantle.block.EnumBlock;

public class BlockNetherSapling2
extends BlockSapling {
    public static PropertyEnum<SaplingType> FOLIAGE = PropertyEnum.func_177709_a((String)"foliage", SaplingType.class);

    public BlockNetherSapling2() {
        this.func_149647_a((CreativeTabs)NaturaRegistry.tabWorld);
        this.func_180632_j(this.field_176227_L.func_177621_b());
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(0.0f);
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (SaplingType type : SaplingType.values()) {
            list.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a(FOLIAGE, (Comparable)((Object)type)))));
        }
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FOLIAGE, field_176479_b, field_176480_a});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        if (meta < 0 || meta >= SaplingType.values().length) {
            meta = 0;
        }
        SaplingType sapling = SaplingType.values()[meta];
        return this.func_176223_P().func_177226_a(FOLIAGE, (Comparable)((Object)sapling));
    }

    public int func_176201_c(IBlockState state) {
        return ((SaplingType)((Object)state.func_177229_b(FOLIAGE))).ordinal();
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState ceilingBlockState;
        Block netherCeiling;
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        return !(block != null && !block.func_176200_f((IBlockAccess)worldIn, pos) || (netherCeiling = (ceilingBlockState = worldIn.func_180495_p(pos.func_177984_a())).func_177230_c()) == null || !this.canGrowOnBlock(netherCeiling) && !netherCeiling.canSustainPlant(ceilingBlockState, (IBlockAccess)worldIn, pos.func_177984_a(), EnumFacing.DOWN, (IPlantable)this));
    }

    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        switch ((SaplingType)((Object)state.func_177229_b(FOLIAGE))) {
            case BLOODWOOD: {
                IBlockState ceilingBlockState = worldIn.func_180495_p(pos.func_177984_a());
                Block netherCeiling = ceilingBlockState.func_177230_c();
                if (netherCeiling == null) {
                    return false;
                }
                return this.canGrowOnBlock(netherCeiling) || netherCeiling.canSustainPlant(ceilingBlockState, (IBlockAccess)worldIn, pos.func_177984_a(), EnumFacing.DOWN, (IPlantable)this);
            }
        }
        return true;
    }

    public boolean canGrowOnBlock(Block block) {
        return block == Blocks.field_150425_aM || block == Blocks.field_150424_aL || block == NaturaNether.netherTaintedSoil;
    }

    @Nonnull
    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Nether;
    }

    public boolean func_176200_f(IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return false;
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        IBlockState iblockstate = world.func_180495_p(pos);
        int meta = iblockstate.func_177230_c().func_176201_c(iblockstate);
        return new ItemStack(Item.func_150898_a((Block)this), 1, meta);
    }

    public void func_176476_e(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random rand) {
        if (!TerrainGen.saplingGrowTree((World)worldIn, (Random)rand, (BlockPos)pos)) {
            return;
        }
        BaseTreeGenerator gen = new BaseTreeGenerator();
        switch ((SaplingType)((Object)state.func_177229_b(FOLIAGE))) {
            case BLOODWOOD: {
                IBlockState log = NaturaNether.netherLog2.func_176223_P().func_177226_a((IProperty)BlockNetherLog2.META, (Comparable)Integer.valueOf(15));
                IBlockState log2 = NaturaNether.netherLog2.func_176223_P().func_177226_a((IProperty)BlockNetherLog2.META, (Comparable)Integer.valueOf(0));
                IBlockState log3 = NaturaNether.netherLog2.func_176223_P().func_177226_a((IProperty)BlockNetherLog2.META, (Comparable)Integer.valueOf(1));
                IBlockState log4 = NaturaNether.netherLog2.func_176223_P().func_177226_a((IProperty)BlockNetherLog2.META, (Comparable)Integer.valueOf(2));
                IBlockState log5 = NaturaNether.netherLog2.func_176223_P().func_177226_a((IProperty)BlockNetherLog2.META, (Comparable)Integer.valueOf(3));
                IBlockState leaves = NaturaNether.netherLeaves.func_176223_P().func_177226_a(BlockNetherLeaves.TYPE, (Comparable)((Object)BlockNetherLeaves.LeavesType.BLOODWOOD));
                gen = new BloodwoodTreeGenerator(log, log2, log3, log4, log5, leaves);
                break;
            }
            default: {
                Natura.log.warn("BlockNetherSapling Warning: Invalid sapling meta/foliage, " + state.func_177229_b(FOLIAGE) + ". Please report!");
            }
        }
        worldIn.func_175698_g(pos);
        gen.generateTree(rand, worldIn, pos);
        if (worldIn.func_175623_d(pos)) {
            worldIn.func_180501_a(pos, state, 4);
        }
    }

    public static enum SaplingType implements IStringSerializable,
    EnumBlock.IEnumMeta
    {
        BLOODWOOD;

        public final int meta = this.ordinal();

        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.US);
        }

        public int getMeta() {
            return this.meta;
        }
    }
}

