; ****************************************************************************
; `PAUSE' - Source code for `pause' object
;   Written by Robert Riebisch
;
; Copyright (c) 1997-2006 BTTR Software.  All rights reserved.
;
; This program is free software; you can redistribute it and/or modify it
; under the terms of the `MODIFIED' BSD LICENSE.  Please see `legal.txt'
; for details.
; ****************************************************************************

  Org 0     ; .SYS file entry point
  Cpu 8086  ; limit instruction set

; device driver header
devdrvrhdr:
  Dd -1         ; pointer to next driver
  Dw 0          ; device attributes (block device)
  Dw @strat     ; strategy routine offset
  Dw @intr      ; interrupt routine offset
  Db 1          ; # of units
  Times 7 Db 0  ; (reserved)

reqhdrptr: Dd 0  ; pointer to request header

; strategy routine
@strat:
  mov [cs:reqhdrptr], bx      ; save pointer to request header
  mov [cs:reqhdrptr + 2], es
  retf

; interrupt routine
@intr:
  push ax  ; save affected registers
  push bx
  push dx
  push ds
  pushf

; clear keyboard buffer
.@nextkey:
  mov ah, 1      ; check for keystroke
  int 16h
  jz .@empty
  xor ah, ah     ; get keystroke
  int 16h
  jmp .@nextkey

.@empty:
  push cs  ; make local data (`pausemsg')
  pop ds   ;   addressable by setting DS = CS

  mov dx, pausemsg  ; print pause message
  mov ah, 9
  int 21h

  xor ah, ah  ; wait for keystroke
  int 16h

; get removed from RAM by signaling an error
  lds bx, [reqhdrptr]       ; point DS:BX to request header
  mov word [bx + 3], 8103h  ; status = `Error', `Done', `Unknown command'

; above line might not be enough
  mov byte [bx + 13], 0  ; # of units
  mov word [bx + 14], 0  ; break address = CS:0 (for max. compatibility with,
  mov [bx + 16], cs      ;   e.g., old FreeDOS kernels, PTS-DOS 2000 or 32)

  popf    ; restore affected registers
  pop ds
  pop dx
  pop bx
  pop ax
  retf

pausemsg: Db 'Press any key to continue...', 13, 10, '$'

; (end of `pause.asm')
