    //CPX2CPI.C         
   // Balthasar Szczepaski Copyright 2013
  //
 // //This file is part of CPIED
// // 
  //  CPIED is free software: you can redistribute it and/or modify
 // //it under the terms of the GNU General Public License as published by
// // the Free Software Foundation, either version 3 of the License, or
  //  (at your option) any later version.
 //   
// // CPIED is distributed in the hope that it will be useful,
  //  but WITHOUT ANY WARRANTY; without even the implied warranty of
 // //MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// // GNU General Public License for more details.
  //
 // //You should have received a copy of the GNU General Public License along
// // with CPIED (copying.txt).  If not, see <http://www.gnu.org/licenses/>.
  //  
 // //This file contains code from FreeDOS mode's modecp.c
// //                            
  //
 //modecp.c:
/* This code can be used under the terms of  GNU Public License */
/* (GPL) version 2 or later.   Written for FreeDOS MODE by Eric */
/* Auer (eric@coli.uni-sb.de) (c) 2003-2005. GPL -> www.gnu.org */

/* Modified 2005 by Eric Auer to model MODECON by Aitor Merino! */
/* MODE command: CODEPAGE related parts */

#include <io.h>
#include <fcntl.h>
#include <alloc.h>
#include <stdio.h>
#include <dos.h>
#include <sys/stat.h>

static union REGS r;

#define BYTE unsigned char
#define WORD unsigned int

#define UPXoverhead  320	/* actually even less: UPX stub has  */
	/* 2 parts - 1. relocate 2. decompress - and uses almost no  */
	/* stack. We do not even use stack inside the buffer at all, */
	/* makes no difference for the UPX stub. Actual overhead is  */
	/* therefore only part 2 of the stub plus no extra stack...  */
#define MaxBufSize   (58880U + UPXoverhead)
	/* "CPX" support decompresses data  in place  in the buffer. */

	BYTE far * buf;		/* made pointer far */

extern int cpx2cpi(void far * buffer); /* returns 0 plain 1 upxed -1 error */
	/* this part is written in NASM Assembly language, compile */
	/* it with NASM -fobj -o cpitrick.obj cpitrick.asm */

int main(int argc,char* argv[])
{
	unsigned char con=1;
	unsigned int cpf;	/* file handle */
	unsigned long m; 	/* filelen is (FAT16: signed) long! */
	struct SREGS sregs;

	if(argc<3)
  {
    puts("cpx2cpi *.cpx *.cpi [q]");
    return 1;
  }
	if(argc>3)
	{
		if(argv[3][0]=='q'||argv[3][0]=='Q')
			con=0;
		else
			con=1;
	}
	else
		con=1;
	
	/** Check that the file exists **/
	if ((cpf = open(argv[1], O_RDONLY | O_BINARY)) == 0xffffU)
	{
    if(con)
			printf("could not open %s\n",argv[1]);
    return 8;
  }

		buf = farmalloc(MaxBufSize+15); /* changed malloc to farmalloc */
	if (buf == NULL) {
	   if(con)
			puts ("Out of memory!");
		return 7;
	}

	/* for UPXed CPI file (CPX file) support, buffer must be aligned */
	while (FP_OFF(buf) % 16)	/* "move" buf to next paragraph */
		buf++;
	while (FP_OFF(buf)) {		/* normalize buf to "someseg:0" */
		buf = MK_FP(FP_SEG(buf)+1, FP_OFF(buf)-16);
	}

	/* we do NOT free malloced buf later - happens on exit anyway. */
 //Not so sure about that, got memory errors from command.com
 
	/** Read the buffer **/

	/* if memory model is TINY (.com file), we need our */
	/* OWN read( handle, FAR buffer pointer, size ) ... */
        sregs.ds = FP_SEG(buf);
        r.x.dx = FP_OFF(buf);
        r.h.ah = 0x3f;	/* read from file handle */
        r.x.cx = MaxBufSize - UPXoverhead;
        r.x.bx = cpf;	/* handle */

	int86x (0x21, &r, &r, &sregs);
	if ( r.x.cflag ) {
		if(con)
			printf("%s read error, code %u.\n",argv[1], r.x.ax);
    close (cpf);
		farfree(buf);
		return 6;
	
	}
       


	close (cpf);

	m = cpx2cpi(buf); /* ret: 0 plain 1 upxed -1 error */ /* new 29apr2004 */

	if (m == -1)
	{
		if(con)
			puts("Not a CPI or CPX");
		farfree(buf);
		return 5;
	}
	else if (m == 1)
	{
		if(con)
			printf("%s is a cpx\n",argv[1]);
	}
	else {
		if(con)
			printf("%s is already a CPI\n",argv[1]);
		close (cpf);
		farfree(buf);
		return 4;
	}
	//create the cpi 
	if ((cpf = (unsigned)(creat(argv[2],S_IWRITE)))==0xffffU)
	{
		if(con)
			printf("could not create %s\n",argv[2]);
		farfree(buf);
		return 3;
	}
	close (cpf);
	//for some reason open doesn't want to create a new file
	if ((cpf = open(argv[2], O_WRONLY | O_BINARY | O_CREAT | O_TRUNC)) == 0xffffU)
	{
		if(con)
			printf("could not open %s\n",argv[2]);
		farfree(buf);
		return 2;
	}
	sregs.ds = FP_SEG(buf);
	r.x.dx = FP_OFF(buf);
	r.h.ah = 0x40;	/* write to file handle */
	r.x.cx = MaxBufSize - UPXoverhead;
	r.x.bx = cpf;	/* handle */
	int86x (0x21, &r, &r, &sregs);
	if ( r.x.cflag )
	{
		if(con)
			printf("%s write error, code %u.\n",argv[2], r.x.ax);
		farfree(buf);
		close (cpf);
		return 1;
	}
	close (cpf);
	if(con)
		printf("%s converted to %s\n",argv[1],argv[2]);
	farfree(buf);
	return 0;
}
