{ ****************************************************************************
  `BATT' - show battery status through APM BIOS
    Written by Michal H. Tyc

  Copyright (c) 1997-2005 BTTR Software
  All rights reserved.

  This program is free software; you can redistribute it and/or modify it
  under the terms of the `MODIFIED' BSD LICENSE.

  See `legal.txt' for details.
  **************************************************************************** }

{.$DEFINE DEBUG}  { remove `.' to activate }

{$IFDEF DEBUG}
  {$A+,B-,D+,E-,F-,G-,I+,L+,N-,O-,R+,S+,V-,X+}  { TP 6.x compiler options }
  {$IFDEF VER70}                                { TP 7.x specific options }
    {$P-,Q+,T-}
  {$ENDIF}
{$ELSE}
  {$A+,B-,D-,E-,F-,G-,I-,L-,N-,O-,R-,S-,V-,X+}  { TP 6.x compiler options }
  {$IFDEF VER70}                                { TP 7.x specific options }
    {$P-,Q-,T-}
  {$ENDIF}
{$ENDIF}
{$M 4096,0,0}

program batt;

const
  APM_CHECK   = $5300;  { APM BIOS installation check }
  APM_CONNECT = $5301;  { connect real-mode APM interface }
  APM_DISCONN = $5304;  { disconnect real-mode APM interface }
  APM_POWSTAT = $530A;  { get power status }
  APM_SETVER  = $530E;  { tell BIOS the driver version }

var
  apmver,         { APM BIOS version }
  acbatt,         { AC and battery status }
  perc: Word;     { Percent of remaining battery charge }
  remt: Integer;  { Time remaining to complete discharge }
  connst: byte;   { APM BIOS interface connection status }

{ Check if APM BIOS present (0 = present, $ff = absent) }
function apmcheck: Byte; assembler;
asm
  mov ax, APM_CHECK
  xor bx, bx
  int 15h            { is APM installed? }
  mov [apmver], ax   { remember the version if returned }
  sbb al, al         { set AL on Carry (error flag) }
end;

{ Connect APM BIOS (0 = done, $ff = error) }
function apmconnect: Byte; assembler;
asm
  mov ax, APM_CONNECT
  xor bx, bx
  int 15h                  { connect real-mode interface }
  jc @chk                  { an error occured }
  cmp word [apmver], 100h
  je @st                   { version 1.0, simply return }
  mov cx, 101h
  xor bx, bx
  mov ax, APM_SETVER
  int 15h                  { inform APM BIOS that we support version 1.1 }
  clc
  jmp @st                  { done }
@chk:
  inc [connst]  { may be already connected }
  cmp ah, 2
  je @st        { if so, ok }
  stc           { report an error, value of connst unimportant }
@st:
  sbb al, al  { set AL on Carry (error flag) }
end;

{ Disconnect APM BIOS }
procedure apmdisconnect; assembler;
asm
  mov ax, APM_DISCONN
  xor bx, bx
  int 15h
end;

{ Get current battery status (0 = done, $ff = error) }
function getbattstat: Byte; assembler;
asm
  mov ax, APM_POWSTAT
  mov bx, 1            { all devices }
  mov dx, -1           { DX not set by APM 1.0 }
  int 15h              { get power status }
  jc @st               { an error occured }
  mov [acbatt], bx     { save AC and battery status}
  mov [perc], cx       { save remaining charge }
  xchg ax, dx
  test ax, ax
  js @min              { time in minutes, or invalid }
  cwd
  mov cx, 60
  div cx               { convert seconds to minutes }
@min:
  cmp ax, -1
  je @t          { invalid value, APM 1.0, no Carry }
  and ax, 7FFFh  { clear bit 15, no Carry }
@t:
  mov [remt], ax  { save remaining time }
@st:
  sbb al, al  { set AL on Carry (error flag) }
end;

{ Print battery status }
procedure printstate;
var
  m: Integer;
begin
  Writeln(' APM version........ ', hi(apmver), '.', lo(apmver));
  Write(' AC line status..... ');
  case hi(acbatt) of
    0: Writeln('OFF');
    1: Writeln('ON');
  $ff: Writeln('BACKUP');
  else Writeln('UNKNOWN');
  end;
  Write(' Battery status..... ');
  case lo(acbatt) of
    0: Writeln('HIGH');
    1: Writeln('LOW');
    2: Writeln('CRITICAL');
    3: Writeln('CHARGING');
  else Writeln('UNKNOWN');
  end;
  Write(' Remaining charge... ');
  if (lo(perc) <= 100) then
    Writeln(lo(perc), '%')
  else
    Writeln('UNKNOWN');
  if (remt <> -1) then
  begin
    m := remt mod 60;
    Writeln(' Remaining time..... ',
            remt div 60, ' h ',         { hours }
            m div 10, m mod 10, ' m');  { minutes always with leading zero }
  end;
end;

begin
{$IFDEF VER60}  { TP 6.x RTL does not initialize global variables }
  connst := 0;
{$ENDIF}
  if (ParamCount <> 0) then
  begin
    Writeln('BATT Version 09-FEB-2005  Show battery status'^M^J +
            'Copyright (c) 1997-2005 BTTR Software'^M^J +
            '[Under `MODIFIED'' BSD LICENSE]'^M^J +
            ^M^J +
            'Usage: BATT [/Help|/?]');
    Halt;
  end;
  if (apmcheck <> 0) then
  begin
    Writeln('BATT: no APM BIOS!');
    Halt(1);
  end;
  if (apmconnect <> 0) then
  begin
    Writeln('BATT: cannot connect APM interface!');
    Halt(1);
  end;
  if (getbattstat = 0) then
    printstate
  else
    Writeln('BATT: error reading battery status!');
  if (connst = 0) then  { if APM interface was disconnected on entry, }
    apmdisconnect;      { disconnect it now }
end.