Unit country;

Interface

Type
  str4 = String[4];

Function countryCode       : Byte;
Function currencySymbol    : str4;
Function dateFormat        : Word;
Function dateSeparator     : Char;
Function DecimalSeparator  : Char;
Function timeSeparator     : Char;
Function timeFormat        : Byte;
Function thousandSeparator : Char;


Implementation
Uses
  Dos;

Type
  countryInfoRecord = Record
    dateFormat     : Word;
    currency       : Array[1..5] of Char;
    thouSep,
    DecSep,
    dateSep,
    timeSep        : Array[1..2] of Char;
    currencyFormat,
    significantDec,
    timeForm       : Byte;
    CaseMapAddress : LongInt;
    dataListSep    : Array[1..2] of Char;
    reserved       : Array[1..5] of Word
  end;

Var
  countryRecord : countryInfoRecord;
  reg           : Registers;


Procedure getCountryInfo; { generic Dos call used by all Functions }

begin

  reg.AH := $38;
  reg.AL := 0;
  reg.DS := seg(countryRecord);
  reg.DX := ofs(countryRecord);
  msDos(reg)

end; { getCountryInfo }


Function countryCode : Byte; { returns country code as set in Config.Sys }

begin

  countryCode := reg.AL

end; { countryCode }

Function currencySymbol : str4; { returns currency symbol }
Var
  temp : str4;
  i    : Byte;

begin

  With countryRecord do
  begin
    temp := '';
    i := 0;
    Repeat
      Inc(i);
      if currency[i] <> #0 then temp := temp + currency
    Until (i = 5) or (currency[i] = #0)
  end;
  currencySymbol := temp

end; { currencySymbol }


Function dateFormat : Word;
{ 0 : USA    standard mm/dd/yy }
{ 1 : Europe standard dd-mm-yy }
{ 2 : Japan  standard yy/mm/dd }
begin

  dateFormat := countryRecord.dateFormat

end; { dateFormat }


Function dateSeparator : Char; { date separator Character }

begin

  dateSeparator := countryRecord.dateSep[1]

end; { dateSeparator }


Function DecimalSeparator : Char; { Decimal separator Character }

begin

  DecimalSeparator := countryRecord.DecSep[1]

end; { DecimalSeparator }


Function timeSeparator : Char; { time separator Character }

begin

  timeSeparator := countryRecord.timeSep[1]

end; { timeSeparator }


Function timeFormat : Byte; { am/pm = 0, 24-hour time = 1 }

begin

  timeFormat := countryRecord.timeForm

end; { timeFormat }


Function thousandSeparator : char; { thousands separator character }

begin

  thousandSeparator := countryRecord.thouSep[1]

end;



begin

  getCountryInfo

end. { Unit country }

