DECLARE SUB Mixer (K%)
'SJGPLAY: (C) Steve Gray

REM $INCLUDE: '.\SJGPLAY.BI'

 DIM LFlag(100), PFlag(100), Prg(101)
 
 Ver$ = "1.30 - Oct 10/97"

 SP$ = SPACE$(80): ESC$ = CHR$(27): ESCS$ = "ESC": Nul$ = CHR$(0): CR$ = CHR$(13)
 BCKSPC$ = CHR$(8): DD$ = CHR$(205): DL$ = STRING$(80, DD$): FF$ = CHR$(12)
 Ptr$ = CHR$(16): SPtr$ = CHR$(254): Joy$ = "p- + s mf     v"
 Editor$ = Msg$(100): CfgName$ = Msg$(101)
 
 MaxLyric = 500: FPS = 75: NoSync& = 999999
 track = 0: LastTrack = -1: TMode = 1: PCrsr = 1: PStp = 1: CRow = 1: AutoEd = 0
 Z = 128: Cmx = 30: Bar1 = 6: BWid = 4: GOSUB SetBWid
 
 IF COMMAND$ <> "!" THEN ON ERROR GOTO ErrorHandler
 RANDOMIZE TIMER

 IF Exists("sjgplay.msg") THEN C$ = Msg$(0)

100 IF IsMscdex = FALSE THEN PRINT Msg$(1): END
						  
 C$ = ENVIRON$("BLASTER"): P = INSTR(C$, "A")
 A = Dec("220"): IF P > 0 THEN A = Dec(MID$(C$, P + 1, 3))
 SBBase = A: WPort = A + 12: RPort = A + 10

 C$ = ENVIRON$("SJGPLAY"): IF C$ <> "" THEN Path$ = C$ ELSE Path$ = CURDIR$
 IF RIGHT$(Path$, 1) <> "\" THEN Path$ = Path$ + "\"

 FirstCD = GetFirstCdrom%: LastCD = FirstCD: NumCD = GetNumCdroms%
 cdu = FirstCD: IF NumCD > 1 THEN LastCD = FirstCD + NumCD - 1
 
 GOSUB InitConfig: ReadFont (""): CALL LoadConfig("")
 F$ = "sjgplay.fnt": IF Exists(F$) THEN ReadFont (F$)

 IF LEN(COMMAND$) > 3 THEN GOSUB ParseCmd

 MFlag = 0: N = Mouse(0): Row = 0: CALL MouseInfo(Row, Col, MB)
 CLS : IF Row <> 0 THEN MFlag = 1: N = Mouse(1)
 CALL FontEd(-1): CALL Calendar(-1): CALL Mixer(-1)
 Saver = 0: SSFlag = 0: KT! = TIMER
 SCREEN 0, 1, 1, 0: CLS : SCREEN 0, 1, 0, 0

110 CLS
 WTop = 4: HMode = 0 'IF Config(7) > 1 THEN HMode = 1
 GOSUB SetHeight
 
 Mode = Config(1): Full = 1 - Config(2): GOSUB TogFull
 
 COLOR 15, 0: BPrat WTop + WH \ 2 - 2, 22, 0, 0, Msg$(2)
 
 IF NumCD > 1 AND Config(5) > 0 THEN Prat 4, 1, Msg$(98): PRINT : GOSUB ScanUnits: SLEEP 1

 GOSUB SelectCD: VolP = 99: VCH = 0
 IF Config(10) > 0 THEN sbGetVolume Config(10), A, A: VolP = A * (100 / 15)
 GOSUB SetVol: GOSUB ShowTitles
 
 Z! = TIMER: N& = 0: WHILE (TIMER - Z!) < 1!: N& = N& + 1: WEND
 Delay = INT(N& / 50) 'Calc delay based on computer speed
 NumS = N& / 50

120 cdInit cdu, tlist(): track = 0: LastT = -1
 IF (cd.status AND CDPLAYING) <> CDPLAYING THEN cdSeek cdu, 1, tlist()

'== Main Loop
 DO
200 COLOR 7, 0
   IF (cd.status AND CDOPEN) = CDOPEN THEN IDnum$ = "": track = 1
   IF (cd.status AND CDCLOSED) = CDCLOSED THEN IF IDnum$ = "" THEN GOSUB GetNewCD
   
   K$ = UCASE$(INKEY$): GOSUB BlankCheck
   IF STRIG(1) + STRIG(3) + STRIG(5) + STRIG(7) < 0 THEN N = DoJoy: IF N > 0 THEN K$ = UCASE$(MID$(Joy$, N, 1))
'   N = STICK(0): IF N < 10 THEN K$ = Nul$ + CHR$(75)
'   IF N > 140 THEN K$ = Nul$ + CHR$(77)
'   N = STICK(1): IF N < 10 THEN K$ = Nul$ + CHR$(72)
'   IF N > 140 THEN K$ = Nul$ + CHR$(80)

   IF MFlag = 1 AND SSFlag = 0 THEN
     CALL MouseInfo(Row, Col, MB): N = Mouse(2)
     IF Mode = 1 AND Row >= WTop THEN GOSUB ShowTName
     IF Full = 0 AND Row = WTop + WH THEN GOSUB ShowSBTime
     IF MB > 0 THEN GOSUB DoMouse
     N = Mouse(1)
   END IF

   SELECT CASE LEN(K$)
     CASE 1: N = Mouse(2): GOSUB NormKey: N = Mouse(1)
     CASE 2: N = Mouse(2): GOSUB ExtKey: N = Mouse(1)
   END SELECT
210
   ShowStatus
   track = cd.track: IF track <> LastT THEN GOSUB GetStart
   IF TIME$ = Event$ OR INT(TIMER) = -TT! THEN GOSUB DoEvent
   IF RTime& > 0 THEN GOSUB DoDisplay
   IF (cd.status AND CDPLAYING) = CDPLAYING THEN
     IF Intro = 1 THEN GOSUB IntroChk
     IF PMode = 1 THEN GOSUB CheckPrg
     IF RMode > 0 THEN GOSUB CheckRpt
   ELSE
     IF Spin = 1 THEN GOSUB CheckStop
   END IF
   IF AutoEd = 1 THEN Mode = 2
   IF Fade THEN GOSUB Fader
220 GOSUB ShowMode: GOSUB ShowTrackNum: DispTime
   IF AutoEd = 1 THEN GOSUB Edit: AutoEd = 0
   LastT = track: LastMd = Mode: Ref = FALSE
 LOOP

'== Mouse Control
DoMouse:
 IF Col > 1 OR Mode = 1 OR Row < 4 THEN NoButtons
 IF Row = NumLines AND Col = 80 THEN K$ = "F": RETURN
 IF (MB AND 2) = 2 AND Row <> 3 THEN GOSUB NextMode: RETURN
 IF (MB AND 4) = 4 THEN GOSUB PrevMode: RETURN
 SELECT CASE Row
   CASE 1: GOSUB MRow1
   CASE 2: GOSUB MRow2
   CASE 3: GOSUB MRow3
   CASE WTop TO WTop + WH - 1: GOSUB MDisp
   CASE ITop TO NumLines: IF Full = 0 THEN GOSUB MInfo
 END SELECT
 RETURN

MRow1:
 SELECT CASE Col
   CASE 1: K$ = "Q"
   CASE 2 TO 7: GOSUB Eject
   CASE 8 TO 72: GOSUB EditCDTitle
   CASE ELSE: IF Full = 1 THEN K$ = "H" ELSE K$ = "Z"
 END SELECT
 RETURN

MRow2:
 SELECT CASE Col
   CASE 1 TO 7: K$ = "+"
   CASE 8 TO 72: GOSUB EditTrack
   CASE ELSE: IF (cd.status AND CDPLAYING) = CDPLAYING THEN K$ = "." ELSE K$ = "P"
 END SELECT
 RETURN

MRow3:
 IF (MB AND 2) = 2 THEN Col = 2
 SELECT CASE Col
   CASE 1: Mode = Mode - 1: GOSUB JumpMode
   CASE 2, 79
     BFlag = BFlag + 1: IF BFlag = 5 THEN BFlag = 0
     GOSUB ShowTitles: GOSUB SetRef
   CASE 80: Mode = Mode + 1: GOSUB JumpMode
   CASE ELSE: IF BFlag = 0 THEN GOSUB Pause ELSE GOSUB MKeys
 END SELECT
 RETURN

MKeys: Col = Col - 2: IF BFlag = 4 THEN RETURN
 K$ = MID$(MouseK$, Col, 1)
 IF BFlag = 1 AND Col > 3 THEN Mode = ((Col - 5) \ 6) + 1: GOSUB JumpMode: RETURN
 IF K$ = "@" THEN Col = Col + 1: GOTO MKeyExt
 IF Col < 2 THEN RETURN
 IF MID$(MouseK$, Col - 1, 1) = "@" GOTO MKeyExt
 IF Col < 3 THEN RETURN
 IF MID$(MouseK$, Col - 2, 1) = "@" THEN Col = Col - 1: GOTO MKeyExt
 RETURN

MKeyExt: K$ = Nul$ + CHR$(VAL(MID$(MouseK$, Col, 2))): RETURN

MDisp: Row = Row - WTop
 SELECT CASE Mode
   CASE 1: GOSUB DoPlayList
   CASE 2: GOSUB DoTrackList
   CASE 3: Mode = 4
   CASE 4: Mode = 3
   CASE 5: Mode = 6
   CASE 6: Mode = 5
   CASE 7: Mode = 8
   CASE 8: Mode = 7
   CASE 9: GOSUB DoConfig
   CASE 11: GOSUB DoCatalog
   CASE 15: CALL FontEd(-2)
   CASE 16: CALL Calendar(-2)
   CASE 17: CALL Mixer(-2)
   CASE ELSE: Mode = 1
 END SELECT
 IF Mode <> LastMd THEN GOSUB JumpMode
 RETURN

ShowTName: SRow = Row: SCol = Col
 Row = Row - WTop: GOSUB CalcPos: F$ = ""
 IF PMode = 0 THEN
   IF N <= NumT THEN F$ = Msg$(7) + STR$(N) + "; " + Song$(N)
 ELSE
   IF N <= NumPrg THEN F$ = Msg$(7) + STR$(Prg(N)) + "; " + Song$(Prg(N))
 END IF
 COLOR 7, 0: Prat WTop + WH - 1, 4, LEFT$(F$ + SP$, 70)
 Row = SRow: Col = SCol: RETURN

CalcPos:
 Col = Col - 3: IF Col < 1 OR Col > 74 THEN Col = 999
 Row = (Row \ 2): IF Row < 0 THEN Row = 0
 N = Row * 15 + INT(Col / 5) + 1: RETURN

ShowSBTime: IF Col < 2 OR Col > 79 THEN RETURN
 N& = NumF& * ((Col - 2) / 78)
 Min = INT(N& / 4500&): sec = (N& - Min * 4500&) / FPS
 LOCATE WTop + WH, 75: PRINT TimeStr$(Min, sec);
 RETURN

MInfo:
 Row = Row - ITop: IF Row = 0 THEN GOSUB JumpShut: RETURN
 IF Row = 4 AND Col < 59 THEN K$ = "F": RETURN
 SELECT CASE Col
   CASE 1 TO 5: K$ = "G"
   CASE 7 TO 11: K$ = "-"
   CASE 12 TO 17: K$ = "+"
   CASE 20 TO 26: IF Row < 3 THEN K$ = "T" ELSE K$ = "I"
   CASE 28 TO 39: K$ = "A"
   CASE 45 TO 56: K$ = "B"
   CASE 40 TO 44: K$ = "R"
   CASE 59 TO 80: GOSUB MInfo2
 END SELECT
 RETURN

JumpShut:
  SELECT CASE Col
    CASE 1: K$ = "-"
    CASE 80: K$ = "+"
    CASE ELSE: GOSUB CalcT: LLine = -1: GOSUB ShutAbs
  END SELECT
  RETURN

CalcT: N& = StartF& + (NumF& * ((Col - 2) / 78)): RETURN

MInfo2:
 SELECT CASE Row
   CASE 1: IF Col = 59 THEN K$ = "F"
   CASE 2: IF Col = 71 THEN K$ = "V": RETURN
   CASE 3
     SELECT CASE Col
       CASE 0 TO 64: K$ = "="
       CASE 65 TO 66: K$ = "["
       CASE 67 TO 69: K$ = "]"
       CASE ELSE: K$ = "R"
     END SELECT
   CASE 4: IF Col < 65 THEN K$ = "H" ELSE K$ = "M"
 END SELECT
 RETURN

DoPlayList:
 IF Col = 1 AND PMode = 1 THEN
   IF Row = 0 THEN K$ = Nul$ + CHR$(75): RETURN
   IF Row = 1 THEN K$ = Nul$ + CHR$(77): RETURN
 END IF
 GOSUB CalcPos
 IF PMode = 0 THEN
    IF N <= NumT THEN track = N
 ELSE
    IF N <= NumPrg THEN PStp = N: track = Prg(PStp)
 END IF
 IF track <> LastT THEN RTrack = track: GOSUB PlayTrack
 RETURN

DoTrackList:
 IF Col = 1 THEN
   IF Row = 0 THEN Top = Top - 1 ELSE Top = Top + 1
   GOSUB ShowTrackP2
 ELSE
   N = Top + Row: IF N > NumT THEN RETURN
   IF Col > 13 THEN STrack = N: GOSUB EditCD2: RETURN
   IF PMode = 0 THEN track = N: GOSUB PlayTrack ELSE V = N: GOSUB InsStep: Ref = TRUE
 END IF
 RETURN

DoCatalog:
 IF Col = 1 THEN
   IF Row < 1 THEN K$ = Nul$ + CHR$(72) ELSE K$ = Nul$ + CHR$(80)
 ELSE
   IF Col < 22 THEN GOSUB SortCat ELSE K$ = "\"
 END IF
 RETURN

DoConfig:
 IF Row = WH - 1 THEN K$ = "W": RETURN
 IF Row < 2 OR Row > 15 THEN RETURN
 CRow = Row - 1: K$ = Nul$ + CHR$(1)
 IF Col = 64 THEN K$ = Nul$ + CHR$(75)
 IF Col = 65 THEN K$ = Nul$ + CHR$(77)
 RETURN

'== Keyboard Control
NormKey:
 SELECT CASE K$
   CASE "A": RMode = 5: RLine = LLine: GOSUB RepeatMode
   CASE "B": IF RMode = 5 OR RMode = 6 THEN RMode = 6: GOSUB RepeatMode
   CASE "C": GOSUB ClearPrg
   CASE "D": GOSUB Display
   CASE "E": GOSUB Edit
   CASE "F": GOSUB TogFull
   CASE "G": GOSUB TogPrgMode
   CASE "H": GOSUB DoHelp
   CASE "I": GOSUB IntroTog
   CASE "J": GOSUB ShufflePrg
   CASE "L": GOSUB GetNewCD: GOSUB SetRef: PMode = 1
   CASE "M", CHR$(9): GOSUB NextMode
   CASE "O": Mode = 13: GOSUB JumpMode
   CASE "P", CR$: GOSUB PlayTrack: RTrack = track
   CASE "Q": GOSUB AskQuit
   CASE "R": GOSUB NextRepeat
   CASE "S", ".": GOSUB StopPlay
   CASE "T": TMode = TMode + 1: IF TMode = 7 THEN TMode = 1
      GOSUB ShowModes: IF Mode = 2 THEN Ref = TRUE
   CASE "U": Mode = 12: GOSUB JumpMode
   CASE "V": HMode = 1 - HMode: GOSUB SetHeight: IF MFlag = 1 THEN N = Mouse(0): N = Mouse(1)
   CASE "W": GOSUB WSave
   CASE "X": GOSUB Eject
   CASE "Y": IF TT! = 0 THEN TT! = TIMER ELSE TT! = 0
   CASE "Z": GOSUB SetEvent
   CASE "0" TO "9": GOSUB JumpTrack
   CASE "+": GOSUB NextTrack
   CASE "-": GOSUB PrevTrack
   CASE " ": GOSUB Pause
   CASE BCKSPC$: GOSUB BackSpace
   CASE "`": Mode = 14: GOSUB JumpMode
   CASE "~": cdReset cdu: GOSUB SetRef
   CASE "!": IF IDnum$ <> "" THEN GOSUB NameCD
   CASE "@": GOSUB Ren0CD
   CASE "#": GOSUB ExtractLyrics
   CASE "$": MakeAlbum
   CASE "%": GOSUB TapeDub
   CASE "^": GOSUB LyricPrg
   CASE "&": GOSUB ImportLyric
   CASE "*": GOSUB SaveAs
   CASE "(": A$ = Msg$(78): C$ = Msg$(80): GOSUB ZipIt
   CASE ")": A$ = Msg$(77): C$ = Msg$(79): GOSUB ZipIt
   CASE "<": IF cdu > FirstCD THEN cdu = cdu - 1: GOSUB SelectCD
   CASE ">": IF cdu < LastCD THEN cdu = cdu + 1: GOSUB SelectCD
   CASE "[": GOSUB VolDown
   CASE "]": GOSUB VolUp
   CASE "=": GOSUB VolMute
   CASE "/", "\": GOSUB TogOption
   CASE "?": GOSUB Printer
   CASE "|": Col = 2: GOSUB MRow3
   CASE ",": LTime& = TIMER - RTime&
   CASE "{": A = -5: GOSUB SetNums
   CASE "}": A = 5: GOSUB SetNums
   CASE ";": A = -1: GOSUB SetBar
   CASE "'": A = 1: GOSUB SetBar
   CASE CHR$(34): A = 1: GOSUB SetBWid
   CASE ":": A = -1: GOSUB SetBWid
 END SELECT
 RETURN

TogOption:
  IF Mode = 11 THEN
    CatMode = CatMode + 1: IF CatMode = 4 THEN CatMode = 0
    LyricTrack = -1: GOSUB SetRef
  END IF
  RETURN

SetNums:
 IF Mode = 8 THEN GOSUB SetScope: RETURN
 NumS = NumS + (A * 5): IF NumS < 10 THEN NumS = 10
 A = 0: RETURN

SetBWid: IF Mode = 8 THEN A = -Delay: GOSUB SetScope: RETURN
 BWid = BWid + A: IF BWid < 2 THEN BWid = 2
 IF BWid > 15 THEN BWid = 15
 A = 0

SetBar:
 Bar1 = Bar1 + A: IF Bar1 < 1 THEN Bar1 = 1
 IF Bar1 > 200 THEN Bar1 = 200
 Bar2 = Bar1 + INT((76 - BWid) / BWid): IF Bar2 > 127 THEN Bar2 = 127
 GOSUB SetRef: RETURN

SetScope:
 IF K$ = CHR$(34) THEN Slow = 1 - Slow: RETURN
 Delay = Delay + A: IF Delay < 0 THEN Delay = 0
 RETURN

ExtKey:
 K = ASC(RIGHT$(K$, 1))
 IF Mode = 15 THEN FontEd (K): RETURN
 SELECT CASE K
   CASE 15: GOSUB PrevMode: RETURN
   CASE 59 TO 69: Mode = K - 58: RTime& = 0: GOSUB JumpMode: RETURN
   CASE 133, 134: Mode = K - 122: RTime& = 0: GOSUB JumpMode: RETURN
   CASE 115, 155: GOSUB ShutRew
   CASE 116, 157: GOSUB ShutFF
   CASE 152: GOSUB Pause
   CASE 160: GOSUB PlayTrack
   CASE 88 TO 90: N = K - 88: GOSUB AltNum
   CASE 123 TO 128: N = K - 120: GOSUB AltNum
   CASE 82
     IF Mode = 11 THEN GOSUB SortCat
     IF Mode = 7 OR Mode = 8 THEN IMode = 1 - IMode: ClrWin ""
   CASE 83: GOSUB DelKey
   CASE 18: Mode = 15: GOSUB JumpMode: RETURN 'alt-e
   CASE 46: CALL Calc 'alt-c
   CASE 32: Mode = 16: GOSUB JumpMode 'alt-d
   CASE 31: Mode = 17: GOSUB JumpMode 'alt-s
   CASE 45: GOSUB QuitNow 'alt-x
   CASE 50 'alt-m
     ClrWin Msg$(104): IF GetYN$ = "Y" THEN A$ = Msg$(0) ELSE A$ = Msg$(-1)
     GOSUB SetRef: GOSUB ShowTitles
   CASE 33 'alt-f
     ClrWin Msg$(105): IF GetYN$ = "Y" THEN ReadFont ("sjgplay.fnt") ELSE ReadFont ("")
   CASE 48 'alt-b
     Saver = Saver + 2: IF Saver > 30 THEN Saver = 0
     ClrWin "Blank: " + STR$(Saver) + " min": KT! = TIMER: SLEEP 1
   CASE 26: Fade = -1: MaxVol = VolP: FadeTime! = TIMER
   CASE 27: Fade = 1: : FadeTime! = TIMER
'   CASE ELSE: Prat 1, 1, STR$(K)
 END SELECT
 SELECT CASE Mode
   CASE 1: IF PMode = 1 THEN GOSUB ExtPrg ELSE GOSUB ExtTrk
   CASE 9: GOSUB ExtCfg
   CASE 11: GOSUB ExtCat
   CASE 16: CALL Calendar(K)
   CASE 17: CALL Mixer(K)
   CASE ELSE: GOSUB ExtTrk
 END SELECT
 RETURN

AltNum:
 IF Jump$ = "0" THEN
   ClrWin Msg$(102) + STR$(N + 1)
   F$ = "mcdtray " + CHR$(65 + cdu) + " " + CHR$(49 + N)
   SHELL (F$): GOSUB SelectCD
 ELSE
   IF N < NumCD THEN cdu = FirstCD + N: GOSUB SelectCD
 END IF
 RETURN

DelKey:
 SELECT CASE Mode
   CASE 1: IF PMode = 1 THEN IF PCrsr <= NumPrg THEN GOSUB DelStep
   CASE 2: GOSUB DelCD
   CASE 3, 4: GOSUB DelLyric
   CASE 11
     N = 12: IF CatMode <> 1 THEN N = 8
     F$ = Path$ + MID$(Lyric$(Top), 6, N): K$ = MID$(Lyric$(Top), 20)
     IF CatMode <> 1 THEN GOSUB DelCDI ELSE GOSUB DelLyricI
 END SELECT
 RETURN

ExtTrk: N& = 0
 SELECT CASE K
   CASE 75: GOSUB ShutRew
   CASE 72: GOSUB ShutRew2
   CASE 73: GOSUB ShutRew3
   CASE 77: GOSUB ShutFF
   CASE 80: GOSUB ShutFF2
   CASE 81: GOSUB ShutFF3
   CASE 71: GOSUB ShutHome
   CASE 79: GOSUB ShutEnd
 END SELECT
 RETURN

'---- Track Shuttle
ShutFF: N& = Config(9) * FPS: GOTO Shuttle
ShutFF2: N& = Config(9) * FPS * 4: GOTO Shuttle
ShutFF3: N& = 60 * FPS: LLine = -1: GOTO Shuttle

ShutRew: N& = -Config(9) * FPS: LLine = -1: GOTO Shuttle
ShutRew2: N& = Config(9) * FPS * -4: LLine = -1: GOTO Shuttle
ShutRew3: N& = -60 * FPS: LLine = -1: GOTO Shuttle

ShutHome: N& = tlist(track).absframe: LLine = -1: GOTO ShutAbs
ShutEnd:
 N& = TotF&: IF track < NumT THEN N& = tlist(track + 1).absframe
 N& = N& - Config(9) * 150: LLine = -1: GOTO ShutAbs

Shuttle: N& = cd.frame + N&: IF N& < 1 THEN N& = 1
ShutAbs: R& = TotF& - N&
 cdPause cdu: cdPlayFrames cdu, N&, R&: cd.status = 5: RETURN

'---- Cursor Programming
ExtPrg:
 LastT = -1
 SELECT CASE K
   CASE 72: PCrsr = PCrsr - 15
   CASE 75: PCrsr = PCrsr - 1
   CASE 77: PCrsr = PCrsr + 1
   CASE 80: PCrsr = PCrsr + 15
   CASE 71: PCrsr = -1
   CASE 79: PCrsr = 100
   CASE ELSE: LastT = track
 END SELECT
 IF PCrsr < 1 THEN PCrsr = 1
 IF PCrsr > NumPrg + 1 THEN PCrsr = NumPrg + 1
 RETURN

ExtCfg: Ref = TRUE
 SELECT CASE K
   CASE 1:
   CASE 72: CRow = CRow - 1
   CASE 80: CRow = CRow + 1
   CASE 71: CRow = 1
   CASE 79: CRow = 14
   CASE 75: Config(CRow) = Config(CRow) - 1
   CASE 77: Config(CRow) = Config(CRow) + 1
   CASE ELSE: Ref = FALSE
 END SELECT
 IF CRow < 1 THEN CRow = 14
 IF CRow > 14 THEN CRow = 1
 RETURN

ExtCat: Ref = TRUE
 SELECT CASE K
   CASE 71: Top = 1
   CASE 72: Top = Top - 1
   CASE 73: Top = Top - WH
   CASE 80: Top = Top + 1
   CASE 81: Top = Top + WH
   CASE 79: Top = LyricLines
   CASE ELSE: Ref = FALSE
 END SELECT
 IF Top < 1 THEN Top = 1
 IF Top > LyricLines THEN Top = LyricLines
 RETURN

'== Quit
AskQuit:
  ClrWin Msg$(20)
  IF GetYN$ <> "Y" THEN RETURN
QuitNow:
  IF Config(6) = 1 THEN GOSUB StopTrack
  IF Config(6) = 2 THEN GOSUB Eject
  N = Mouse(2): COLOR 7, 0: CLS : END

'== Mode Stuff
ShowMode:
  IF Mode <> LastMd THEN COLOR 7, 0: ClrWin ""
  SELECT CASE Mode
    CASE 0: GOSUB ShowHelp
    CASE 1: GOSUB ShowProg
    CASE 2: GOSUB ShowTrackList
    CASE 3: GOSUB ShowLyrics
    CASE 4: GOSUB ShowKaraoke
    CASE 5: GOSUB ShowSongName
    CASE 6: GOSUB ShowCDName
    CASE 7: GOSUB ShowFreq
    CASE 8: GOSUB ShowScope
    CASE 9: GOSUB ShowConfig
    CASE 10: Author (Ver$)
    CASE 11: GOSUB ShowCat
    CASE 12: GOSUB ShowUtil
    CASE 13: GOSUB ShowTimer
    CASE 14: GOSUB ShowUnits
    CASE 15: IF Ref = TRUE THEN CALL FontEd(0)
    CASE 16
      IF Ref = TRUE THEN CALL Calendar(0)
      IF Full = 1 THEN COLOR 5, 0: BPrat NumLines - 4, -2, 0, 0, TIME$
    CASE 17: IF Ref = TRUE THEN Mixer (0)
  END SELECT
  RETURN

PrevMode:
  Mode = Mode - 1: IF Mode < 1 THEN Mode = 8
  GOSUB JumpMode: RETURN
NextMode:
  IF Mode = 0 THEN Mode = SMode - 1
  Mode = Mode + 1: IF Mode > 8 THEN Mode = 1
JumpMode:
  IF Mode < 0 THEN Mode = 12
  IF Mode > 17 THEN Mode = 0
  IF Mode <> 3 AND Mode <> 4 THEN LLine = -1
  IF (Mode = 3 OR Mode = 4) AND LyricTrack = -2 THEN LyricTrack = -1: LLine = -1
  Jump$ = "": ClrWin ""
  N = Mouse(2): GOSUB ShowModes: N = Mouse(1): IF BFlag = 1 THEN GOSUB ShowMMode
  RETURN

SetHeight:
    NumLines = 25: F$ = LF1$
    IF HMode = 1 THEN
       IF Config(7) = 1 THEN NumLines = 43: F$ = LF2$
       IF Config(7) = 2 THEN NumLines = 50: F$ = LF2$
    END IF
    
666 WIDTH 80, NumLines: IF F$ <> "" THEN SHELL (F$)
    ITop = NumLines - 4: WH = NumLines - WTop - (4 * (1 - Full))
667 GOSUB SetRef: GOSUB ReDrawAll: RETURN

TogFull:
 SELECT CASE Full
   CASE 0: Full = 1: WH = NumLines - WTop + 1: ClrWin ""
   CASE 1: ClrWin "": Full = 0: WH = NumLines - WTop - 4
 END SELECT
 LastT = -1: GOSUB SetRef: GOSUB ReDrawAll: RETURN

'== Track Control
NextTrack:
  IF PMode = 1 THEN
    PStp = PStp + 1: IF PStp > NumPrg THEN PStp = 1
    track = Prg(PStp)
  ELSE
    track = track + 1: IF track > NumT THEN track = 1
  END IF
  GOSUB MoveTrack: RTrack = track: RETURN

PrevTrack:
  IF PMode = 0 THEN
    IF track > 1 THEN track = track - 1 ELSE track = NumT
  ELSE
    IF PStp > 1 THEN PStp = PStp - 1 ELSE PStp = NumPrg
    track = Prg(PStp)
  END IF
  GOSUB MoveTrack: RTrack = track: RETURN

MoveTrack:
  IF (cd.status AND CDPLAYING) <> CDPLAYING THEN
    cdStop cdu: cdSeek cdu, track, tlist()
    cdPlay cdu, track, 99, tlist(): cdStop cdu
  ELSE
    GOSUB PlayTrack
  END IF
  IF Mode <> 2 THEN Ref = TRUE
  Jump$ = "": RETURN

JumpTrack:
  Jump$ = Jump$ + K$: V = VAL(Jump$): GOSUB ShowJmp
  IF LEN(Jump$) = 1 AND V * 10 > NumT THEN GOSUB ClearJmp
  IF LEN(Jump$) < 2 THEN RETURN
  IF V >= 0 AND V <= NumT THEN
    IF (PMode = 1) THEN
      GOSUB InsStep: Ref = TRUE
    ELSE
      track = V: GOSUB PlayTrack: RTrack = track
    END IF
  END IF

ClearJmp: Jump$ = "": Prat NumLines, 1, "   ": RETURN
ShowJmp: IF Jump$ = "" THEN GOSUB ClearJmp: RETURN
  COLOR 31, 0: Prat NumLines, 1, LEFT$(Jump$ + "?", 2): RETURN

BackSpace:
  IF Jump$ <> "" THEN Jump$ = "": GOSUB ShowJmp: RETURN
  IF PMode = 1 AND PCrsr > 1 THEN PCrsr = PCrsr - 1: GOSUB DelStep
  RETURN

Pause:
  IF (cd.status AND CDPAUSED) = CDPAUSED THEN cdResume cdu: RETURN
  IF (cd.status AND CDPLAYING) = CDPLAYING THEN cdPause cdu: RETURN

StopPlay:
  IF (cd.status AND CDPLAYING) = CDPLAYING THEN GOSUB StopTrack: RETURN
  IF PMode = 0 THEN track = 1 ELSE track = Prg(1): PStp = 1
  GOSUB MoveTrack: GOSUB SetRef
  RETURN

StopTrack:
  cdStop cdu: RMode = 0: Ref = TRUE: Spin = 0: track = 0: LLine = 0: LyricTop = 0
  RETURN

PlayTrack:
  Ref = TRUE: LastT = -1: LLine = -1
  IF track > NumT THEN track = NumT
  IF track = 0 THEN
    GOSUB Pause
  ELSE
    cdPlay cdu, track, 99, tlist(): Spin = 1
  END IF
  cdGetInfo cdu, 0, cd, tlist()

GetStart:
290 IF NumT < 1 THEN RETURN
  StartF& = tlist(track).absframe: LastTop = 0: Ref = TRUE
  IF track = NumT THEN EndFrame& = TotF& ELSE EndFrame& = tlist(track + 1).absframe
  NumF& = EndFrame& - StartF&: RETURN

'== CD Control
Eject:
  IF (cd.status AND CDOPEN) = CDOPEN THEN cdDoor cdu, 2: RETURN
  GOSUB StopTrack: cdDoor cdu, 1: IDnum$ = "": RETURN

ScanUnits:
  FOR J = FirstCD TO LastCD
    cdInit J, tlist(): cdGetInfo J, 0, cd, tlist()
    GOSUB MakeIDNum: GOSUB ReadCDFile: IF J = cdu THEN COLOR 15 ELSE COLOR 7
    PRINT J - FirstCD + 1; "("; CHR$(65 + J); ":) "; IDnum$; " > "; CDTitle$
    IF Mode <> 14 THEN IF (cd.status AND CDPLAYING) = CDPLAYING THEN cdu = J: EXIT FOR
  NEXT J
  RETURN

SelectCD: Drv$ = CHR$(65 + cdu): GOSUB ShowTitles
GetNewCD:
300 track = 0: LLine = 0: LyricTop = 0: Jump$ = ""
  IF IsAudio(cdu) <> 1 THEN
    Spin = 0: cd.track = 0: IDnum$ = "": RETURN
    IF RMode = 4 THEN RMode = 0
  END IF
  LyricTrack = -1
  IF Full = 0 THEN COLOR 7 + 16, 0: BPrat ITop + 1, -7, 19, 0, "--": BPrat ITop + 1, -28, 58, 0, "--:--"
  GOSUB SetRef: Top = 1: LyricTop = 1: LastT = -1: LLine = -1
  GOSUB GetNewCDInfo: GOSUB ShowTitles
  IF PMode = 0 THEN track = 1 ELSE track = Prg(1): PStp = 1
  IF (cd.status AND CDPLAYING) = CDPLAYING THEN Spin = 1: RETURN
  IF Config(5) = 0 THEN RETURN
  IF Config(5) = 2 THEN GOSUB ShufflePrg
  GOSUB PlayTrack: RETURN

GetNewCDInfo:
400 cdInit cdu, tlist(): cdGetInfo cdu, 0, cd, tlist()
  track = cd.track: GOSUB MakeIDNum
  PMode = 0: PCrsr = 1: PStp = 1: Ref = TRUE
  LLine = -1: IF Mode <> 7 THEN LyricTrack = -1
  GOSUB ReadCDFile: GOSUB ChkLyricTrks: IF RMode <> 4 THEN GOSUB SetInitR
  AlbumF = 0: F$ = Path$ + "CD" + IDnum$ + ".ALB"
  IF Exists(F$) = 1 THEN AlbumF = 1: GOSUB CheckAlbTracks
410 RETURN

MakeIDNum:
  NumT = UBOUND(tlist)
  TotF& = cd.cdFrames + (cd.cdMins * 60 + cd.cdSecs) * 75&
  IDnum$ = MID$(STR$(1000000 + TotF&), 3, 6)
  'RETURN

MakeXMCDid:
  CS1& = 0: CS2& = 0: CT2& = 0
  FOR A = 1 TO NumT
    F& = tlist(A).absframe: IF A = NumT THEN F2& = TotF& ELSE F2& = tlist(A + 1).absframe
    X& = F2& - F&: FrameToMSF X&, mins, secs, frames
    CT1& = mins * 60 + secs + (frames / 75): CT2& = CT2& + CT1&
    CS1& = CS1& + CT1&: CS2& = CS2& + (CT2& + 1)
  NEXT A
  XMCD$ = HEX$(((CS2& - 1) MOD 256)) + " " + HEX$(CS1& - 1) + " " + HEX$(NumT)
  RETURN

ChkLyricTrks:
420 FOR A = 1 TO 100: LFlag(A) = 0: NEXT
 IF Song$(1) = "Track 1" OR IDnum$ = "" THEN RETURN
 F$ = Path$ + "CD" + IDnum$ + ".T??": K$ = DIR$(F$)
 DO WHILE K$ <> ""
   A = VAL(RIGHT$(K$, 2)): IF A > 0 AND A <= NumT THEN LFlag(A) = 1
   K$ = DIR$
 LOOP
 RETURN

'== Repeat Modes
NextRepeat: RMode = RMode + 1: IF RMode = 4 AND NumCD = 1 THEN RMode = 0
 IF RMode = 5 THEN RMode = 0
RepeatMode:
  SELECT CASE RMode
    CASE 1, 2: RTrack = track 'One/Single
    CASE 5: RepeatA& = cd.frame
    CASE 6: RepeatB& = cd.frame: R& = TotF& - RepeatA&
    CASE 7: RMode = 0
  END SELECT
  GOSUB ShowModes: RETURN

SetInitR:
 RMode = Config(11): IF RMode < 0 OR RMode > 3 THEN RMode = 0
 RETURN

CheckRpt:
  SELECT CASE RMode
    CASE 1: IF track <> RTrack THEN track = RTrack: GOSUB PlayTrack: cdGetInfo cdu, 0, cd, tlist()
    CASE 2: IF track <> RTrack THEN cdStop cdu: Spin = 0
    CASE 6
      IF cd.frame > RepeatB& THEN
	cdStop cdu: cdPlayFrames cdu, RepeatA&, R&
	IF RLine > 0 THEN LLine = RLine - 1: LyricTop = RLine: Ref = TRUE
      END IF
  END SELECT
  RETURN

CheckStop:
  IF (cd.status AND CDPAUSED) = CDPAUSED THEN RETURN
  IF RMode = 4 AND PMode = 0 THEN GOSUB DriveRepeat: RETURN
  IF PMode = 0 THEN
    IF RMode = 0 THEN Spin = 0: RETURN
    IF RMode = 3 THEN track = 1
    GOSUB PlayTrack
  ELSE
    IF RMode <> 1 THEN PStp = PStp + 1
    IF PStp > NumPrg THEN
      PStp = 1: IF RMode = 0 THEN Spin = 0: RETURN
    END IF
    track = Prg(PStp): GOSUB PlayTrack
  END IF
  RETURN

DriveRepeat:
  cdu = cdu + 1: IF cdu > LastCD THEN cdu = FirstCD
  GOSUB SelectCD: GOSUB PlayTrack: RETURN

IntroTog: Intro = 1 - Intro: GOSUB ShowModes: RETURN
IntroChk:
  IF cd.frame < StartF& THEN RETURN
  IF EFrame& < Config(8) * FPS THEN RETURN
  IF RMode = 1 THEN GOSUB PlayTrack ELSE GOSUB NextTrack
  RETURN

Fader:
 IF (TIMER - FadeTime!) < .1 THEN RETURN
 FadeTime! = TIMER: VolP = VolP + Fade * 2
 IF VolP < 1 OR VolP > MaxVol THEN Fade = 0 ELSE GOSUB SetVol
 RETURN

VolUp: VolP = VolP + 2: GOTO SetVol
VolDown: VolP = VolP - 2: GOTO SetVol
VolMute:
  IF VSave = 0 THEN VSave = VolP: VolP = 0: GOTO SetVol
  VolP = VSave: VSave = 0

SetVol: GOSUB SetVol2: GOSUB ShowModes: RETURN
SetVol2:
  IF VolP < 0 THEN VolP = 0
  IF VolP > 99 THEN VolP = 99
  SELECT CASE Config(10)
    CASE 0: GOSUB SetCDV
    CASE 1: S = 1: GOSUB SetSBV
    CASE 2: S = 2: GOSUB SetSBV
  END SELECT
  IF Mode = 17 THEN Mixer (0)
  RETURN

SetCDV: A = VolP * 2.55: cdSetVolume cdu, (A), (A), (A), (A): RETURN

SetSBV: IF IsSB THEN A = VolP / 6.6: sbSetVolume S, (A), (A)
 RETURN

'== Misc
SetEvent:
  IF Event$ = "" THEN Event$ = TIME$
  ClrWin Msg$(21)
  Prat WTop + 5, 2, Msg$(22)
  Prat WTop + 6, 2, Msg$(23)
  Event$ = SuppIn(WTop + 8, 2, 8, Msg$(24), Event$)
  IF CF$ = ESCS$ OR Event$ = "" THEN RETURN
  EventMsg$ = SuppIn(WTop + 10, 2, 60, Msg$(25), EventMsg$)
  EventTrk = VAL(SuppIn(WTop + 11, 2, 2, Msg$(26), STR$(EventTrk)))
  EventMd = VAL(SuppIn(WTop + 12, 2, 2, Msg$(27), STR$(EventMd)))
  IF EventMd < 0 OR EventMd > 12 THEN EventMd = 0
  IF VAL(Event$) < 0 THEN TT! = -(INT(TIMER) - VAL(Event$)): Mode = 13: GOSUB JumpMode
  RETURN

DoEvent:
  IF EventTrk > 0 THEN track = EventTrk: GOSUB PlayTrack
  IF EventTrk < 0 THEN GOSUB StopTrack
  IF EventMd > 0 THEN Mode = EventMd: GOSUB ShowModes
  IF EventMsg$ <> "" THEN ClrWin EventMsg$: IF TT! > 0 THEN SLEEP 5 ELSE SLEEP 1
  GOSUB SetRef: Event$ = "": RETURN

Display:
  ClrWin Msg$(28)
  Prat WTop + 6, 2, Msg$(29)
  RTime& = VAL(SuppIn(WTop + 9, 2, 5, Msg$(30), STR$(RTime&)))
  IF CF$ = ESCS$ OR RTime& < 1 THEN RTime& = 0: RETURN
  RDisp$ = UCASE$(SuppIn(WTop + 10, 2, 50, Msg$(31), RDisp$))
  IF LEN(RDisp$) < 2 THEN RTime& = 0
  LTime& = 0: RETURN

DoDisplay:
  IF TIMER - LTime& < RTime& OR IDnum$ = "" THEN RETURN
  LTime& = TIMER: RNum = RNum + 1: IF RNum > LEN(RDisp$) THEN RNum = 1
  N = ASC(MID$(RDisp$, RNum, 1)) - 48: IF N < 0 THEN RETURN
  IF N > 9 THEN N = N - 7 'IF N > 16 THEN RETURN
  Mode = N: LLine = -1: GOSUB JumpMode: RETURN

BlankCheck: IF Saver = 0 THEN RETURN
 IF SSFlag = 0 THEN
   IF (TIMER - KT!) > (Saver * 60) THEN SCREEN 0, 1, 0, 1: SSFlag = 1: DTime! = 0
 ELSE
   IF (TIMER - DTime!) > 4 THEN
     SCREEN 0, 1, 1, 1: CLS : LOCATE RND(1) * (NumLines - 2) + 1, RND(1) * 65 + 1
     mins% = cd.TrackMin: secs% = cd.TrackSec
     PRINT track; "- "; TimeStr$(mins%, secs%)
     SCREEN 0, 1, 0, 1: DTime! = TIMER
   END IF
   DEF SEG = 64
   IF K$ <> "" OR (PEEK(23) AND 31) > 0 THEN
     SCREEN 0, 1, 0, 0: KT! = TIMER: SSFlag = 0: K$ = ""
   END IF
 END IF
 IF K$ <> "" THEN KT! = TIMER
 RETURN

SetRef: Ref = TRUE: LastMd = -1: LastTop = -1: RETURN

'== Utils
ShowUtil:
  F& = cd.frame: Prat 4, 50, Msg$(32): PRINT USING "###   "; F& - LastF&;
  Prat 5, 50, "XMCD ID= " + XMCD$
  LastF& = F&: IF Mode = LastMd THEN RETURN
  ClrWin "": Utils
  IF Event$ <> "" THEN
    CPrat WTop + 16, 20, Msg$(33) + Event$ + Msg$(34) + STR$(EventTrk) + Msg$(35) + STR$(EventMd)
  END IF
  RETURN

ShowTimer:
  NN! = 0
  IF TT! > 0 THEN NN! = TIMER - TT!
  IF TT! < 0 THEN NN! = -(TT! + TIMER)
  mins% = NN! \ 60: secs% = NN! - mins% * 60
  COLOR 14: BPrat 5, 52, 0, 0, TimeStr$(mins%, secs%)
  IF Ref = FALSE THEN RETURN
  IF TT! >= 0 THEN ClrWin Msg$(37) ELSE ClrWin Msg$(38)
  RETURN

ShowUnits:
 IF Ref = FALSE THEN RETURN
 ClrWin Msg$(103)
 GOSUB ScanUnits: GOSUB GetNewCDInfo: Ref = FALSE
 RETURN

NameCD:
 ClrWin Msg$(40)
 Prat WTop + 6, 2, Msg$(41)
 Prat WTop + 7, 2, Msg$(42)
 Prat WTop + 9, 2, Msg$(43)
 Prat WTop + 11, 28, Msg$(44)
 F$ = "": F$ = SuppIn(WTop + 15, 2, 8, Msg$(45), "")
 IF CF$ = "" AND F$ <> "" THEN GOSUB RenameIt
 GOSUB SetRef: RETURN

Ren0CD: F$ = "CD000000"
RenameIt: LOCATE 4, 1: SHELL "ren " + Path$ + F$ + ".* CD" + IDnum$ + ".*"
  GOSUB GetNewCD: RETURN

ExtractLyrics:
  Mode = 3: GOSUB JumpMode: GOSUB SetRef
  ClrWin Msg$(46)
  Prat WTop + 7, 2, Msg$(47)
  F$ = "": S$ = Song$(track)
  F$ = SuppIn(WTop + 12, 2, 40, Msg$(48), ""): IF F$ = "" THEN RETURN
  S$ = SuppIn(WTop + 13, 2, 60, Msg$(49), S$)
  S$ = UCASE$(S$): IF F$ = "" OR S$ = "" OR Exists(F$) = 0 THEN RETURN
  GOSUB ClearLyrics: LLine = 2
  Lyric$(1) = Msg$(50)
  OPEN F$ FOR INPUT AS 1: Found = 0
  DO WHILE NOT EOF(1) AND Found = 0
    LINE INPUT #1, A$
    IF INSTR(UCASE$(A$), "@SONG:") > 0 THEN GOSUB CheckExtName
  LOOP
  CLOSE 1
  LyricLines = LLine: LastMd = -1: Mode = 3: LLine = 1: Top = 1
  GOSUB SetRef: GOSUB ShowModes: IF Found = 0 THEN RETURN
  LyricTrack = -1: RETURN

CheckExtName:
  LLine = LLine + 1: Lyric$(LLine) = A$
  IF INSTR(UCASE$(A$), S$) = 0 THEN RETURN
  ClrWin "Extracting..."
  GOSUB ExtractSong: GOSUB SaveLyr
  RETURN

ExtractSong:
  GOSUB ClearLyrics: C = 0: LastSync& = 0
  DO WHILE NOT EOF(1) AND C < MaxLyric
    LINE INPUT #1, A$: IF INSTR(UCASE$(A$), "@SONG:") > 0 THEN EXIT DO
    IF LEFT$(A$, 1) <> ";" THEN GOSUB AddLyric
  LOOP
  LyricLines = C: LFlag(track) = 1: LLine = -1: Found = 1: SLEEP 1: RETURN

ImportLyric:
  ClrWin Msg$(60)
  Prat WTop + 7, 2, Msg$(61)
  F$ = SuppIn(WTop + 14, 2, 40, Msg$(62), ""): IF F$ = "" THEN RETURN
  K$ = Path$ + "CD" + IDnum$ + ".T" + RIGHT$(STR$(100 + track), 2)
  LLine = -2: LastMd = -1: LyricTrack = -1
  LOCATE 4, 1: SHELL "copy " + F$ + " " + K$: RETURN

SaveAs:
  IF LyricLines < 2 THEN RETURN
  ClrWin Msg$(63)
  Prat WTop + 7, 2, Msg$(64)
  F$ = SuppIn(WTop + 14, 2, 40, Msg$(65), ""): IF F$ = "" THEN RETURN
  SaveLyrics (F$): RETURN

DelLyric:
  IF IDnum$ = "" THEN RETURN
  K$ = Song$(track): F$ = Path$ + "CD" + IDnum$ + ".T" + RIGHT$(STR$(100 + track), 2)
DelLyricI: IF Exists(F$) = 0 THEN RETURN
  ClrWin Msg$(66)
  CPrat WTop + 7, 2, Msg$(67): PRINT K$
  CPrat WTop + 8, 2, Msg$(68): PRINT F$
  CPrat WTop + 10, 2, Msg$(70)
  IF GetYN$ = "Y" THEN LOCATE 4, 1: SHELL "del " + F$: LFlag(track) = 0
  LastTop = -1: RETURN

DelCD:
  IF IDnum$ = "" THEN RETURN
  F$ = Path$ + "CD" + IDnum$: K$ = CDTitle$
DelCDI:
  ClrWin Msg$(71)
  CPrat WTop + 7, 2, Msg$(69): PRINT K$
  CPrat WTop + 8, 2, Msg$(68): PRINT F$ + ".*"
  CPrat WTop + 10, 2, Msg$(72)
  CPrat WTop + 11, 2, Msg$(73)
  IF GetYN$ = "Y" THEN LOCATE 4, 1: SHELL "del " + F$ + ".*"
  RETURN

ZipIt:
  ClrWin Msg$(74) + A$
  F$ = "CD" + IDnum$ + ".*"
  CPrat WTop + 7, 2, Msg$(68) + F$
  CPrat WTop + 9, 2, Msg$(75) + A$ + Msg$(76)
  IF GetYN$ = "Y" THEN ClrWin A$ + "...": SHELL C$ + " samples " + F$: GOSUB GetNewCD
  RETURN

'== Programming
700
CheckPrg:
  IF track = Prg(PStp) THEN RETURN
  IF RMode = 1 THEN track = RTrack: GOSUB PlayTrack: RETURN
  GOSUB NextTrack
  IF PStp = 1 THEN
    IF RMode = 4 THEN GOSUB StopTrack: RMode = 4: GOSUB DriveRepeat: RETURN
    IF RMode <> 3 THEN GOSUB StopTrack
  END IF
  RETURN

TogPrgMode:
  PMode = 1 - PMode: PCrsr = NumPrg + 1
  SELECT CASE PMode
    CASE 0: track = Prg(PStp)
    CASE 1
     IF (cd.status AND CDPLAYING) = CDPLAYING THEN
       GOSUB FindStep: PCrsr = NumPrg + 1
     ELSE
       PStp = 1: track = Prg(PStp)
     END IF
  END SELECT
  GOSUB ShowModes: GOSUB SetRef: RETURN

DelStep:
  IF NumPrg < 1 THEN RETURN
  FOR A = PCrsr TO NumPrg - 1: Prg(A) = Prg(A + 1): NEXT
  NumPrg = NumPrg - 1: LastT = -1: Ref = TRUE
  IF PCrsr <= PStp THEN PStp = PStp - 1
  GOSUB FindStep: RETURN

InsStep:
  IF NumPrg > 98 THEN RETURN
  FOR A = NumPrg TO PCrsr STEP -1: Prg(A + 1) = Prg(A): NEXT
  Prg(PCrsr) = V: PCrsr = PCrsr + 1: NumPrg = NumPrg + 1
  GOSUB FindStep: RETURN

FindTrk: PStp = 1: GOSUB SetRef
FindStep:
  FOR A = 1 TO 100: PFlag(A) = 0: NEXT
  FOR A = 1 TO NumPrg
    IF Prg(A) = track THEN PStp = A
    PFlag(Prg(A)) = PFlag(Prg(A)) + 1
  NEXT A: RETURN

ClearPrg:
 IF NumPrg > 0 THEN NumPrg = 0: GOSUB FindStep: GOSUB SetRef: PCrsr = 1: RETURN
ResetPrg:
  FOR A = 1 TO NumT: Prg(A) = A: NEXT
  NumPrg = NumT: PCrsr = NumPrg + 1: GOSUB FindTrk: RETURN

ShufflePrg:
  IF PMode = 0 THEN GOSUB ResetPrg
  RANDOMIZE TIMER: PMode = 1: IF NumPrg < 3 THEN RETURN
  T = Prg(1): Prg(1) = Prg(PStp): Prg(PStp) = T
  N = 2: IF LastT = -1 THEN N = 1
  FOR A = N TO NumPrg
    DO: R = INT(RND(TIMER) * (NumPrg - 1)) + 2: LOOP WHILE R = A
    T = Prg(A): Prg(A) = Prg(R): Prg(R) = T
  NEXT A: track = Prg(1): GOSUB FindStep: GOSUB SetRef: RETURN

LyricPrg: T = 0: PMode = 1: GOSUB SetRef
  FOR A = 1 TO NumT: IF LFlag(A) > 0 THEN T = T + 1: Prg(T) = A
  NEXT A: NumPrg = T: PCrsr = T + 1: GOSUB FindTrk: RETURN

TapeDub:
  ClrWin Msg$(81)
  Prat WTop + 7, 2, Msg$(82)
  F$ = SuppIn(WTop + 9, 2, 3, Msg$(83), ""): IF F$ = "" THEN RETURN
  T = VAL(F$): IF T = 0 THEN RETURN
  R& = 0: N& = T * FPS * 60&: T = 0
  FOR A = 1 TO NumT
    IF A = NumT THEN F2& = TotF& ELSE F2& = tlist(A + 1).absframe
    IF F2& - R& > N& THEN T = T + 1: Prg(T) = 0: R& = tlist(A).absframe
    T = T + 1: Prg(T) = A
  NEXT A: NumPrg = T: PCrsr = T + 1: GOSUB FindTrk: RETURN

ShowProg:
900 IF Ref = FALSE AND LastT = track THEN RETURN
  N = Mouse(2)
  COLOR 7, 0: R = 0: C = 0: IF PMode = 0 THEN GOSUB ShowP1 ELSE GOSUB ShowP2
  N = Mouse(1): RETURN

ShowP1: X = NumT
  FOR A = 1 TO X
    J = A: N = LFlag(A): IF J = track THEN FG = 4 ELSE FG = 1
    GOSUB DrawTBox
  NEXT A
  RETURN

ShowP2:
  X = NumPrg
  FOR A = 1 TO X + 2: J = Prg(A): N = LFlag(J)
    IF A = PStp THEN FG = 4 ELSE FG = 1
    IF A > X THEN FG = 0
    GOSUB DrawTBox
  NEXT A
  IF PCrsr > NumPrg THEN
    K$ = Msg$(84)
  ELSE
    K$ = Msg$(85) + STR$(PCrsr) + "; " + Song$(Prg(PCrsr))
    IF Prg(PCrsr) = 0 THEN K$ = K$ + Msg$(86)
  END IF
  COLOR 7, 0: Prat WTop + WH - 2, 4, LEFT$(K$ + SP$, 70)
  GOSUB ShowScroll: RETURN

DrawTBox:
  RR = R + 4: CC = C * 5 + 4: COLOR FG, 0
  IF PMode = 1 AND PCrsr = A THEN COLOR 14, 0
  Prat RR, CC, "": COLOR 15, FG: LOCATE RR + 1, CC
  IF J <> 0 AND A <= X THEN PRINT USING "###"; J;  ELSE PRINT "   ";
  IF N = 1 AND A <= X THEN PRINT ".";  ELSE PRINT " ";
  C = C + 1: IF C > 14 THEN C = 0: R = R + 2
  RETURN

ShowScroll: IF MFlag = 0 THEN RETURN
  COLOR 11, 0: Prat WTop, 1, CHR$(24): Prat WTop + 1, 1, CHR$(25): RETURN

'== Modes
WSave:
  SELECT CASE Mode
    CASE 9: SaveConfig (CfgName$)
    CASE 11: ClrWin Msg$(106): IF GetYN$ = "Y" THEN SaveLyrics ("CATALOG.TXT")
    CASE ELSE: GOSUB SaveCD
  END SELECT
  RETURN

ShowTrackNum: IF IDnum$ = "" THEN RETURN
1000 IF Ref = FALSE AND track = LastT THEN RETURN
  SongName$ = Song$(track)
  COLOR 7, 0: Prat 2, 8, LEFT$(SongName$ + SP$, 64)
  IF track <> LyricTrack AND LyricTrack <> -2 THEN GOSUB ReadLyrics
  IF Full = 1 THEN RETURN
  COLOR 4, 0: BPrat ITop + 1, -7, 19, 0, RIGHT$(STR$(100 + track), 2)
  COLOR 15, 0: Prat ITop + 1, 75, TimeStr$(cd.TrackMins, cd.TrackSecs)
  COLOR 3, 0: LOCATE ITop + 3, 1
  IF PMode = 1 THEN PRINT USING "Stp##"; PStp;  ELSE PRINT "     ";
  RETURN

ShowTrackList:
  IF Ref = FALSE AND track = LastT THEN RETURN
  STrack = track
ShowTrackPage: Top = 1: IF NumT > WH THEN Top = STrack - (WH \ 2)
ShowTrackP2: IF Top < 1 THEN Top = 1
  IF NumT > WH THEN IF Top + WH > NumT THEN Top = NumT - WH + 1
  FOR A = 0 TO WH - 1: LOCATE 4 + A, 1: N = Top + A
    IF N > NumT THEN PRINT SP$;  ELSE GOSUB PrintTrackLine
  NEXT
  IF NumT > WH THEN GOSUB ShowScroll
  RETURN

PrintTrackLine:
  F& = tlist(N).absframe
  IF N = NumT THEN F2& = TotF& ELSE F2& = tlist(N + 1).absframe
  SELECT CASE TMode
    CASE 1, 2, 5: X& = F2& - F&
    CASE 3, 6: X& = F&
    CASE 4: X& = TotF& - F&
  END SELECT
  COLOR 15, 0: PRINT USING "###."; N;
  IF PMode = 1 AND PFlag(N) > 0 THEN
    COLOR 3: IF PFlag(N) > 1 THEN PRINT "*";  ELSE PRINT "+";
  ELSE
    PRINT " ";
  END IF
  IF N = track THEN COLOR 15, 0 ELSE COLOR 7, 0
  IF TMode >= 5 THEN
    PRINT USING "######"; X&;
  ELSE
    FrameToMSF X&, mins, secs, frames
    PRINT " "; TimeStr$(mins, secs);
  END IF
  IF LFlag(N) = 0 THEN PRINT " - ";  ELSE COLOR 12, 0: PRINT " * ";
  IF N = track THEN COLOR 14, 0 ELSE COLOR 7, 0
  PRINT LEFT$(Song$(N) + SP$, 64); : RETURN

ShowCat:
1200 IF Ref = FALSE OR Top = LastTop THEN RETURN
  IF LyricTrack <> -2 THEN GOSUB LoadCat
  ShowEPage
  LastTop = Top
  COLOR 14, 0: Prat WTop, CCol + 1, Ptr$: GOSUB ShowScroll: RETURN

LoadCat:
  SELECT CASE CatMode
    CASE 0: K$ = "\CD*.CD"
    CASE 1: K$ = "\CD*.T??"
    CASE 2: K$ = "\CD*.ALB"
    CASE 3: K$ = "\CD*.*"
  END SELECT
  ClrWin Msg$(87)
  BTop = 0: BBot = 0: C = 0: Top = 1: LLine = 0
  F$ = DIR$(Path$ + K$)
  DO WHILE F$ <> "" AND C < MaxLyric
    IF RIGHT$(F$, 4) <> ".BMP" THEN GOSUB ReadDFile
    F$ = DIR$
  LOOP
  LyricTrack% = -2: LyricLines = C: LastTop = -1: CMode = 0: CCol% = 1: RETURN

ReadDFile:
  OPEN Path$ + "\" + F$ FOR INPUT AS 2: LINE INPUT #2, A$: CLOSE 2
  C = C + 1: Sync&(C) = 0
  IF LEFT$(A$, 2) = "; " THEN
    A$ = MID$(A$, 3): IF LEFT$(A$, 7) = "TITLE: " THEN A$ = MID$(A$, 8)
  ELSE
    IF LEFT$(A$, 8) = "@ALBUM: " THEN A$ = MID$(A$, 9)
  END IF
  IF CatMode = 3 AND MID$(F$, 10, 1) = "T" THEN A$ = "__" + A$
  Lyric$(C) = RIGHT$(STR$(1000 + C), 3) + ". " + LEFT$(F$ + SP$, 14) + A$
  RETURN

SortCat:
  ClrWin Msg$(88): Top = 1
  CMode = CMode + 1: IF CMode = 3 THEN CMode = 0
  CCol% = 1: IF CMode = 1 THEN CCol% = 6 ELSE IF CMode = 2 THEN CCol% = 20

  Span = LyricLines
  DO WHILE Span > 0
    FOR I% = Span TO LyricLines - 1
      J = I% - Span + 1
      FOR J = (I% - Span + 1) TO 1 STEP -Span
	IF MID$(Lyric$(J), CCol%) <= MID$(Lyric$(J + Span), CCol%) THEN EXIT FOR
	SWAP Lyric$(J), Lyric$(J + Span)
      NEXT J
    NEXT I%
    Span = Span \ 2
  LOOP
  GOSUB SetRef: RETURN

'== SpecBars
1250
ShowFreq: IF Ref = TRUE THEN GOSUB ClearArray: ClrWin ""
 BRow = WTop + WH
 IF IMode = 1 THEN LOCATE WTop, 1: PRINT "Samples="; NumS; ", BarWidth="; BWid - 1; ", Bar Range="; Bar1; "to"; Bar2;
 CALL Freq(BRow, Bar1, Bar2, BWid, NumS)
 RETURN

ShowScope:
  IF Ref = TRUE THEN GOSUB ClearArray: ClrWin ""
  IF Slow = 1 THEN IF (cd.TrackFrame MOD 15) > 2 THEN RETURN
  IF IMode = 1 THEN LOCATE WTop, 1: PRINT "Delay="; Delay;
  CALL Scope(Delay): RETURN

ClearArray: FOR R = 0 TO 255: FB!(R) = 0: FC!(R) = 0: NEXT: RETURN

'== Editing
Edit:
1300 IF Mode <> 3 AND IDnum$ = "" THEN BEEP: RETURN
 COLOR 23: Prat 1, 73, Msg$(99)
 SELECT CASE Mode
   CASE 0, 6: GOSUB EditCDTitle
   CASE 1: GOSUB SetRef: PMode = 1
   CASE 2: GOSUB EditCD
   CASE 3: EditLyrics: LLine = -1
   CASE 4: IF LyricLines > 1 THEN SyncLyrics: LLine = -1
   CASE 5: GOSUB EditTrack
   CASE 6: GOSUB EditCDTitle
   CASE 11
     K$ = Editor$ + " " + Path$ + MID$(Lyric$(Top), 6, 12)
     Prat 4, 1, "CMD=" + K$: SHELL (K$): SLEEP 1
     N = Mouse(1): GOSUB ReDrawAll
 END SELECT
 GOSUB GetStart: Ref = TRUE: RETURN

EditTrack: Song$(track%) = SuppIn(2, 8, 64, "", Song$(track%)): RETURN
EditCDTitle: CDTitle$ = SuppIn(1, 8, 64, "", CDTitle$): RETURN
EditCD: STrack% = 0
EditCD2:
 DO
   IF STrack% < 0 THEN STrack% = 0
   IF STrack% > NumT THEN STrack% = NumT
   GOSUB ShowTrackPage
   RR = STrack% - Top + WTop
   IF STrack% = 0 THEN GOSUB EditCDTitle ELSE Song$(STrack%) = SuppIn(RR, 15, 64, "", Song$(STrack%))
   SELECT CASE CF$
     CASE "8": STrack% = STrack% - 1
     CASE "2", "": STrack% = STrack% + 1
     CASE "7": STrack% = 1
     CASE "1": STrack% = NumT
     CASE "9": STrack% = STrack% - WH \ 2
     CASE "3": STrack% = STrack% + WH \ 2
     CASE ESCS$: EXIT DO
   END SELECT
 LOOP
 GOSUB SaveCD: LastMd = -1: GOSUB ShowModes: RETURN

'== Printing
Printer:
 SELECT CASE Mode
   CASE 1, 2: GOSUB PrintCD
   CASE 3, 4: IF LyricLines > 2 THEN GOSUB PrintLyrics
   CASE 11: GOSUB PrintCat
 END SELECT
 RETURN

PrintCD:
 K$ = "CDInfo": GOSUB Confirm: IF K$ <> "Y" THEN RETURN
 LPRINT CDTitle$: LPRINT STRING$(80, "="): A = 0
 FOR N = 1 TO NumT
   F& = tlist(N).absframe
   IF N = NumT THEN F2& = TotF& ELSE F2& = tlist(N + 1).absframe
   X& = F2& - F&: FrameToMSF X&, mins%, secs%, frames%
   LPRINT USING "##."; N; : LPRINT "  "; TimeStr$(mins%, secs%);
   IF LFlag(N) = 0 THEN LPRINT " - ";  ELSE LPRINT " * "; : A = 1
   LPRINT Song$(N)
 NEXT N
 LPRINT : LPRINT "Total time: "; TimeStr$(cd.cdMins, cd.cdSecs);
 LPRINT "   ("; TotF&; "frames )"
 IF A > 0 THEN LPRINT : LPRINT "Tracks marked '*' have lyrics."
 LPRINT FF$; : RETURN

PrintLyrics:
 K$ = "Lyrics": GOSUB Confirm: IF K$ <> "Y" THEN RETURN
 LPRINT "Track  : "; Song$(track%)
 LPRINT "From CD: "; CDTitle$
 LPRINT STRING$(80, "=")
 FOR A = 1 TO LyricLines: LPRINT Lyric$(A): NEXT A
 LPRINT FF$; : RETURN

PrintCat:
 K$ = "Catalog": GOSUB Confirm: IF K$ <> "Y" THEN RETURN
 LPRINT DATE$; "         Catalog of ";
 LPRINT MID$("Discs LyricsAlbumsAll   ", CatMode * 6 + 1, 6)
 LPRINT STRING$(80, "=")
 FOR A = 1 TO LyricLines
   LPRINT USING "###"; A; : LPRINT MID$(Lyric$(A), 4, 75)
 NEXT A
 LPRINT FF$; : RETURN

Confirm:
  ClrWin Msg$(89) + " " + K$
  CPrat WTop + 8, 2, Msg$(90) + " " + K$ + "?"
  K$ = GetYN$: IF K$ = "Y" THEN ClrWin Msg$(91)
  LastTop = -1: RETURN

'== Lyrics
ReadLyrics:
1500 Ref = TRUE: LLine = -1: Sync&(0) = 1
 GOSUB ClearLyrics: LyricTrack% = track%: LastSync& = 0
 F$ = "CD" + IDnum$ + ".T" + RIGHT$(STR$(100 + track%), 2)
 Lyric$(1) = Msg$(92) + "(" + F$ + ")"
 IF Exists(Path$ + F$) = 1 THEN GOSUB ReadLyricFile: RETURN
 IF AlbumF = 0 THEN RETURN
 S$ = Song$(track%): F$ = Path$ + "CD" + IDnum$ + ".ALB"
 OPEN F$ FOR INPUT AS 1: Found = 0
 DO WHILE NOT EOF(1)
   LINE INPUT #1, A$
   IF INSTR(UCASE$(A$), "@SONG:") > 0 THEN
     IF INSTR(UCASE$(A$), UCASE$(S$)) > 6 THEN GOSUB ExtractSong: EXIT DO
   END IF
 LOOP
 CLOSE 1: IF Found = 0 THEN RETURN
 LastMd = -1: LLine = -1: Top = 1: RETURN

ReadLyricFile:
 F = FREEFILE: OPEN Path$ + F$ FOR INPUT AS F: C = 0: LastSync& = 0
 WHILE NOT EOF(F) AND C < MaxLyric
   LINE INPUT #F, A$: IF LEFT$(A$, 1) <> ";" THEN GOSUB AddLyric
 WEND
 CLOSE F: LyricLines = C: Lyric$(C + 1) = "": Sync&(0) = 1: RETURN

AddLyric:
 C = C + 1: R& = VAL(A$)
 IF R& = 0 THEN Lyric$(C) = A$ ELSE Lyric$(C) = MID$(A$, 10)
 IF R& < LastSync& OR R& = NoSync& THEN R& = LastSync& ELSE LastSync& = R&
 IF R& = 0 THEN IF LastSync& > 0 THEN R& = LastSync& ELSE R& = NoSync&
 Sync&(C) = R&: RETURN

ClearLyrics:
 FOR A = 0 TO MaxLyric: Lyric$(A) = "": Sync&(A) = NoSync&: NEXT
 Sync&(0) = 1: LyricLines = 1: RETURN

SaveLyr: SaveLyrics (""): GOSUB SetRef: LFlag(LyricTrack%) = 1: RETURN

InitLyrics: IF LyricLines = 0 THEN RETURN
 GOSUB SyncUp: LyricTop = LLine: Ref = TRUE
 IF Mode = 3 THEN ClrWin "": GOSUB ShowLyrics
 IF Mode = 4 THEN ClrWin "": GOSUB ShowKaraoke
 RETURN

SyncUp: COLOR 7, 0
 LLine = 0: Top = 1: IF Sync&(1) = 0 THEN RETURN
 GOSUB GetStart: cdGetInfo cdu, 0, cd, tlist(): EFrame& = cd.frame - StartF&
 DO
  IF EFrame& < Sync&(LLine + 1) THEN EXIT DO
  LLine = LLine + 1
 LOOP
 Top = LLine: RETURN

ShowLyrics:
 IF Spin = 0 THEN RETURN
 IF LLine = -1 THEN GOSUB InitLyrics: RETURN
 IF Ref = TRUE THEN Top = LyricTop: GOSUB ShowKPage
 IF LLine < 0 THEN RETURN
 IF LLine - LyricTop > WH - 2 THEN LyricTop = LLine: Top = LyricTop: IF Mode = 3 THEN GOSUB ShowKPage
ShowLLoop:
 R = WTop + LLine - LyricTop + 1: Ofs& = Sync&(LLine + 1) - EFrame&
 IF Ofs& > FPS% THEN COLOR 4, 0: Prat R, 1, SPtr$: RETURN
 IF Ofs& > 19 THEN COLOR 14, 0: Prat R, 1, SPtr$: RETURN
 IF Ofs& > 0 THEN COLOR 10, 0: Prat R, 1, Ptr$: RETURN
 LLine = LLine + 1: K$ = Words$(Lyric$(LLine))
 COLOR 14, 0: Prat R, 1, "  " + LEFT$(K$ + SP$, 78)
 RETURN

ShowKaraoke:
 IF Spin = 0 THEN RETURN
 IF LLine = -1 THEN GOSUB InitLyrics: RETURN
 IF Ref = TRUE GOTO ShowKNow
 IF LLine < 0 THEN RETURN
 IF LLine - LyricTop > WH - 2 THEN LyricTop = LLine
ShowKLoop:
 R = WTop + WH - 1: Ofs& = Sync&(LLine + 1) - EFrame&
 IF Ofs& > FPS% THEN COLOR 4, 0: Prat R, 1, SPtr$: RETURN
 IF Ofs& > 19 THEN COLOR 14, 0: Prat R, 1, SPtr$: RETURN
 IF Ofs& > 0 THEN COLOR 10, 0: Prat R, 1, Ptr$: RETURN
 LLine = LLine + 1
ShowKNow:
 R = WTop + WH - 1: KK$ = Lyric$(LLine): K2$ = Lyric$(LLine + 1)
 COLOR 7, 0: Prat R, 3, LEFT$(Words$(K2$) + SP$, 77)
 IF KK$ = "" THEN RETURN
 IF KK$ = "." THEN KK$ = ""
 COLOR Config(13), Config(12): KK$ = Words$(KK$): GOSUB ShowBig: RETURN

ShowBig: BPrat WTop, 1, 80, WTop + WH - 2, KK$: RETURN

ShowKPage:
 COLOR 7, 0
 FOR A = 0 TO WH - 1: LOCATE WTop + A, 1: N = Top + A
   IF N > LyricLines THEN
     PRINT SP$;
   ELSE
     IF N <= LLine THEN COLOR 14, 0 ELSE COLOR 7, 0
     IF Sync&(N) = NoSync& THEN PRINT ". ";  ELSE PRINT "  ";
     PRINT LEFT$(Words$(Lyric$(N)) + SP$, 78);
   END IF
 NEXT A
 RETURN

ReadCDFile:
 FOR A = 1 TO 99: Song$(A) = "Track" + STR$(A): NEXT: X$ = ""
 F$ = "CD" + IDnum$ + ".CD": CDTitle$ = F$
 IF Exists(Path$ + F$) = 0 THEN
   IF Config(4) = 1 THEN AutoEd% = 1
   RETURN
 END IF
 OPEN Path$ + F$ FOR INPUT AS 1: LINE INPUT #1, CDTitle$: C = 0
 DO WHILE NOT EOF(1) AND C < 99 AND C < NumT
   C = C + 1: LINE INPUT #1, Song$(C)
 LOOP
 X$ = "": IF NOT EOF(1) THEN LINE INPUT #1, X$
 CLOSE
 IF VAL(X$) > 0 THEN GOSUB ReadPlayList ELSE GOSUB ResetPrg
 RETURN

CheckAlbTracks:
 OPEN F$ FOR INPUT AS 1
 DO WHILE NOT EOF(1)
  LINE INPUT #1, A$: IF LEFT$(A$, 7) = "@SONG: " THEN GOSUB FindTrack
 LOOP
 CLOSE : RETURN

FindTrack:
 X$ = UCASE$(RTRIM$(MID$(A$, 8)))
 FOR A = 1 TO NumT
   IF UCASE$(Song$(A)) = X$ THEN LFlag(A) = 1: EXIT FOR
 NEXT A
 RETURN

ReadPlayList: C = 0
 FOR A = 1 TO LEN(X$) STEP 3: V = VAL(MID$(X$ + "   ", A, 3))
   IF V >= 0 AND V <= NumT THEN C = C + 1: Prg(C) = V
   IF C > 99 THEN EXIT FOR
 NEXT A
 NumPrg = C: C = 0
 FOR A = 1 TO NumPrg: IF Prg(A) <> A THEN C = 1
 NEXT A
 IF C = 0 THEN GOSUB ClearPrg: NumPrg = 0: RETURN
 IF Config(3) = 1 THEN PMode = 1: GOSUB FindStep
 RETURN

SaveCD:
 F$ = "CD" + IDnum$ + ".CD"
 IF IDnum$ = "" OR CDTitle$ = "" OR CDTitle$ = F$ THEN RETURN
 OPEN Path$ + F$ FOR OUTPUT AS 1: PRINT #1, CDTitle$
 FOR A = 1 TO NumT: PRINT #1, Song$(A): NEXT
 FOR A = 1 TO NumPrg: PRINT #1, USING "###"; Prg(A); : NEXT: PRINT #1, ""
 CLOSE 1: RETURN

'== Config
InitConfig:
2000  FOR A = 1 TO 13: READ Cfg$(A), Config(A), CRange(A, 0), CRange(A, 1)
  NEXT: RETURN

'== Display
3000
ShowSongName:
  IF Ref = FALSE AND track% = LastT THEN RETURN
  KK$ = Song$(track%): COLOR 4, 0: GOSUB ShowBig: RETURN
3001
ShowCDName:
  IF Ref = FALSE AND track% = LastT THEN RETURN
  KK$ = CDTitle$: COLOR 5, 0: GOSUB ShowBig: RETURN
3002
ShowConfig:
  IF CRow = 14 THEN
     GOSUB ShowSettings: Joy$ = SuppIn(19, -60, 15, "", Joy$)
     IF CF$ = "8" THEN CRow = 13 ELSE CRow = 1
     GOSUB ShowSettings
  END IF
  IF Mode <> LastMd THEN GOSUB ShowConfig2
  IF Ref = TRUE THEN GOSUB ShowSettings
  RETURN

3010
ShowConfig2: CALL ConfigText
ShowSettings:
  FOR A = 1 TO 13
    IF Config(A) < CRange(A, 0) THEN Config(A) = CRange(A, 1)
    IF Config(A) > CRange(A, 1) THEN Config(A) = CRange(A, 0)
    LOCATE WTop + 1 + A, 60
    IF A = CRow THEN COLOR 15, 1 ELSE COLOR 7, 0
    IF CRange(A, 1) = 1 THEN
      PRINT MID$("NO YES", Config(A) * 3 + 1, 3);
    ELSE
      PRINT USING "###"; Config(A);
    END IF
  NEXT A
  RETURN

3040
ReDrawAll: CLS
ShowTitles:
  COLOR 4, 0: Prat 1, 1, SPtr$
  COLOR 15, 0: Prat 1, 2, "DISC: ": Prat 2, 1, "TRACK: ": LastW = 0
  COLOR 2, 0: Prat 3, 1, DL$: IF MFlag = 1 THEN Prat 3, 1, "<|": Prat 3, 79, "|>"
  COLOR 0, 3
  SELECT CASE BFlag
    CASE 1: MouseK$ = " -+": GOSUB ShowMMode
    CASE 2: MouseK$ = Msg$(17): Prat 3, 3, Msg$(16)
    CASE 3: MouseK$ = Msg$(19): Prat 3, 3, Msg$(18)
  END SELECT
  COLOR 7, 0: Prat 1, 8, LEFT$(CDTitle$ + SP$, 64)
  IF Full = 1 THEN RETURN
  FOR A = 1 TO 4: Prat ITop + A, 59, Msg$(A + 2): NEXT A
  COLOR 15, 0
  Prat ITop + 1, 59, SPtr$
  Prat ITop + 1, 1, Msg$(7)
  Prat ITop + 2, 64, TimeStr$(cd.cdMins, cd.cdSecs)
  COLOR 2, 0: Prat ITop, 1, DL$

3050
ShowModes:
  IF Full = 1 THEN RETURN
  COLOR 15, 0: Prat ITop + 2, 79, Drv$
  IF VolP > 99 THEN VolP = 99
  LOCATE ITop + 3, 66: PRINT USING "##"; VolP;
  Prat ITop + 3, 77, MID$(Msg$(8), RMode * 3 + 1, 3)
  Prat ITop + 1, 20, MID$(Msg$(10), TMode * 7 - 6, 7)
  Prat ITop + 2, 20, MID$(Msg$(11), TMode * 7 - 6, 7)
  Prat NumLines, 73, MID$(Msg$(12), Mode * 7 + 1, 7)
  COLOR 19, 0: Prat ITop + 3, 22, MID$(Msg$(13), Intro * 5 + 1, 5)
  COLOR 3, 0: Prat ITop + 2, 1, MID$(Msg$(14), PMode * 5 + 1, 5)
  GOSUB ShowJmp: RETURN

ShowMMode: COLOR 0, 3: N = Mouse(2)
  K$ = Msg$(15)
  Prat 3, 3, K$: IF Mode > 0 AND Mode < 13 THEN COLOR 15: Prat 3, 1 + (Mode * 6), MID$(K$, Mode * 6 - 1, 5)
  COLOR 7, 0: N = Mouse(1): RETURN

DoHelp:
 LastMd = -1: LastTop = -1: RTime& = 0
 IF Mode = 0 THEN Mode = SMode: GOSUB JumpMode: RETURN
 SMode = Mode: Mode = 0: GOSUB ShowModes
ShowHelp:
 IF Mode = LastMd THEN RETURN
 COLOR 15, 1: ClrWin "": LastMd = Mode: Help
 CPrat 10, 63, "@": FOR A = 1 TO NumCD%: PRINT CHR$(65 + FirstCD + A - 1); " "; : NEXT
 CPrat 11, 72, "@" + IDnum$: RETURN

ParseCmd:
 C$ = COMMAND$
 IF LEFT$(C$, 7) = "CONFIG:" THEN CALL LoadConfig(MID$(C$, 8)): RETURN
 IF C$ = "CHECK" THEN GOSUB CheckCD: RETURN
 P = 1: GOSUB GetNewCDInfo
 DO WHILE P < LEN(C$) AND C4$ <> "NOEX"
   PP = INSTR(P, C$ + " ", " "): IF PP = P THEN EXIT DO
   CC$ = MID$(C$, P, PP - P): P = PP + 1: GOSUB DoCmd
 LOOP
 DEF SEG = 64: IF (PEEK(23) AND 3) <> 0 THEN RETURN
 IF C4$ = "NOEX" THEN RETURN
 END

CheckCD: IF IsAudio(cdu) = 0 THEN PRINT "No CD inserted.": END
 RETURN

DoCmd:
 C4$ = LEFT$(CC$ + "    ", 4): COLOR 7, 0
 IF C4$ = "UNIT" THEN GOSUB SetUnit: RETURN
 IF C4$ = "IFCD" THEN IF IsAudio(cdu) = 0 THEN END 1 ELSE RETURN
 IF C4$ = "IFAU" THEN IF NumT < 2 THEN END 1 ELSE RETURN
 IF IsAudio(cdu) = 0 THEN PRINT "No DISC in drive ("; CHR$(65 + cdu); ":)!": END 1
 SELECT CASE C4$
   CASE "PLAY": GOSUB GetTrack: GOSUB PlayTrack: GOSUB ShowPlay
   CASE "SING"
     GOSUB GetTrack: GOSUB GetStart
     cdStop cdu: cdPlayFrames cdu, StartF&, NumF&
     GOSUB ShowPlay
   CASE "WAIT"
     LastT% = track%
     PRINT "Waiting for song end (Press any key to continue)."
     DO: cdGetInfo cdu, 0, cd, tlist()
     LOOP WHILE ((cd.status AND CDPLAYING) = CDPLAYING) AND (cd.track = LastT%) AND (INKEY$ = "")
   CASE "NEXT": track% = track% + 1: GOSUB PlayTrack: GOSUB ShowPlay
   CASE "PREV": track% = track% - 1: GOSUB PlayTrack: GOSUB ShowPlay
   CASE "STOP": GOSUB StopTrack
   CASE "EJEC", "NOAU", "NODA": GOSUB EjectOnly
   CASE "INFO": GOSUB ShowInfo
   CASE "TRAC": GOSUB ShowPlay
   CASE "TNUM": PRINT track%
   CASE "TITL": GOSUB ShowTitle
   CASE "ELAP": GOSUB ShowElapsed
   CASE "VOLU": GOSUB GetNum: VolP = N: GOSUB SetVol2: PRINT "Volume set to"; VolP
   CASE "IFST": IF (cd.status AND CDPLAYING) = CDPLAYING THEN END
   CASE "IFPL": IF (cd.status AND CDPLAYING) <> CDPLAYING THEN END
   CASE "SCAN": Mode = 14: GOSUB ScanUnits
   CASE "LOCK": cdDoor cdu, 4
   CASE "UNLO": cdDoor cdu, 3
   CASE "VERS", "/?  ": PRINT Ver$; " - S"; "tev"; "e J"; ". "; "G"; "ray"
   CASE ELSE: PRINT "I don't know what '"; C4$; "'is!"
 END SELECT
 RETURN

GetNum:
 N = INSTR(CC$, ":"): IF N = 0 THEN RETURN
 N = VAL(MID$(CC$, N + 1)): RETURN

GetTrack:
 GOSUB GetNum: IF N = -1 THEN N = INT(RND(TIMER) * NumT) + 1
 IF N < 1 OR N > NumT THEN track% = 1: RETURN
 track% = N: RETURN

EjectOnly: N = IsAudio%(cdu)
 SELECT CASE C4$
   CASE "NODA": IF N <> 0 THEN RETURN
   CASE "NOAU": IF N <> 1 THEN RETURN
 END SELECT
 GOSUB Eject: RETURN

SetUnit:
4000 GOSUB GetNum
 IF N < 1 OR N > NumCD% THEN PRINT "Drive "; N; "not available!": END 2
 cdu = FirstCD + N - 1: PRINT "Drive set to:"; N; " ("; CHR$(65 + cdu); ":)"
 GOSUB GetNewCDInfo: RETURN

ShowTitle: PRINT : PRINT "Disc: "; CDTitle$: RETURN
ShowPlay: PRINT : PRINT "Playing: "; Song$(track%): RETURN

ShowInfo:
 GOSUB ShowTitle: PRINT
 FOR N = 1 TO NumT: GOSUB PrintTrackLine: PRINT : NEXT N: COLOR 7, 0: PRINT
 PRINT "Total time: "; TimeStr$(cd.cdMins, cd.cdSecs);
 PRINT "   ("; TotF&; "frames )": RETURN

ShowElapsed:
 cdGetInfo cdu, 0, cd, tlist()
 PRINT TimeStr$(cd.TrackMin, cd.TrackSec): RETURN

ErrorHandler:
  ClrWin ""
  SELECT CASE ShowErr$
    CASE "R": ClrWin "": RESUME
    CASE "C": RESUME 120
    CASE "A": CLS : END
  END SELECT
  Prat WTop + 14, 2, "Press any key...": SLEEP 60: K$ = INKEY$
  CLOSE : RESUME 120

'---- Config
DATA "MODE",1,0,12
DATA "FULL",0,0,1
DATA "PRG",1,0,1
DATA "EDIT",0,0,1
DATA "PLAY",0,0,2
DATA "EXIT",0,0,2
DATA "VIDEO",0,0,2
DATA "INTRO",15,5,30
DATA "FFREV",5, 1,10
DATA "VDEV",0,0,2
DATA "REPT",0,0,3
DATA "KBACK",0,0,7
DATA "KTEXT",7,0,15

'---- Font
FontDat:
'space-/
DATA "   ","","","",""
DATA " ","","","",""
DATA "  ","","","",""
DATA "    ","","","  ",""
DATA "  ","","","  ",""
DATA "   ","  "," ","   ",""
DATA "   ",""," ","  ",""
DATA "  ","","","",""
DATA "  ","","","  ",""
DATA "  ","  "," ","",""
DATA "   ","","","  ",""
DATA "     ","","  ","",""
DATA "   ",""," ","",""
DATA "      ","","","",""
DATA "  ","","","",""
DATA "      ","   "," ","",""
'0-9
DATA " "," ","  "," ",""
DATA "    ","  ","  "," ",""
DATA " ","  ","","",""
DATA " ","  ","   "," ",""
DATA "    ","","   ","   ",""
DATA " ","","   "," ",""
DATA " ","","   "," ",""
DATA " ","   ","  ","  ",""
DATA " ","","   "," ",""
DATA " ","","   "," ",""
':-@
DATA "    "," "," ","",""
DATA "   "," "," ","",""
DATA "   ",""," ","   ",""
DATA "     ","","","",""
DATA "   ","  "," ","",""
DATA " ","   ","  ","  ",""
DATA " "," "," "," ",""
'A-Z
DATA " ","","   ","   ",""
DATA " ","","   ","",""
DATA " ","","   "," ",""
DATA " ","   ","   ","",""
DATA " ","","","",""
DATA " ","","","",""
DATA " "," ","   "," ",""
DATA "    ","","   ","   ",""
DATA " "," "," ","",""
DATA "     ","    ","   "," ",""
DATA "   ",""," ","   ",""
DATA "    ","","","",""
DATA "  ","  ","   ","   ",""
DATA "   "," ","   ","   ",""
DATA " ","   ","   "," ",""
DATA " ","","","",""
DATA " ","   "," ","  ",""
DATA " ",""," ","   ",""
DATA " ","","   "," ",""
DATA " ","  ","  ","  ",""
DATA "    ","   ","   "," ",""
DATA "    "," "," ","  ",""
DATA "    ","   ","  ","  ",""
DATA "    "," "," ","   ",""
DATA "    "," ","  ","  ",""
DATA " ","  ","","",""
'[-`
DATA " ","","","",""
DATA "      ","","  ","    ",""
DATA " "," "," ","",""
DATA "   ","   ","","",""
DATA "      ","","","",""
DATA "  ","","","",""
'a-z
DATA "     "," ",""," ",""
DATA "    ","","  ","",""
DATA "     ","",""," ",""
DATA "    ","","  "," ",""
DATA "     ","",""," ",""
DATA "  ",""," "," ",""
DATA "     ","","  "," "," "
DATA "    ","","  ","  ",""
DATA "  ",""," "," ",""
DATA "   "," ","  ","  ",""
DATA "    "," ","","  ",""
DATA "  ","",""," ",""
DATA "      ","","  ","  ",""
DATA "     ","","  ","  ",""
DATA "     ","","  "," ",""
DATA "     ","","  ","",""
DATA "     ",""," ","  ","   "
DATA "     ","","","",""
DATA "     ",""," ","",""
DATA "   ",""," ","  ",""
DATA "     ","  "," ","  ",""
DATA "      ","   ","  ","  ",""
DATA "      ","   ","  ","  ",""
DATA "      "," "," ","   ",""
DATA "     ","  ","  "," "," "
DATA "     ","","","",""
'{-~
DATA "  ",""," ","  ",""
DATA " ","","","",""
DATA "  "," "," ","",""
DATA "   "," ","","",""

REM $DYNAMIC
SUB DispTime
  STATIC LastF, LastW

  cdGetInfo cdu, 0, cd, tlist(): EFrame& = cd.frame - StartF&
  IF BFlag = 0 THEN
    COLOR 2, 0: LOCATE 3, 3 + LastF: PRINT DD$;
    N = cd.cdFrame MOD FPS%: LastF = N
    COLOR 10, 0: LOCATE 3, 3 + N: PRINT DD$;
  ELSEIF BFlag = 4 THEN
    CALL VUMeter(3)
  END IF

  IF Full = 1 THEN EXIT SUB
  IF IDnum$ = "" THEN
    COLOR 7, 0: BPrat ITop + 1, -7, 19, 0, "No": BPrat ITop + 1, -28, 58, 0, "Disc"
  ELSE
    IF track% <> LastT THEN COLOR 4, 0: BPrat ITop + 1, -7, 19, 0, RIGHT$(STR$(100 + track%), 2)
    COLOR 15 - TMode, 0
    SELECT CASE TMode
      CASE 1: mins% = cd.TrackMin: secs% = cd.TrackSec
      CASE 2, 6
	IF track% = NumT THEN X& = TotF& - cd.frame ELSE X& = tlist(track% + 1).absframe - cd.frame
	FrameToMSF X&, mins%, secs%, frames%
	IF TMode = 6 THEN BPrat ITop + 1, -28, 58, 0, RIGHT$("00000" + MID$(STR$(X&), 2), 5)
      CASE 3: mins% = cd.cdMin: secs% = cd.cdSec
      CASE 4: X& = TotF& - cd.frame: FrameToMSF X&, mins%, secs%, frames%
      CASE 5: BPrat ITop + 1, -28, 58, 0, RIGHT$("00000" + MID$(STR$(EFrame&), 2), 5)
    END SELECT
    LOCATE , , 0: IF TMode < 5 THEN BPrat ITop + 1, -28, 58, 0, TimeStr$(mins%, secs%)
  END IF

  Per! = EFrame& / (NumF& + 1): IF Per! < 0 OR Per! > 1 THEN Per! = 0
  COLOR 15, 0: W = Per! * 75!
  LOCATE ITop + 1, 67: PRINT USING "###"; Per! * 100!; :
  IF (W <> LastW) OR (Ref = TRUE) THEN
    LastW = W
    COLOR 10, 0: LOCATE ITop, 1: PRINT "<|"; LEFT$(DL$, W); "O";
    COLOR 2, 0: PRINT STRING$(75 - W, CHR$(196)); "|>";
  END IF
END SUB

SUB ReadFont (F$)

IF F$ <> "" THEN
  OPEN F$ FOR INPUT AS 1: INPUT #1, FontH, MaxChr, LF1$, LF2$
ELSE
  LF1$ = "": LF2$ = "": FontH = 5: MaxChr = 95: RESTORE FontDat
END IF

CS = 1: FOR A = 1 TO 16: Font$(A) = "": NEXT

FOR A = 1 TO MaxChr
  FOR B = 1 TO FontH
    DO
      IF F$ = "" THEN READ S$ ELSE INPUT #1, S$
    LOOP WHILE LEFT$(S$, 1) = ";"
    IF B = 1 THEN CW = LEN(S$)
    Font$(B) = Font$(B) + LEFT$(S$ + SP$, CW)
  NEXT B
  FontP(A) = CS: FontW(A) = CW: CS = CS + CW
NEXT A
CLOSE

END SUB

