/*!\file sys/werrno.h
 *
 * sys_errlist[] and errno's for compilers with limited errnos.
 * For MingW, simply define "E*" = "WSAE*".
 *
 * G. Vanem <giva@bgnett.no> 1998
 */

#ifndef __SYS_WERRNO_H
#define __SYS_WERRNO_H

/* When doing "gcc -MM" with gcc 3.0 we must include <sys/version.h>
 * (via stdio.h) in order for __DJGPP__ to be defined
 */
#include <stdio.h>
#include <errno.h>

/* Hack: fix for compiling with djgpp 2.04, but
 *       ./util/dj_err.exe was compiled with 2.03
 */
#if defined(MIXING_DJGPP_203_AND_204)
#undef ELOOP
#endif

#if defined(__HIGHC__)
  #undef EDEADLK
  #undef EDEADLOCK
  #include <sys/highc.err>

#elif defined(__BORLANDC__)
  #ifdef __FLAT__
  #undef ENAMETOOLONG  /* bcc32 4.0 */
  #endif
  #include <sys/borlandc.err>

#elif defined(__TURBOC__)
  #include <sys/turboc.err>

#elif defined(__WATCOMC__)
  #include <sys/watcom.err>

#elif defined(__DJGPP__)
  #include <sys/djgpp.err>

#elif defined(__DMC__)                        /* Digital Mars Compiler */
  #include <sys/digmars.err>

#elif defined(_MSC_VER) && (_MSC_VER <= 800)  /* MSC 8.0 or older */
  #include <sys/quickc.err>

#elif defined(_MSC_VER) && (_MSC_VER > 800)   /* Visual C; cl32.exe */
  #undef EDEADLOCK
  #include <sys/visualc.err>

#elif defined(__CCDL__)                       /* LadSoft's cc386.exe */
  #include <sys/ladsoft.err>

#elif defined(__MINGW32__)
  #ifndef WIN32_LEAN_AND_MEAN
  #define WIN32_LEAN_AND_MEAN
  #endif

  #include <winsock2.h>

  #ifndef GENERATATING_ERRNOS
  #include <sys/mingw32.err>
  #endif

  #define EWOULDBLOCK       WSAEWOULDBLOCK
  #define EINPROGRESS       WSAEINPROGRESS
  #define EALREADY          WSAEALREADY
  #define ENOTSOCK          WSAENOTSOCK
  #define EDESTADDRREQ      WSAEDESTADDRREQ
  #define EMSGSIZE          WSAEMSGSIZE
  #define EPROTOTYPE        WSAEPROTOTYPE
  #define ENOPROTOOPT       WSAENOPROTOOPT
  #define EPROTONOSUPPORT   WSAEPROTONOSUPPORT
  #define ESOCKTNOSUPPORT   WSAESOCKTNOSUPPORT
  #define EOPNOTSUPP        WSAEOPNOTSUPP
  #define EPFNOSUPPORT      WSAEPFNOSUPPORT
  #define EAFNOSUPPORT      WSAEAFNOSUPPORT
  #define EADDRINUSE        WSAEADDRINUSE
  #define EADDRNOTAVAIL     WSAEADDRNOTAVAIL
  #define ENETDOWN          WSAENETDOWN
  #define ENETUNREACH       WSAENETUNREACH
  #define ENETRESET         WSAENETRESET
  #define ECONNABORTED      WSAECONNABORTED
  #define ECONNRESET        WSAECONNRESET
  #define ENOBUFS           WSAENOBUFS
  #define EISCONN           WSAEISCONN
  #define ENOTCONN          WSAENOTCONN
  #define ESHUTDOWN         WSAESHUTDOWN
  #define ETOOMANYREFS      WSAETOOMANYREFS
  #define ETIMEDOUT         WSAETIMEDOUT
  #define ECONNREFUSED      WSAECONNREFUSED
  #define ELOOP             WSAELOOP
  #define EHOSTDOWN         WSAEHOSTDOWN
  #define EHOSTUNREACH      WSAEHOSTUNREACH
  #define EPROCLIM          WSAEPROCLIM
  #define EUSERS            WSAEUSERS
  #define EDQUOT            WSAEDQUOT
  #define ESTALE            WSAESTALE
  #define EREMOTE           WSAEREMOTE

#else
  #error Unknown target in <sys/werrno.h>.
#endif

/*
 * Incase you have trouble with duplicate defined symbols,
 * make sure these are used before perror/strerror/sys_errlist
 * in your C-library.
 */
extern void  perror_s   (const char *str);
extern char *strerror_s (int errnum);

#endif  /* __SYS_WERRNO_H */

