//**************************************************************************
//*                     This file is part of the                           *
//*                MMC - Mpxplay Multimedia Commander                      *
//*                   The source code of MMC is                            *
//*        (C) copyright 1998-2020 by PDSoft (Attila Padar)                *
//*                http://mpxplay.sourceforge.net                          *
//*                  email: mpxplay@freemail.hu                            *
//**************************************************************************
//*  This program is distributed in the hope that it will be useful,       *
//*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
//*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *
//*  Please contact with the author (with me) if you want to use           *
//*  or modify this source.                                                *
//**************************************************************************
//function: video GDI render output (for testing and reference only)

//#define MPXPLAY_USE_DEBUGF 1
#define DISPQT_DEBUG_OUTPUT NULL //stdout
#define DISPQT_DEBUG_ERROR stderr

#include "moc_config.h"

#if MPXPLAY_DISPQT_ENABLE_RENDER_GDI

#include "moc_video_qt.h"
#include "moc_mainwindow.h"

#include <windows.h>
#include <objidl.h>
#include <gdiplus.h>
#include <wingdi.h>

MMCDispQtVideoRendererGDI::MMCDispQtVideoRendererGDI(MainWindow *mainwindow, QWidget *parent) : MMCDispQtVideoRendererBase(mainwindow, parent)
{
	mpxplay_video_render_infos.hwdevice_avpixfmt = AV_PIX_FMT_NONE;
}

void MMCDispQtVideoRendererGDI::videorenderer_videoframe_render(struct dispqt_video_surface_info_s *video_surface_infos, ffmpegvideo_subtitle_info_s *subtitle_infos)
{
	HWND hwnd = (HWND)this->parent_widget->winId();
	HDC hDC = GetDC(hwnd);

	if(video_surface_infos->videoout_surface_clearpic || !video_surface_infos->ffmpeg_output_frame)
	{
	    RECT rect;
	    rect.left = 0; rect.top = 0;
	    rect.right = video_surface_infos->window_size_x;
	    rect.bottom = video_surface_infos->window_size_y;
	    HBRUSH hbrRed = CreateSolidBrush(RGB(0, 0, 0));
	    FillRect(hDC, &rect, hbrRed);
	    video_surface_infos->videoout_surface_clearpic = false;
	}

	if(video_surface_infos->ffmpeg_output_frame)
	{
		HBITMAP hBitMapOld, hBitMapVideoframe, hBitMapSubtitlepic = NULL;
		int subRet = this->renderbase_subtitle_qpaint(video_surface_infos, subtitle_infos, (DISPQT_RENDERBASE_SUBTITLE_CTRLFLAG_FULLSCREEN | DISPQT_RENDERBASE_SUBTITLE_CTRLFLAG_BLACKBORDERS));
		HDC hMemDC = CreateCompatibleDC(hDC);

		hBitMapVideoframe = CreateBitmap(video_surface_infos->ffmpeg_output_frame->width, video_surface_infos->ffmpeg_output_frame->height, 1, 32, video_surface_infos->ffmpeg_output_frame->data[0]);
		if(subRet)
			hBitMapSubtitlepic = CreateBitmap(this->get_subtitle_pic_width(), this->get_subtitle_pic_height(), 1, 32, this->get_subtitle_image_memory_ptr());

		hBitMapOld = (HBITMAP)SelectObject(hMemDC, hBitMapVideoframe);

		SetStretchBltMode(hDC, COLORONCOLOR);
		//SetStretchBltMode(hDC, (video_surface_infos->is_fullscreen)? HALFTONE : COLORONCOLOR); // HALFTONE is too slow

		StretchBlt(hDC, video_surface_infos->sws_dst_pos_x, video_surface_infos->sws_dst_pos_y, video_surface_infos->sws_dst_width, video_surface_infos->sws_dst_height,
		           hMemDC, video_surface_infos->sws_crop_x, video_surface_infos->sws_crop_y, video_surface_infos->sws_crop_w, video_surface_infos->sws_crop_h, SRCCOPY);

		if(subRet)
		{
			SelectObject(hMemDC, hBitMapSubtitlepic);

			BLENDFUNCTION bf;
			bf.BlendOp = AC_SRC_OVER;
			bf.BlendFlags = 0;
			bf.SourceConstantAlpha = 0xff;
			bf.AlphaFormat = AC_SRC_ALPHA;
			// this requires msimg32.lib
			AlphaBlend(hDC, this->get_subtitle_pic_globalpos_x(), this->get_subtitle_pic_globalpos_y(),
						this->get_subtitle_pic_width(), this->get_subtitle_pic_height(),
			    		hMemDC, 0, 0, this->get_subtitle_pic_width(), this->get_subtitle_pic_height(), bf);
			//this cannot merge properly the video frame with the transparent subtitle frame
			//BitBlt(hDC, this->get_subtitle_pic_globalpos_x(), this->get_subtitle_pic_globalpos_y(), this->get_subtitle_pic_width(), this->get_subtitle_pic_height(), hMemDC, 0, 0, SRCPAINT);
		}

		SelectObject(hMemDC, hBitMapOld);

		DeleteObject(hBitMapVideoframe);
		if(hBitMapSubtitlepic)
			DeleteObject(hBitMapSubtitlepic);

		DeleteDC(hMemDC);
	}

    //QString text("Test GDI Paint");
    //SetTextAlign(hDC, TA_CENTER | TA_BASELINE);
    //TextOutW(hDC, video_surface_infos->window_size_x / 2, video_surface_infos->window_size_y / 2, (LPCWSTR)text.utf16(), text.size());
	GdiFlush();
    ReleaseDC(hwnd, hDC);
}

#endif // MPXPLAY_DISPQT_ENABLE_RENDER_GDI
