#ifndef MOC_AVMIXER_H
#define MOC_AVMIXER_H
 
#include <QWidget>
#include <QtWidgets>
#include "moc_dialog_elems.h"
#include "moc_video_qt.h"
#include "mpxplay.h"

QT_BEGIN_NAMESPACE
class MainWindow;
QT_END_NAMESPACE

#define AMIXER_SLIDER_NUM  6
#define VMIXER_SLIDER_NUM  DISPQT_VIDEO_VMIXERTYPE_MAX

#define DISPQT_AVMIXER_BUTTON_HEIGHT 20

#define DISPQT_AMIXER_FLAG_VIDEOTOO (1<< 0)

struct amixer_info_s {
	const char *slider_name;
	const char *amixer_name;
	unsigned long video_limit;
	unsigned long flags;
};

class DispQtmixerSlider : public QSlider
{
Q_OBJECT
public:
	DispQtmixerSlider(MainWindow *mainwindow = 0, QWidget *parent = NULL);
	void mixerslider_setmaxval(int max_val);

public Q_SLOTS:
	void slider_set_style(void);

protected:
	void wheelEvent(QWheelEvent* event);

private:
	MainWindow *main_window;
	int max_value;
};

class DispQtAmixerSliders : public QWidget
{
Q_OBJECT
public:
	DispQtAmixerSliders(MainWindow *mainwindow = 0, QWidget *parent = 0, const struct amixer_info_s *slider_info = 0);
	void aslider_config_style_apply(bool initial);
	void aslider_set_avformat(const struct amixer_info_s *cfg, bool video);
	void slider_set_center(void);
	void slider_reload_value(void);
	void spinbox_reload_value(void);

public Q_SLOTS:
	void slider_change_handler(int newval);
	void spinbox_change_handler(int newval);

private:
	int amixer_cv_calc_mixerval_to_sliderval(int value);
	int amixer_cv_mixerval_to_sliderval(void);
	void amixer_cv_sliderval_to_mixerval(int sliderval);

	MainWindow *main_window;
	QLabel *slider_label;
	DispQtmixerSlider *avmix_slider;
	QSpinBox *amix_spinbox;
	const char *amixer_name;
	struct one_mixerfunc_info *mixfunc;
	int value_max;
};

class DispQtAMixer : public QWidget
{
Q_OBJECT
public:
	DispQtAMixer(MainWindow *main_window = 0, QWidget *parent = 0);
	void amixer_config_style_apply(bool initial);
	void amixer_set_avformat(bool video);
	void amixer_buttons_reload(void);
	void amixer_sliders_reload(bool volume_only);

public Q_SLOTS:
	void amixer_switch_loudness(bool enable);
	void amixer_sliders_set_center(void);
	void amixer_switch_mute(bool enable);
	void amixer_switch_autovol(bool enable);
	void amixer_switch_crossfade(bool enable);
	void amixer_switch_cf_fadeout(bool enable);
	void amixer_switch_cf_fadein(bool enable);

protected:
	void keyPressEvent(QKeyEvent *event);

private:
	MainWindow *main_window;
	DispQtAmixerSliders *amixer_sliders[AMIXER_SLIDER_NUM];
	DispQtDialogElemPushButton *button_expand, *button_reset, *button_mute, *button_autovol;
	DispQtDialogElemPushButton *button_cf_enable, *button_cf_fout, *button_cf_fin;
};

class DispQtVmixerSliders : public QWidget
{
Q_OBJECT
public:
	DispQtVmixerSliders(MainWindow *mainwindow = 0, QWidget *parent = 0, int vmixerindex = 0, const char *name = NULL);
	void vslider_config_style_apply(bool initial);
	void slider_reinit(void);
	void slider_set_value(int value);

public Q_SLOTS:
	void slider_value_change_handler(int);

private:
	MainWindow *main_window;
	int vmixer_index;
	QLabel *slider_label;
	DispQtmixerSlider *avmix_slider;
	QSpinBox *avmix_spinbox;
};

class DispQtVMixer : public QWidget
{
Q_OBJECT
public:
	DispQtVMixer(MainWindow *main_window = 0, QWidget *parent = 0);
	void vmixer_config_style_apply(bool initial);

public Q_SLOTS:
	void vmixer_sliders_reinit(void);
	void vmixer_set_center(void);
	void vmixer_set_expand(void);

private:
	MainWindow *main_window;
	DispQtVmixerSliders *vmixer_sliders[VMIXER_SLIDER_NUM];
	DispQtDialogElemPushButton *button_expand, *button_reset;
};

class DispQtAVMixerWidget : public QTabWidget
{
Q_OBJECT
public:
	DispQtAVMixerWidget(MainWindow *main_window = 0, QWidget *parent = 0);
	DispQtAMixer *audio_mixer;

Q_SIGNALS:
	void signal_avmixer_config_style_apply(bool initial);
	void signal_avmixer_set_avformat(bool video);
	void signal_avmixer_sliders_reload(bool volume_only);

public Q_SLOTS:
	void avmixer_config_style_apply(bool initial);
	void avmixer_set_avformat(bool video);
	void avmixer_sliders_reload(bool volume_only);

protected:
	void keyPressEvent(QKeyEvent *event);

private:
	MainWindow *main_window;
	DispQtVMixer *video_mixer;
};

class DispQtAVMixerDialog : public DispQtDialogElemWindow
{
Q_OBJECT
public:
	DispQtAVMixerDialog(MainWindow *main_window = 0, QWidget *parent = 0);
	~DispQtAVMixerDialog();

Q_SIGNALS:
	void signal_avdialog_config_style_apply(bool initial);
	void signal_avdialog_set_avformat(bool video);
	void signal_avdialog_sliders_reload(bool volume_only);

public Q_SLOTS:
	void avdialog_config_style_apply(bool initial);
	void avdialog_set_avformat(bool video);
	void avdialog_sliders_reload(bool volume_only);

protected:
	bool event(QEvent *event);
	void closeEvent(QCloseEvent *);

private:
	MainWindow *main_window;
	DispQtAVMixerWidget *mixer_widget;
};

#endif
