#ifndef disp_qt_h
#define disp_qt_h

#include "mpxplay.h"
#include "control/control.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifdef MPXPLAY_LINK_ORIGINAL_FFMPEG
#include <libavcodec/avcodec.h>
#include <libavutil/channel_layout.h>
#include <guiddef.h>
#endif

extern int mpxplay_dispqt_main_start(int argc, char *argv[]);
extern void mpxplay_dispqt_main_close(void);
extern void mpxplay_dispqt_main_clean(void);

extern void mpxplay_dispqt_mouse_loadini(mpxini_line_t *,struct mpxini_part_t *);
extern void mpxplay_dispqt_mouse_init(void);
extern void mpxplay_dispqt_mouse_close(void);

extern void mpxplay_dispqt_driveselect_popup(unsigned int sidenum);

extern void mpxplay_dispqt_video_waitfor_init(void);
extern unsigned int mpxplay_dispqt_video_open(void *handler_id, char *utf8_filename);
extern unsigned int mpxplay_dispqt_video_close(void *handler_id);
extern unsigned int mpxplay_dispqt_video_is_open(void);
extern void mpxplay_dispqt_video_play(void);
extern void mpxplay_dispqt_video_pause(void);
extern mpxp_int64_t mpxplay_dispqt_video_duration_ms(void);
extern void mpxplay_dispqt_video_seek_ms(mpxp_int64_t newpos_ms);
extern mpxp_int64_t mpxplay_dispqt_video_tell_ms(void);
extern void mpxplay_dispqt_video_switch_fullscreen(void);
extern void mpxplay_dispqt_video_set_speed(int speed1000);
extern void mpxplay_dispqt_video_set_volume(int vol);
extern void mpxplay_dispqt_video_signal_stop(void);

extern void mpxplay_dispqt_avmixer_set_avformat(unsigned int extfile);

extern void mpxplay_dispqt_main_gui_config_reset_apply(void);

extern mpxp_bool_t mpxplay_dispqt_epgdialog_send_dtvdabse_epginfos(void *protocol_data);
extern mpxp_bool_t mpxplay_dispqt_epgdialog_send_scaninfos(void *protocol_data);
extern mpxp_bool_t mpxplay_dispqt_epgdialog_send_localfile_epginfos(void *protocol_data, char *filename);

extern void mpxplay_dispqt_system_opendefaultapplication(char *filename_utf8);

#ifdef MPXPLAY_LINK_ORIGINAL_FFMPEG
// main.cpp
extern int mpxplay_dispqt_ffmpegvideo_configcbk_check(unsigned int cfgcmd);
extern int mpxplay_dispqt_ffmpegvideo_config_callback(unsigned int cfgcmd, mpxp_ptrsize_t cbk_func, mpxp_ptrsize_t passdata);
extern int mpxplay_dispqt_ffmpegvideo_frame_display(int video_index, unsigned int flags, void *videoout_frame, void *subtitle_infos, unsigned int refresh_type);
extern int mpxplay_dispqt_ffmpegvideo_seekpreview_send(void *videoout_frame);

// video_widget.cpp
extern mpxp_bool_t mpxplay_dispqt_videowidget_videorender_static_init(void);
extern void mpxplay_dispqt_videowidget_videorender_static_close(void);
extern void mpxplay_dispqt_videowidget_videorender_mutex_lock(void);
extern void mpxplay_dispqt_videowidget_videorender_mutex_unlock(void);
extern void mpxplay_dispqt_videowidget_videorender_flush(mpxp_bool_t wait_for_completition);
extern mpxp_bool_t mpxplay_dispqt_videowidget_videorender_refer_d3ddevice(struct mpxplay_video_d3d_device_ref_s *d3d_device);
extern mpxp_bool_t mpxplay_dispqt_videowidget_videorender_detect_device_context_failure(void);

#endif

#ifdef __cplusplus
}
#endif

#ifndef DISPQT_MUTEX_TIMEOUT
#define DISPQT_MUTEX_TIMEOUT 5000
#endif

#ifndef DISPQT_MOUSE_WHEEL_SCALE
#define DISPQT_MOUSE_WHEEL_SCALE 120
#endif

// flags for callbacks
#define DISPQT_FLAG_MOUSE_BTN_LEFT_PRESSED   (1 << 0)
#define DISPQT_FLAG_MOUSE_BTN_RIGHT_PRESSED  (1 << 1)
#define DISPQT_FLAG_MOUSE_BTN_MIDDLE_PRESSED (1 << 2)
#define DISPQT_FLAG_MOUSE_BTN_ALL            (DISPQT_FLAG_MOUSE_BTN_LEFT_PRESSED | DISPQT_FLAG_MOUSE_BTN_RIGHT_PRESSED | DISPQT_FLAG_MOUSE_BTN_MIDDLE_PRESSED)

#define DISPQT_FLAG_KEYMOD_ALT     (1 << 4)
#define DISPQT_FLAG_KEYMOD_CTRL    (1 << 5)
#define DISPQT_FLAG_KEYMOD_SHIFT   (1 << 6)
#define DISPQT_FLAG_KEYMOD_ALL     (DISPQT_FLAG_KEYMOD_ALT | DISPQT_FLAG_KEYMOD_CTRL | DISPQT_FLAG_KEYMOD_SHIFT)

#define DISPQT_CB_FLAG_MULTYCALL (1 << 14)
#define DISPQT_CB_FLAG_MVPDATA   (1 << 15)

// custom (editor) flags shall begin at bit 16.
#define DISPQT_FLAGS_CUSTOM_MASK (~((1 << 16) - 1))

struct dispqt_callbackdata_s {
	unsigned long flags;
	unsigned int sidenum;
	unsigned int tabnum;
	int linenum;
};

struct dispqt_currfileinfo_s {
	int currtimelen;
	int currsongnum;
	int allsongnum;
	char prev_title[256];
	char curr_title[256];
	char next_title[256];
};

extern void mpxplay_dispqt_mainthread_callback_init(void *func, void *passinfo, unsigned long editor_cb_flags);

#endif // disp_qt_h
